<?php
/**
 * SEF module for Joomla!
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

class sefext_com_content extends sef_joomsef
{
    function beforeCreate($string, &$vars) {
        global $database;

        $params = SEFTools::GetExtParams('com_content');

        // Change task=view to view=article for old urls
        if( isset($vars['task']) && ($vars['task'] == 'view') ) {
            $vars['view'] = 'article';
            $string .= '&view=article';
            $string = SEFTools::RemoveVariable($string, 'task');
        }
        
        // Remove the limitstart and limit variables if they point to the first page
        if( isset($vars['limitstart']) && ($vars['limitstart'] == '0') ) {
            $string = SEFTools::RemoveVariable($string, 'limitstart');
            $string = SEFTools::RemoveVariable($string, 'limit');
        }

        // Try to guess the correct Itemid if set to
        if( $params->get('guessId', '0') != '0' ) {
            if( isset($vars['Itemid']) && isset($vars['id']) ) {
                global $mainframe;
                $string = SEFTools::RemoveVariable($string, 'Itemid');
                $i = $mainframe->getItemid($vars['id']);
                $string .= '&Itemid='.$i;
            }
        }

        // Remove the part after ':' from variables
        if( !empty($vars['id']) )       SEFTools::fixVariable($vars['id'], $string);
        if( !empty($vars['catid']) )    SEFTools::fixVariable($vars['catid'], $string);

        // If catid not given, try to find it
        if( isset($vars['view']) && ($vars['view'] == 'article') && !empty($vars['id']) && empty($vars['catid']) ) {
            $query = "SELECT `catid` FROM `#__content` WHERE `id` = '{$vars['id']}'";
            $database->setQuery($query);
            $catid = $database->loadResult();

            if( !empty($catid) ) {
                $string .= "&catid=$catid";
            }
        }

        return $string;
    }

    function create($string, &$vars) {
        global $sefConfig;

        $params = SEFTools::GetExtParams('com_content');

        extract($vars);

        // Set title.
        $title = array();

        switch (@$view) {
            case 'new': {
                /*
                $title[] = getMenuTitle($option, $task, $Itemid, $string);
                $title[] = 'new' . $sefConfig->suffix;
                */
                break;
            }
            case 'archivecategory':
            case 'archivesection': {
                if (eregi($task.".*id=".$id, $_SERVER['REQUEST_URI'])) break;
            }
            default: {
                if( isset($format) ) {
                    if( $format == 'pdf') {
                        // Create PDF
                        $title = sef_joomsef::getContentTitles('article', $id);
                        if (count($title) === 0) $title[] = getMenuTitle(@$option, @$task, @$Itemid);

                        $title[] = JText::_('PDF');
                    } elseif( $format == 'feed' ) {
                        // Create feed
                        $title = sef_joomsef::getContentTitles('article', $id);
                        if (count($title) === 0) $title[] = getMenuTitle(@$option, @$task, @$Itemid);

                        if( !empty($type) ) $title[] = $type;
                    }
                } else {
                    if( isset($id) ) {
                        $title = sef_joomsef::getContentTitles(@$view, @$id);
                        if (count($title) === 0) $title[] = getMenuTitle(@$option, @$task, @$Itemid);
                        
                        // Add content ID if set to
                        if( $params->get('titleid', '0') != '0' ) {
                            $i = count($title) - 1;
                            $title[$i] = $id . '-' . $title[$i];
                        }

                        if ((@$view == 'article') && isset($sefConfig->suffix)) {
                            $title[count($title) - 1] .= $sefConfig->suffix;
                        }
                        else {
                            $title[] = '/';
                        }
                    } else {
                        $title[] = getMenuTitle(@$option, @$task, @$Itemid);
                        //$title[] = JText::_('Submit');
                    }

                    if( isset($limitstart) && (!$sefConfig->appendNonSef || ($params->get('pagination', '0') == '0')) ) {
                        $title[] .= JText::_('Page') . '-' . ($limitstart+1);
                    }

                    if( isset($showall) && ($showall == 1) ) {
                        $title[] = JText::_('All Pages');
                    }

                    if( isset($print) && ($print == 1) ) {
                        // Print article
                        $title[] = JText::_('Print') . (!empty($page) ? '-'.($page+1) : '');
                    }
                }
            }
        }
        if (count($title) > 0) {
            $nonSefVars = array();
            if( $sefConfig->appendNonSef && ($params->get('pagination', '0') != '0') ) {
                if( isset($limit) )         $nonSefVars['limit'] = $limit;
                if( isset($limitstart) )    $nonSefVars['limitstart'] = $limitstart;
            }

            $string = sef_joomsef::sefGetLocation($string, $title, null, null, null, @$lang, $nonSefVars);
        }

        return $string;
    }
}
?>