<?php
//
// @package garycookbook for Joomla 1.0.x
// A Joomla Cookbook Component
// based on AKOgallery by Arthur Konze
// @Author Gerald Berger
// Copyright (C) 2007  by Gerald Berger   All Rights Reserved
// Homepage   : www.vb-dozent.net
// Version    : 2.4.2
// Secuity Images modified by
// Meru <  >  http://www.burg.rauchfusz.de <  > icedogg211@aol.com
// Joss Sanglier http://www.ancingbear.co.uk joss@dancingbear.co.uk
// Bot Support in Recipe Contents
//
// License    : @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//


// Don't allow direct linking
defined ( '_VALID_MOS' ) or die ( 'Direct Access to this location is not allowed.' );
// Variables - Don't change anything here!!!
require ($mosConfig_absolute_path . "/administrator/components/com_garyscookbook/config.garyscookbook.php");
require_once ("$mosConfig_absolute_path/administrator/includes/pcl/pclzip.lib.php");
$temppath = $mosConfig_live_site . "/media/";
$picturepath = $mosConfig_live_site . $ag_pathimages . "/";
$thumbnailpath = $mosConfig_live_site . $ag_paththumbs . "/";

$cookbookversion = "Gary�s Cookbook 2.4.2 by Gerald Berger";
// security image by www.waltercedric.com
if (file_exists ( $mosConfig_absolute_path . '/administrator/components/com_securityimages/client.php' )) {
	include ($mosConfig_absolute_path . '/administrator/components/com_securityimages/client.php');
	include ($mosConfig_absolute_path . '/administrator/components/com_securityimages/server.php');
} else
	($secimg = "1");
	// Check for Editor rights
if ($my->usertype == 'Editor' || $my->usertype == 'Administrator' || $my->usertype == 'Super Administrator') {
	$is_editor = true;
	$is_registered = true;
	$is_author = true;
} else {
	if ($my->usertype == 'Author' || $my->usertype == 'Editor' || $my->usertype == 'Administrator' || $my->usertype == 'Super Administrator') {
		$is_registered = true;
		$is_author = true;
		$is_editor = false;
	} else {
		if ($my->usertype == 'Author' || $my->usertype == 'Registered' || $my->usertype == 'Editor' || $my->usertype == 'Administrator' || $my->usertype == 'Super Administrator') {
			$is_registered = true;
			$is_author = false;
			$is_editor = false;
		} else {
			$is_author = false;
			$is_editor = false;
			$is_registered = false;
		}
	}
}

$is_user = (strtolower ( $my->usertype ) != '');
// CHECK LANGUAGE
if (! defined ( '_garyscookbook_LANG_INCLUDED' )) {
	if (file_exists ( $mosConfig_absolute_path . "/administrator/components/com_garyscookbook/language/" . $mosConfig_lang . ".php" )) {
		include_once ($mosConfig_absolute_path . "/administrator/components/com_garyscookbook/language/" . $mosConfig_lang . ".php");
	} else {
		include_once ($mosConfig_absolute_path . "/administrator/components/com_garyscookbook/language/english.php");
	}
}

/**
 * editcookbook()
 *
 * @param mixed $option
 * @param mixed $row
 * @param mixed $clist
 * @param mixed $imagelist
 * @param mixed $thumblist
 * @param mixed $ag_pathimages
 * @param mixed $ag_paththumbs
 * @param mixed $ag_upload
 * @return
 */
function editcookbook($option, &$row, &$clist, &$imagelist, &$thumblist, $ag_pathimages, $ag_paththumbs, $ag_upload) {
	global $mosConfig_live_site, $cookbookversion, $ag_secimagerec, $mosConfig_absolute_path, $ag_zpics;
	
	?>
<script language="javascript" type="text/javascript">

    function submitbutton(pressbutton) {
      var form = document.adminForm;
      if (pressbutton == 'cancel') {
        submitform( pressbutton );
        return;
      }
      // do field validation
      if (form.imgtitle.value == ""){
        alert( "Item must have a title" );
        return false;
      } else if (form.catid.value == "0"){
        alert( "You must select a category." );
        return false;
	  } else {
        //submitform( pressbutton );
        document.adminForm.method = "post";
        document.adminForm.action = "<?php
	echo "index.php?option=com_garyscookbook&func=save&Itemid=0"?>";
        document.adminForm.submit();

      }
    }

    </script>

<!--<form action="index.php?option=com_garyscookbook&func=save&Itemid=0" method="post" enctype="multipart/form-data" name="adminForm" id="adminForm" >-->
<form name="adminForm" id="adminForm" enctype="multipart/form-data"
	onsubmit="return submitbutton()">
<table cellpadding="4" cellspacing="1" border="0" width="100%"
	class="adminform">
	<tr>
		<td width="20%" align="left"><?php
	echo _garyscookbook_DT_NAME;
	?>:</td>
		<td width="20%" colspan="4"><input class="inputbox" type="text"
			name="imgtitle" size="50" maxlength="100"
			value="<?php
	echo htmlspecialchars ( $row->imgtitle, ENT_QUOTES );
	?>" /></td>
	</tr>
<?php
	if ($ag_upload) {
		echo "<tr>";
		echo "<td width='20%' align='left'>" . _garyscookbook_PICUPLOAD . ":</td>";
		echo "<td width='20%'  colspan='4'>";
		echo "  <input type='file' size= '40' maxlength='10000000' name='screenshot' /><br />";
		echo "</td>";
		if ($ag_zpics == "1") {
			echo "</tr><tr>";
			echo "<td width='20%' align='left'>" . _gkb_Pic . " 1:</td>";
			echo "<td width='20%'  colspan='4'>";
			echo "  <input type='file' size= '40' maxlength='10000000' name='pic1' /><br />";
			echo "</td>";
			echo "</tr><tr>";
			echo "<td width='20%' align='left' >" . _gkb_Pic . " 2:</td>";
			echo "<td width='20%'  colspan='4'>";
			echo "  <input type='file' size= '40' maxlength='10000000' name='pic2' /><br />";
			echo "</td>";
			echo "</tr><tr>";
			echo "<td width='20%' align='left' >" . _gkb_Pic . " 3:</td>";
			echo "<td width='20%'  colspan='4'>";
			echo "  <input type='file' size= '40' maxlength='10000000' name='pic3' /><br />";
			echo "</td>";
			echo "</tr><tr>";
			echo "<td width='20%' align='left' >" . _gkb_Pic . " 4:</td>";
			echo "<td width='20%'  colspan='4'>";
			echo "  <input type='file' size= '40' maxlength='10000000' name='pic4' /><br />";
			echo "</td>";
		}
	}
	
	?>
      </tr>
	<tr>
		<td valign="top" align="left"><?php
	echo _garyscookbook_ADMIN_CATEGORY;
	?>:</td>
		<td>
          <?php
	echo $clist;
	?>
        </td>
	</tr>

	<tr>
		<td valign="top" align="left" colspan="5"><?php
	echo _garyscookbook_DT_DESC;
	?>:</td>
	</tr>
	<tr>
		<td colspan="5">
         <?php
	editorArea ( 'editor1', $row->imgtext, 'imgtext', 600, 200, '50', '100' );
	
	?>
		</td>
	</tr>
	<tr>
		<td valign="top" align="left" colspan="5"><?php
	echo _garyscookbook_GRAPES;
	?>:</td>
	</tr>
	<tr>
		<td colspan="5">
        	<?php
	editorArea ( 'editor2', $row->grapes, 'grapes', 600, 200, '50', '100' );
	
	?>
        </td>
	</tr>
	<tr>
		<td valign="top" align="left" colspan="5"><?php
	echo _garyscookbook_PROPERTIES;
	?>:</td>
	</tr>
	<tr>
		<td colspan="5">
		    <?php
	editorArea ( 'editor3', $row->properties, 'properties', 600, 300, '50', '100' );
	
	?>
        </td>
	</tr>
	<tr>
		<td valign="top" align="left" colspan="5"><?php
	echo _garyscookbook_NOTES;
	?>:</td>
	</tr>
	<tr>
		<td colspan="5">
		    <?php
	editorArea ( 'editor4', $row->notes, 'notes', 600, 150, '50', '100' );
	
	?>
        </td>
	</tr>
	<tr>
		<td valign="top" align="left"><?php
	echo _garyscookbook_AUTHOR;
	?>:</td>
		<td colspan="4"><input class="inputbox" type="text" name="imgauthor"
			value="<?php
	echo $row->imgauthor;
	?>" size="50" maxlength="100" /></td>
	</tr>
	<tr>
		<td width="20%" align="left"><?php
	echo _garyscookbook_PORTION;
	?>:</td>
		<td width="20%">
          <?php
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_1, _gkb_level_of_servings_1 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_2, _gkb_level_of_servings_2 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_3, _gkb_level_of_servings_3 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_4, _gkb_level_of_servings_4 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_5, _gkb_level_of_servings_5 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_6, _gkb_level_of_servings_6 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_7, _gkb_level_of_servings_7 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_8, _gkb_level_of_servings_8 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_9, _gkb_level_of_servings_9 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_10, _gkb_level_of_servings_10 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_11, _gkb_level_of_servings_11 );
	$selist [] = mosHTML::makeOption ( _gkb_level_of_servings_12, _gkb_level_of_servings_12 );
	$selist_ag_showportion = mosHTML::selectList ( $selist, 'portion', 'class="inputbox" size="1"', 'value', 'text', $row->portion );
	echo $selist_ag_showportion;
	
	?>
        </td>
		<td width="15%" align="left"><?php
	echo _gkb_amount;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text" name="amount"
			size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->amount, ENT_QUOTES );
	?>" /></td>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td width="20%" align="left"><?php
	echo _garyscookbook_YEAR;
	?>:</td>
		<td width="20%">
          <?php
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_1, _gkb_level_of_MKT_1 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_2, _gkb_level_of_MKT_2 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_3, _gkb_level_of_MKT_3 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_4, _gkb_level_of_MKT_4 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_5, _gkb_level_of_MKT_5 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_6, _gkb_level_of_MKT_6 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_7, _gkb_level_of_MKT_7 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_8, _gkb_level_of_MKT_8 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_9, _gkb_level_of_MKT_9 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_10, _gkb_level_of_MKT_10 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_11, _gkb_level_of_MKT_11 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_12, _gkb_level_of_MKT_12 );
	$selist2 [] = mosHTML::makeOption ( _gkb_level_of_MKT_13, _gkb_level_of_MKT_13 );
	$selist_ag_showtime = mosHTML::selectList ( $selist2, 'years', 'class="inputbox" size="1"', 'value', 'text', $row->years );
	echo $selist_ag_showtime;
	
	?>
        </td>
		<td width="15%" align="left"><?php
	echo _garyscookbook_AGING;
	?>:</td>
		<td width="20%">
          <?php
	$selist1 [] = mosHTML::makeOption ( _gkb_level_of_difficulty_0, _gkb_level_of_difficulty_0 );
	$selist1 [] = mosHTML::makeOption ( _gkb_level_of_difficulty_1, _gkb_level_of_difficulty_1 );
	$selist1 [] = mosHTML::makeOption ( _gkb_level_of_difficulty_2, _gkb_level_of_difficulty_2 );
	$selist1 [] = mosHTML::makeOption ( _gkb_level_of_difficulty_3, _gkb_level_of_difficulty_3 );
	$selist1 [] = mosHTML::makeOption ( _gkb_level_of_difficulty_4, _gkb_level_of_difficulty_4 );
	$selist_ag_showdifficul = mosHTML::selectList ( $selist1, 'aging', 'class="inputbox" size="1"', 'value', 'text', $row->aging );
	echo $selist_ag_showdifficul;
	
	?>
        </td>
		<td>&nbsp;</td>

	</tr>
	<tr>
		<td width="20%" align="left"><?php
	echo _garyscookbook_COUNTRY;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text" name="country"
			size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->country, ENT_QUOTES );
	?>" /></td>
		<td width="15%" align="left"><?php
	echo _garyscookbook_PRICE;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text" name="price"
			size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->price, ENT_QUOTES );
	?>" /></td>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td width="20%" align="left"><?php
	echo _garyscookbook_DOC;
	?>:</td>
		<td width="20%">
          <?php
	$yn_ag_showdetail = mosHTML::yesnoRadioList ( 'doc', 'class="inputbox"', $row->doc );
	echo $yn_ag_showdetail;
	
	?>
        </td>
		<td width="15%" align="left"><?php
	echo _gkb_laktose;
	?>:</td>
		<td width="20%">
          <?php
	$yn_ag_laktose = mosHTML::yesnoRadioList ( 'laktose', 'class="inputbox"', $row->laktose );
	echo $yn_ag_laktose;
	
	?>
        </td>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td width="20%" align="left"><?php
	echo _gkb_diaet;
	?>:</td>
		<td width="20%">
          <?php
	$yn_ag_diaet = mosHTML::yesnoRadioList ( 'diaet', 'class="inputbox"', $row->diaet );
	echo $yn_ag_diaet;
	
	?>
        </td>
		<td width="15%" align="left"><?php
	echo _gkb_gluten;
	?>:</td>
		<td width="20%">
          <?php
	$yn_ag_gluten = mosHTML::yesnoRadioList ( 'gluten', 'class="inputbox"', $row->gluten );
	echo $yn_ag_gluten;
	
	?>
        </td>
		<td>&nbsp;</td>

	</tr>
	<tr>
		<td width="20%" align="left"><?php
	echo _gkb_kcal;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text" name="kcal"
			size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->kcal, ENT_QUOTES );
	?>" /></td>
		<td width="15%" align="left"><?php
	echo _gkb_kjoule;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text" name="kjoule"
			size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->kjoule, ENT_QUOTES );
	?>" /></td>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td width="20%" align="left"><?php
	echo _gkb_fat;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text" name="fat"
			size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->fat, ENT_QUOTES );
	?>" /></td>
		<td width="15%" align="left"><?php
	echo _gkb_breadunit;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text" name="breadunit"
			size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->breadunit, ENT_QUOTES );
	?>" /></td>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td width="20%" align="left"><?php
	echo _gkb_protein;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text" name="protein"
			size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->protein, ENT_QUOTES );
	?>" /></td>
		<td width="20%" align="left"><?php
	echo _gkb_carbohydrates;
	?>:</td>
		<td width="20%"><input class="inputbox" type="text"
			name="carbohydrates" size="20" maxlength="20"
			value="<?php
	echo htmlspecialchars ( $row->carbohydrates, ENT_QUOTES );
	?>" /></td>
		<td>&nbsp;</td>
	</tr>

	<tr>
		<td colspan="5">&nbsp;</td>
	</tr>
</table>
<table>
	  <?php
	if ($secimg != "1" and $ag_secimagerec) {
		echo "<tr><td>&nbsp;</td><td width='80%' align='left'>";
		include ($mosConfig_absolute_path . '/components/com_garyscookbook/garyscookbooksec.html.php');
		echo "</td></tr>";
	}
	?>
	  <tr>
		<td width="20%" align="right">&nbsp;</td>
		<td width="80%"><input type="submit" name="submit"
			value="<?php
	echo _garyscookbook_SUBMIT;
	?>" class="button"></td>
	</tr>
	<input type="hidden" name="id" value="<?php
	echo $row->id;
	?>" />
	<input type="hidden" name="option" value="<?php
	echo $option;
	?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="MAX_FILE_SIZE" value="1000000" />
</table>
</form>
<?php

}

/**
 * catdescription()
 * Shows the full category description with the image.
 * @param mixed $id
 * @return
 */
function catdescription($id) {
	global $database, $thumbnailpath;
	// MAIN CATEGORY TITLE IMAGE AND DESCRIPTION ON VIEWCATEGORY PAGE
	$database->setQuery ( "SELECT * FROM #__categories WHERE id = '" . $id . " ORDER BY name'" );
	$rows2 = $database->loadObjectList ();
	$row2 = $rows2 [0];
	echo "<div>";
	if ($row2->image != "") {
		if ($ag_catTumb) {
			echo "<img src='$thumbnailpath$row2->image' align='left' hspace='4' border='0' />";
		} else {
			echo "<img src='images/stories/$row2->image' align='left' hspace='4' border='0' />";
		}
	}
	echo "<h2>";
	echo stripslashes ( $row2->title );
	echo "</h2>";
	echo $row2->description;
	echo "</div>";
}

/**
 * cookbookHeader()
 *
 * @param mixed $addOnOff
 * @return
 */
function cookbookHeader($addOnOff) {
	global $func, $database, $id, $Itemid, $catid, $is_editor, $is_author, $is_registered, $ag_showrating, $ag_regonly, $ag_offlinecookbook, $ag_offlinemsg, $ag_showcomment, $ag_postnewcookbook, $ag_editorpostnewcookbook, $mosConfig_live_site, $ag_pic_path, $ag_introtext;
	echo "<table width='98%' cellpadding='3' cellspacing='4' border='0' align='center' class='newspane'>";
	if ($ag_pic_path) {
		echo "<tr><td class='componentheading'><img src='" . $ag_pic_path . "' hspace='6' border='0' align='absmiddle' /></td></tr>";
	} else {
		echo "<tr><td class='componentheading'>" . _garyscookbook_TITLE . "</td></tr>";
	}
	echo "<tr><td>";
	echo "<table width='100%' border='0' cellspacing='0' cellpadding='3'><tr>";
	echo "<td><img src='components/com_garyscookbook/images/home.gif' hspace='6' border='0' align='absmiddle'/>";
	if ($func != 'detail') {
		echo ShowCategoryPathLink ( $id );
	} else if ($id) {
		$database->setQuery ( "SELECT a.*, cc.title AS category" . "\nFROM #__garyscookbook AS a, #__categories AS cc" . "\nWHERE a.catid=cc.id AND a.id=$id" );
		$rows = $database->loadObjectList ();
		$row = &$rows [0];
		echo ShowCategoryPathLink ( $row->catid );
	}
	echo "</td>";
	echo "<td align='right'>";
	echo "<form name='searchgalform' action='index.php' target= 'top' method='post'>";
	echo "<input type='hidden' name='option' value='com_garyscookbook' /><input type='hidden' name='itemid' value='$Itemid'/>";
	echo "<input type='hidden' name='func' value='special'/><input type='hidden' name='sorting' value='find'/>";
	echo "<input type='text' name='sstring' style='border: 1px solid; font: 10px Arial; width: 150px' onblur=\"if(this.value=='') this.value='" . _garyscookbook_SEARCHBOX . "';\" onfocus=\"if(this.value=='" . _garyscookbook_SEARCHBOX . "') this.value='';\" value='" . _garyscookbook_SEARCHBOX . "'/></form>";
	echo "</td>";
	echo "</tr></table></td></tr>";
	if ($addOnOff) {
		echo "<tr><td align='left'>";
		echo stripslashes ( $ag_introtext );
		echo "</td></tr>";
	}
	echo "<tr><td align='right'>";
	echo '<a href="' . sefRelToAbs ( 'index.php?option=com_garyscookbook&Itemid=$Itemid&func=special' ) . '">' . _garyscookbook_MOST_VIEWED . '</a>';
	if ($ag_showrating) 
		echo ' - <a href="' .sefRelToAbs('index.php?option=com_garyscookbook&Itemid=$Itemid&func=special&sorting=rating') .'">' . _garyscookbook_TOP_RATED . "</a>";
	
	echo ' - <a href="' .sefRelToAbs('index.php?option=com_garyscookbook&Itemid=$Itemid&func=special&sorting=lastadd'). '">' . _garyscookbook_LAST_ADDED . "</a>";
	if ($ag_showcomment) 
		echo ' - <a href="' .sefRelToAbs('index.php?option=com_garyscookbook&Itemid=$Itemid&func=special&sorting=lastcomment') .'">' . _garyscookbook_LAST_COMMENTED . "</a>";
	
	echo "</td></tr>";
	if ($ag_postnewcookbook == '1') {
		// Editor
		if (($ag_editorpostnewcookbook == '3' && $is_editor)) {
			echo "<tr><td>";
			echo "<div align='center'>";
			echo " <a href='" .sefRelToAbs('index.php?option=com_garyscookbook&func=newItem'). "'><img src='components/com_garyscookbook/images/new.png' hspace='6' border='0' align='absmiddle' alt='" . _garyscookbook_ADD_cookbook . "'>" . _garyscookbook_ADD_cookbook . "</a>";
			echo "</div>";
			echo "</td></tr>";
		} else {
			if (($ag_editorpostnewcookbook == '2' && $is_registered)) {
				echo "<tr><td>";
				echo "<div align='center'>";
				echo " <a href='" . sefRelToAbs('index.php?option=com_garyscookbook&func=newItem') . "'><img src='components/com_garyscookbook/images/new.png' hspace='6' border='0' align='absmiddle' alt='" . _garyscookbook_ADD_cookbook . "'>" . _garyscookbook_ADD_cookbook . "</a>";
				echo "</div>";
				echo "</td></tr>";
			} else {
				if (($ag_editorpostnewcookbook == '1' && $is_author)) {
					echo "<tr><td>";
					echo "<div align='center'>";
					echo " <a href='" .sefRelToAbs( 'index.php?option=com_garyscookbook&func=newItem'). "'><img src='components/com_garyscookbook/images/new.png' hspace='6' border='0' align='absmiddle' alt='" . _garyscookbook_ADD_cookbook . "'>" . _garyscookbook_ADD_cookbook . "</a>";
					echo "</div>";
					echo "</td></tr>";
				} else {
					if (($ag_editorpostnewcookbook == '0')) {
						echo "<tr><td>";
						echo "<div align='center'>";
						echo " <a href='" .sefRelToAbs('index.php?option=com_garyscookbook&func=newItem') ."'><img src='components/com_garyscookbook/images/new.png' hspace='6' border='0' align='absmiddle' alt='" . _garyscookbook_ADD_cookbook . "'>" . _garyscookbook_ADD_cookbook . "</a>";
						echo "</div>";
						echo "</td></tr>";
					}
				}
			}
		}
	}
	echo "<tr><td>";
	return;
}

/**
 * functionheader()
 *
 * @return
 */
function functionheader() {
	global $func, $database, $id, $Itemid, $catid, $is_editor, $ag_showrating, $ag_regonly, $ag_offlinecookbook, $ag_offlinemsg, $ag_showcomment, $ag_postnewcookbook, $ag_editorpostnewcookbook, $mosConfig_live_site, $ag_pic_path;
	echo "<TABLE WIDTH='98%' CELLPADDING='3' CELLSPACING='4' BORDER='0' ALIGN='center' class='newspane'>";
	if ($ag_pic_path) {
		echo "<tr><td class='componentheading'><img src='" . $ag_pic_path . "' hspace='6' border='0' align='absmiddle' /></td></tr>";
	} else {
		echo "<tr><td class='componentheading'>" . _garyscookbook_TITLE . "</td></tr>";
	}
	echo "<tr><td>";
	#echo "</td></tr><tr></tr><tr><td>";
	return;
}

/**
 * savePost()
 *
 * @return
 */
function savePost() {
	global $database, $my, $fromUser, $is_editor, $screenshot_name, $ag_secimagerec, $mosConfig_absolute_path, $security_refid, $security_try, $pic1_name, $pic2_name, $pic3_name, $pic4_name;
	include ('administrator/components/com_garyscookbook/class.garyscookbook.php');
	include ('administrator/components/com_garyscookbook/config.garyscookbook.php');
	if (file_exists ( $mosConfig_absolute_path . '/administrator/components/com_securityimages/server.php' )) {
		include ($mosConfig_absolute_path . '/administrator/components/com_securityimages/server.php');
	} else
		($secimg = "1");
	if ($secimg != "1") {
		$GKB_refid = mosGetParam ( $_REQUEST, 'GKB_refid', '' );
		$GKB_try = mosGetParam ( $_REQUEST, 'GKB_try', '' );
		$checkSecurity = checkSecurityImage ( $GKB_refid, $GKB_try );
	}
	if ($secimg != "1" and $ag_secimagerec) {
		if ($checkSecurity == false) {
			echo "<script> alert('" . _gkb_security . "');window.history.go(-1); </script>\n";
			exit ();
		}
	}
	
	$newcookbook = new mosgaryscookbook ( $database );
	$newcookbook->price = mosGetParam ( $_POST, "price", $newcookbook->price );
	$newcookbook->imgtitle = mosGetParam ( $_POST, "imgtitle", $newcookbook->imgtitle );
	$newcookbook->catid = mosGetParam ( $_POST, "catid", $newcookbook->catid );
	$newcookbook->imgtext = mosGetParam ( $_POST, "imgtext", $newcookbook->imgtext, 0x0003 );
	$newcookbook->grapes = mosGetParam ( $_POST, "grapes", $newcookbook->grapes, 0x0003 );
	$newcookbook->properties = mosGetParam ( $_POST, "properties", $newcookbook->properties, 0x0003 );
	$newcookbook->notes = mosGetParam ( $_POST, "notes", $newcookbook->notes );
	$newcookbook->imgauthor = mosGetParam ( $_POST, "imgauthor", $newcookbook->imgauthor );
	$newcookbook->imgdate = mktime ();
	$newcookbook->imgfilename = $screenshot_name;
	$newcookbook->imgthumbname = tn_ . $screenshot_name;
	$newcookbook->expic1 = $pic1_name;
	$newcookbook->expic1_tn = tn_ . $pic1_name;
	$newcookbook->expic2 = $pic2_name;
	$newcookbook->expic2_tn = tn_ . $pic2_name;
	$newcookbook->expic3 = $pic3_name;
	$newcookbook->expic3_tn = tn_ . $pic3_name;
	$newcookbook->expic4 = $pic4_name;
	$newcookbook->expic4_tn = tn_ . $pic4_name;
	$newcookbook->portion = mosGetParam ( $_POST, "portion", $newcookbook->portion );
	$newcookbook->aging = mosGetParam ( $_POST, "aging", $newcookbook->aging );
	$newcookbook->years = mosGetParam ( $_POST, "years", $newcookbook->years );
	$newcookbook->country = mosGetParam ( $_POST, "country", $newcookbook->country );
	$newcookbook->doc = mosGetParam ( $_POST, "doc", $newcookbook->doc );
	$newcookbook->laktose = mosGetParam ( $_POST, "laktose", $newcookbook->laktose );
	$newcookbook->diaet = mosGetParam ( $_POST, "laktose", $newcookbook->laktose );
	$newcookbook->gluten = mosGetParam ( $_POST, "gluten", $newcookbook->gluten );
	$newcookbook->amount = mosGetParam ( $_POST, "amount", $newcookbook->amount );
	$newcookbook->kcal = mosGetParam ( $_POST, "kcal", $newcookbook->kcal );
	$newcookbook->kjoule = mosGetParam ( $_POST, "kjoule", $newcookbook->kjoule );
	$newcookbook->fat = mosGetParam ( $_POST, "fat", $newcookbook->fat );
	$newcookbook->breadunit = mosGetParam ( $_POST, "breadunit", $newcookbook->breadunit );
	$newcookbook->protein = mosGetParam ( $_POST, "protein", $newcookbook->protein );
	
	$newcookbook->published = 0;
	if ($is_editor) {
		$newcookbook->published = 1;
	}
	// DATA VALIDATION
	if ($newcookbook->imgtitle == null || $newcookbook->imgtitle == "" || $newcookbook->catid <= 0) {
		echo "<script> alert('" . _garyscookbook_NO_CATEGORIE . "'); window.history.go(-1); </script>\n";
		exit ();
	}
	if (! $newcookbook->store ()) {
		echo "<script> alert('" . $newcookbook->getError () . "'); window.history.go(-1); </script>\n";
		exit ();
	}
	if ($is_editor) {
		echo "<br><br><div align='center'>" . _garyscookbook_ADD_SUCCESS_EDITOR . "<br>";
		echo "<a href='javascript:void%20window.history.go(-2)'>" . _garyscookbook_Back . "</a></div>";
	} else {
		echo "<br><br><div align='center'>" . _garyscookbook_ADD_SUCCESS . "<br><br>";
		echo "<a href='javascript:void%20window.history.go(-2)'>" . _garyscookbook_Back . "</a></div>";
	}
	// messaging for new items to administrators
	require_once ("components/com_messages/messages.class.php");
	$msg = new mosMessage ( $database );
	$database->setQuery ( "SELECT id FROM #__users WHERE sendEmail='1'" );
	$users = $database->loadResultArray ();
	foreach ( $users as $user_id ) {
		if ($my->id > 0) {
			$msg->send ( $my->id, $user_id, "New recipe in cookbook FROM " . $my->username, sprintf ( "New recipe:" . $newcookbook->imgtitle . " FROM " . $my->username, $my->username, $newcookbook->imgtitle ) );
		} else { // messaggio da anonimo (utente non registrato)
			$msg->send ( $user_id, $user_id, "New recipe in cookbook FROM Anonymous", sprintf ( "New recipe:" . $newcookbook->imgtitle . " FROM Anonymous", $my->username, $newcookbook->imgtitle ) );
		}
	}
	if ($ag_sendEmail > 0 && $ag_sendEmailAddress != "" && $ag_sendEmailAddress != null) {
		if ($my->id > 0) {
			$fromUser = $my->username;
		} else { // messaggio da anonimo (utente non registrato)
			$fromUser = "Anonymous";
		}
		$subject = _garyscookbook_ADD_SUBJECT . $fromUser;
		$message = _garyscookbook_ADD_MESSAGE . $newcookbook->imgtitle . "\r \n";
		$message .= _garyscookbook_ADD_MESSAGE2;
		$headers = "From: $ag_sendEmailAddress\r\n";
		$headers .= "Reply-To: $ag_sendEmailAddress\r\n";
		$headers .= "X-Priority: 3\r\n";
		$headers .= "X-MSMail-Priority: Low\r\n";
		$headers .= "X-Mailer: Mambo Open Source 4.5\r\n";
		mail ( $ag_sendEmailAddress, $subject, $message, $headers );
	}
}

/**
 * cookbookFooter()
 *
 * @return
 */
function cookbookFooter() {
	global $cookbookversion, $is_editor, $id, $cookbook_showlogo, $showedit, $Itemid;
	echo "	<table cellpadding='4' cellspacing='0' border='0' width='100%'>";
	if ($is_editor) {
		if ($id) {
			if ($showedit) {
				echo "<tr><td align='right'><img src='components/com_garyscookbook/images/edit.gif' hspace='6' border='0' align='absmiddle'><a href='" . sefRelToAbs( "index.php?option=com_garyscookbook&Itemid=$Itemid&func=editpic&id=$id") .  "'>" . _garyscookbook_EDIT_RECIPE . "</a></td></tr>";
			}
		}
	}
	// show/hide cookbook logo
	if ($cookbook_showlogo) {
		//echo "		<tr>";
		//echo "<td><p>&nbsp;</p></td></tr>";
		echo "	 <tr><td><div align='center'><br/><a href='http://www.vb-dozent.net' target='_new'><img src='administrator/components/com_garyscookbook/images/logo_small.png'/></a></div></td></tr>";
		//echo "<tr><td><p>&nbsp;</p></td></tr>";
	} else {
		echo "	<br>";
	}
	// echo "		</tr>";
	echo "		<tr>";
	echo "			<td><div align='center'><font class='smalldark'><b><a href='mailto:gerald@vb-dozent.net'>" . $cookbookversion . "</a></b> - <a href='http://www.vb-dozent.net' target='_new'>www.vb-dozent.net</a>  </font></div></td>";
	echo "		</tr>";
	//echo "<tr><td><p>&nbsp;</p></td></tr>";
	echo "	</table>";
	echo "</td></tr></table>";
	return;
}

/**
 * bb_decode()
 *
 * @param mixed $text
 * @return
 */
function bb_decode($text) {
	$text = nl2br ( $text );
	static $bbcode_tpl = array ( );
	static $patterns = array ( );
	static $replacements = array ( );
	// First: If there isn't a "[" and a "]" in the message, don't bother.
	if ((strpos ( $text, "[" ) === false || strpos ( $text, "]" ) === false)) {
		return $text;
	}
	// [b] and [/b] for bolding text.
	$text = str_replace ( "[b]", '<b>', $text );
	$text = str_replace ( "[/b]", '</b>', $text );
	// [u] and [/u] for underlining text.
	$text = str_replace ( "[u]", '<u>', $text );
	$text = str_replace ( "[/u]", '</u>', $text );
	// [i] and [/i] for italicizing text.
	$text = str_replace ( "[i]", '<i>', $text );
	$text = str_replace ( "[/i]", '</i>', $text );
	if (! count ( $bbcode_tpl )) {
		// We do URLs in several different ways..
		$bbcode_tpl ['url'] = '<span class="bblink"><a href="{URL}" target="_blank">{DESCRIPTION}</a></span>';
		$bbcode_tpl ['email'] = '<span class="bblink"><a href="mailto:{EMAIL}">{EMAIL}</a></span>';
		$bbcode_tpl ['url1'] = str_replace ( '{URL}', '\\1\\2', $bbcode_tpl ['url'] );
		$bbcode_tpl ['url1'] = str_replace ( '{DESCRIPTION}', '\\1\\2', $bbcode_tpl ['url1'] );
		$bbcode_tpl ['url2'] = str_replace ( '{URL}', 'http://\\1', $bbcode_tpl ['url'] );
		$bbcode_tpl ['url2'] = str_replace ( '{DESCRIPTION}', '\\1', $bbcode_tpl ['url2'] );
		$bbcode_tpl ['url3'] = str_replace ( '{URL}', '\\1\\2', $bbcode_tpl ['url'] );
		$bbcode_tpl ['url3'] = str_replace ( '{DESCRIPTION}', '\\3', $bbcode_tpl ['url3'] );
		$bbcode_tpl ['url4'] = str_replace ( '{URL}', 'http://\\1', $bbcode_tpl ['url'] );
		$bbcode_tpl ['url4'] = str_replace ( '{DESCRIPTION}', '\\2', $bbcode_tpl ['url4'] );
		$bbcode_tpl ['email'] = str_replace ( '{EMAIL}', '\\1', $bbcode_tpl ['email'] );
		// [url]xxxx://www.phpbb.com[/url] code..
		$patterns [1] = "#\[url\]([a-z]+?://){1}([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\[/url\]#si";
		$replacements [1] = $bbcode_tpl ['url1'];
		// [url]www.phpbb.com[/url] code.. (no xxxx:// prefix).
		$patterns [2] = "#\[url\]([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\[/url\]#si";
		$replacements [2] = $bbcode_tpl ['url2'];
		// [url=xxxx://www.phpbb.com]phpBB[/url] code..
		$patterns [3] = "#\[url=([a-z]+?://){1}([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\](.*?)\[/url\]#si";
		$replacements [3] = $bbcode_tpl ['url3'];
		// [url=www.phpbb.com]phpBB[/url] code.. (no xxxx:// prefix).
		$patterns [4] = "#\[url=([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\](.*?)\[/url\]#si";
		$replacements [4] = $bbcode_tpl ['url4'];
		// [email]user@domain.tld[/email] code..
		$patterns [5] = "#\[email\]([a-z0-9\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si";
		$replacements [5] = $bbcode_tpl ['email'];
	}
	$text = preg_replace ( $patterns, $replacements, $text );
	return $text;
}

/**
 * Mailfunktionen
 * Shows the email form for a given content item.
 */
function emailContentForm($uid) {
	global $database, $mainframe, $my;
	// Database Query
	$imgtitle = '';
	$database->setQuery ( "SELECT imgtitle FROM #__garyscookbook WHERE id = '" . $uid . "'" );
	$imgtitle = $database->loadResult ();
	if (id === null) {
		mosNotAuth ();
		return;
	} else {
		$template = '';
		$database->setQuery ( "SELECT template FROM #__templates_menu WHERE client_id = '0' AND menuid = '0'" );
		$template = $database->loadResult ();
		emailForm ( $uid, $imgtitle, $template );
	}
}

/**
 * Writes Email form for filling in the send destination
 */
function emailForm($uid, $title, $template = '') {
	global $mosConfig_sitename;
	
	?>
<script language="javascript" type="text/javascript">
	function submitbutton() {
		var form = document.frontendForm;
		// do field validation
		if (form.email.value == "" || form.youremail.value == "") {
			alert( '<?php
	echo addslashes ( _garyscookbook_EMAIL_ERR_NOINFO );
	?>' );
			return false;
		}
		return true;
	}
	</script>

<title><?php
	echo $title;
	?></title>
<link rel="stylesheet"
	href="templates/<?php
	echo $template;
	?>/css/template_css.css"
	type="text/css" />
<form
	action="index2.php?option=com_garyscookbook&Itemid=$Itemid&func=emailsend&id=$id;"
	name="frontendForm" method="post" onSubmit="return submitbutton();">
<table cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td colspan="4">
		<?php
	echo _garyscookbook_EMAIL_FRIEND;
	?>
		</td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td width="130">
		<?php
	echo _garyscookbook_EMAIL_FRIEND_ADDR;
	?>
		</td>
		<td><input type="text" name="email" class="inputbox" size="25"></td>
	</tr>
	<tr>
		<td height="27">
		<?php
	echo _garyscookbook_EMAIL_YOUR_NAME;
	?>
		</td>
		<td><input type="text" name="yourname" class="inputbox" size="25"></td>
	</tr>
	<tr>
		<td>
		<?php
	echo _garyscookbook_EMAIL_YOUR_MAIL;
	?>
		</td>
		<td><input type="text" name="youremail" class="inputbox" size="25"></td>
	</tr>
	<tr>
		<td>
		<?php
	echo _garyscookbook_SUBJECT_PROMPT;
	?>
		</td>
		<td><input type="text" name="subject" class="inputbox" maxlength="100"
			size="40"></td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td colspan="2"><input type="submit" name="submit" class="button"
			value="<?php
	echo _garyscookbook_BUTTON_SUBMIT_MAIL;
	?>"> &nbsp;&nbsp; <input type="button" name="cancel"
			value="<?php
	echo _garyscookbook_BUTTON_CANCEL;
	?>"
			class="button" onclick="window.close();"></td>
	</tr>
</table>

<input type="hidden" name="id" value="<?php
	echo $uid;
	?>"></form>
<?php
}

/**
 * Creates Email and send a Link
 */
function emailContentSend($uid) {
	global $database, $mainframe;
	global $mosConfig_live_site, $mosConfig_sitename;
	global $mosConfig_mailfrom, $mosConfig_fromname;
	
	$_Itemid = $mainframe->getItemid ( $uid, 0, 0 );
	
	$email = trim ( mosGetParam ( $_POST, 'email', '' ) );
	$yourname = trim ( mosGetParam ( $_POST, 'yourname', '' ) );
	$youremail = trim ( mosGetParam ( $_POST, 'youremail', '' ) );
	$subject_default = _EMAIL_INFO . " $yourname";
	$subject = trim ( mosGetParam ( $_POST, 'subject', $subject_default ) );
	if (! $email || ! $youremail || (is_email ( $email ) == false) || (is_email ( $youremail ) == false)) {
		echo "<script>alert (\"" . _garyscookbook_EMAIL_ERR_NOINFO . "\"); window.history.go(-1);</script>";
		exit ( 0 );
	}
	
	$template = '';
	$database->setQuery ( "SELECT template FROM #__templates_menu WHERE client_id='0' AND menuid='0'" );
	$template = $database->loadResult ();
	// link sent in email
	$link = sefRelToAbs ( $mosConfig_live_site . '/index.php?option=com_garyscookbook&Itemid=' . $_Itemid . '&func=detail&id=' . $uid );
	// message text
	$msg = sprintf ( _garyscookbook_EMAIL_MSG, $mosConfig_sitename, $yourname, $youremail, $link );
	// mail function
	mosMail ( $mosConfig_mailfrom, $mosConfig_fromname, $email, $subject, $msg );
	
	emailSent ( $email, $template );
}

/**
 * is_email()
 *
 * @param mixed $email
 * @return
 */
function is_email($email) {
	$rBool = false;
	if (preg_match ( "/[\w\.\-]+@\w+[\w\.\-]*?\.\w{1,4}/", $email )) {
		$rBool = true;
	}
	return $rBool;
}

/**
 * emailSent()
 *
 * @param mixed $to
 * @param string $template
 * @return
 */
function emailSent($to, $template = '') {
	global $mosConfig_sitename;
	
	?>
<title><?php
	echo $mosConfig_sitename;
	?></title>
<link rel="stylesheet"
	href="templates/<?php
	echo $template;
	?>/css/template_css.css"
	type="text/css" />
<span class="contentheading"><?php
	echo _garyscookbook_EMAIL_SENT . " $to";
	?></span>
<br />
<br />
<br />
<a href='javascript:window.close();'> <span class="small"><?php
	echo _garyscookbook_PROMPT_CLOSE;
	?></span> </a>
<?php
}

/**
 * fs_import_filename()
 *
 * @param mixed $filename
 * @param integer $for_exec
 * @return
 */
function fs_import_filename($filename, $for_exec = 1) {
	// Change / and : to \ and ;
	

	$filename = str_replace ( "/", "\\", $filename );
	$filename = str_replace ( ":", ";", $filename );
	// Change D;\apps to D:\apps (the : got mangled by the above
	// transform).
	

	if ($filename {1} == ';') {
		$filename {1} = ':';
	}
	// Convert "D\whoami" to "D:\whoami"
	

	$filename = ereg_replace ( "^([A-Z])\\\\(.*)", "\\1:\\\\2", $filename );
	// Convert "\Perl\bin\;D/whoami" to "D:\Perl\bin\whoami"
	

	$filename = ereg_replace ( "(.*);([A-Z])\\\\(.*)", "\\2:\\1\\3", $filename );
	
	if ($for_exec) {
		if (strstr ( $filename, " " )) {
			$filename = "\"$filename\"";
		}
	}
	return $filename;
}

/**
 * GetNumberOfLinks()
 *
 * @param mixed $cat
 * @return
 */
function GetNumberOfLinks($cat) {
	global $database, $gid;
	$queue [] = intval ( $cat );
	
	while ( list ( $key, $cat ) = each ( $queue ) ) {
		// get children
		$query = "SELECT id FROM #__categories WHERE parent_id=$cat AND published=1";
		
		$database->setQuery ( $query );
		$result = $database->query ();
		$total = mysql_num_rows ( $result );
		// put them in queue
		$j = 0;
		
		while ( $j < $total ) {
			$val = mysql_fetch_row ( $result );
			$queue [] = $val [0];
			$j ++;
		}
	}
	
	reset ( $queue );
	$query = "SELECT count(id) as count FROM #__garyscookbook WHERE (0 != 0";
	while ( list ( $key, $cat ) = each ( $queue ) ) {
		$query .= " OR catid = $cat";
	}
	$query .= ") AND published=1";
	$database->setQuery ( $query );
	$result = $database->query ();
	$val = mysql_fetch_row ( $result );
	return $val [0];
}

/**
 * ShowCategoryPathLink()
 *
 * @param mixed $cat
 * @return
 */
function ShowCategoryPathLink($cat) {
	global $database, $mosConfig_lang, $gid, $Itemid;
	
	$cat = intval ( $cat );
	$par_id = 1000;
	while ( $par_id ) {
		$query = "SELECT * FROM #__categories
							WHERE id=$cat AND published = 1
							AND access <= '$gid'";
		
		$database->setQuery ( $query );
		$result = $database->query ();
		
		$par_id = @mysql_result ( $result, 0, 'parent_id' );
		$cid = @mysql_result ( $result, 0, 'id' );
		$name = "<a href='" . sefRelToAbs ( "index.php?option=com_garyscookbook&Itemid=$Itemid&func=viewcategory&id=$cat" ) . "'>" . @mysql_result ( $result, 0, 'name' ) . "</a>";
		// write path
		if (empty ( $path )) {
			$path = $name;
		} else {
			$path = $name . '<img src="images/M_images/arrow.png" />' . $path;
		}
		// next looping
		$cat = $par_id;
	}
	$home = "<a href='" . sefRelToAbs ( "index.php?option=com_garyscookbook&Itemid=$Itemid" ) . "'>" . _garyscookbook_CATEGORIES . "</a>";
	$pathName = $home . ' <img src="images/M_images/arrow.png" /> ' . $path . " ";
	return $pathName;
}

/**
 * ShowCategoryPath()
 *
 * @param mixed $cat
 * @return
 */
function ShowCategoryPath($cat) {
	global $database, $mosConfig_lang, $gid;
	
	$cat = intval ( $cat );
	$parent_id = 1000;
	while ( $parent_id ) {
		// read name and parent_id
		$query = "SELECT * FROM #__categories WHERE id=$cat AND access <= '$gid'";
		$database->setQuery ( $query );
		$result = $database->query ();
		// $parent_id = @mysql _result($result, 0, 'parent');
		// $name = @mysql _result($result, 0, 'name');
		$parent_id = $Result [0]->parent;
		$name = $Result [0]->name;
		// write path
		if (empty ( $path )) {
			$path = $name;
		} else {
			$path = $name . ' � ' . $path;
		}
		// next looping
		$cat = $parent_id;
	}
	return $path . ' ';
}

/**
 * parentcat()
 *
 * @param mixed $id
 * @param mixed $Itemid
 * @return
 */
function parentcat($id, $Itemid) {
	global $database, $func, $gid, $ag_rmsm, $ag_collist, $output, $ag_subcatleft;
	if ($ag_subcatleft) {
		$Spalten = 1;
	} else {
		$Spalten = $ag_collist;
	}
	$database->setQuery ( "SELECT d.*
							FROM #__categories AS d
							WHERE d.parent_id=$id and d.published=1
							ORDER BY d.ordering" );
	$rows = $database->loadObjectList ();
	$num_rows = ceil ( count ( $rows ) / $Spalten );
	$index = 0;
	// Subcategories are only shows if exists
	if ($num_rows > 0) {
		$output .= '<table cellspacing="0" cellpadding="4" border="0" width="100%" >';
		$output .= '<tr>';
		$output .= '<th colspan="4" class="sectiontableheader" align="left">';
		$output .= "<img src='components/com_garyscookbook/images/cookbook.gif' hspace='6' border='0' align='absmiddle'>" . _gkb_Down_Cat;
		$output .= '</th></tr>';
		
		for($row_count = 0; $row_count < $num_rows; $row_count ++) {
			$output .= '<tr class="sectiontableentry">';
			for($col_count = 0; $col_count < $Spalten; $col_count ++) {
				$output .= '<td width="' . floor ( 100 / $Spalten ) . '%" valign="top">';
				$cur_name = $rows [$index];
				
				if ($cur_name == '') {
					$output .= '&nbsp';
				} else {
					if (GetNumberOfLinks ( $rows->id ) == 1) {
						$insertbez = _garyscookbook_ADMIN_PICTURE;
					} else {
						$insertbez = _gkb_Cat_Recipes;
					}
					$output .= '<img src="images/M_images/arrow.png"><a href="' . sefRelToAbs ( "index.php?option=com_garyscookbook&Itemid=$Itemid&func=viewcategory&id=$cur_name->id" ) . '">' . $cur_name->name . ' (' . GetNumberOfLinks ( $cur_name->id ) . " " . $insertbez . ')</a>';
					$output .= substr ( $cur_name->description, 0, $ag_catlength );
					if ($ag_rmsm > 0) {
						if ($cur_name->access > 1) {
							$output .= ' <font class="smallgm">[SM]</font>';
						} else if ($cur_name->access > 0) {
							$output .= ' <font class="smallgsm">[RM]</font>';
						}
					}
				}
				$index ++;
				$output .= '<br />';
			}
			$output .= '</td></tr>';
		}
		$output .= '</table>';
		return $output;
	}
}

/**
 * showOfflineMsg()
 *
 * @return
 */
function showOfflineMsg() {
	global $ag_offlinemsg;
	echo "<TABLE WIDTH='98%' CELLPADDING='3' CELLSPACING='4' BORDER='0' ALIGN='center' class='newspane'>";
	echo "<tr><td CLASS='componentheading'>" . _garyscookbook_TITLE . "</td></tr>";
	echo "<tr><td>";
	echo "<table width='100%' border='0' cellspacing='1' cellpadding='4'>";
	echo "<td><div align='center'><a href='http://www.vb-dozent.net' target='_new'><img src='administrator/components/com_garyscookbook/images/logo.png'></a></div></td>";
	echo "<br />";
	echo "<tr><td class='sectiontableheader2' colspan='1'>&nbsp</td></tr>";
	echo "<tr><td class='sectiontableheader' colspan='1'><h2>" . $ag_offlinemsg . "</h2></td></tr>";
	echo "</table>";
}

/**
 * showNoAccess()
 *
 * @return
 */
function showNoAccess() {
	echo "<TABLE WIDTH='98%' CELLPADDING='3' CELLSPACING='4' BORDER='0' ALIGN='center' class='newspane'>";
	echo "<tr><td CLASS='componentheading'>" . _garyscookbook_TITLE . "</td></tr>";
	echo "<tr><td>";
	echo "<table width='100%' border='0' cellspacing='1' cellpadding='4'>";
	echo "<td><div align='center'><a href='http://www.vb-dozent.net' target='_new'><img src='administrator/components/com_garyscookbook/images/logo.png'></a></div></td>";
	echo "<br />";
	echo "<tr><td class='sectiontableheader2' colspan='1'>&nbsp</td></tr>";
	echo "<tr><td class='sectiontableheader' colspan='1'><h3>" . _garyscookbook_UNAUTHORIZIED . "</h3></td></tr>";
	echo "<tr><td class='sectiontableheader2' colspan='1'>" . _garyscookbook_UNAUTHORIZIED2 . "</td></tr>";
	echo "</table>";
}

/**
 * resize_image()
 *
 * @param mixed $src_file
 * @param mixed $dest_file
 * @param mixed $new_size
 * @param mixed $method
 * @param mixed $dest_qual
 * @return
 */
function resize_image($src_file, $dest_file, $new_size, $method, $dest_qual) {
	$imagetype = array (1 => 'GIF', 2 => 'JPG', 3 => 'PNG', 4 => 'SWF', 5 => 'PSD', 6 => 'BMP', 7 => 'TIFF', 8 => 'TIFF', 9 => 'JPC', 10 => 'JP2', 11 => 'JPX', 12 => 'JB2', 13 => 'SWC', 14 => 'IFF' );
	$imginfo = getimagesize ( $src_file );
	// echo "<script> alert('$src_file');</script>\n";
	if ($imginfo == null) {
		// falsche Datei l�schen
		unlink ( $src_file );
		echo "<script> alert('" . _garyscookbook_PICINCORRECT . "'); window.history.go(-1); </script>\n";
		die ( "ERROR: Source file not found or no Picture!" );
	}
	$imginfo [2] = $imagetype [$imginfo [2]];
	// GD can only handle JPG & PNG images
	if ($imginfo [2] != 'JPG' && $imginfo [2] != 'PNG' && $imginfo [2] != 'GIF' && ($method == 'gd1' || $method == 'gd2'))
		die ( "ERROR: GD can only handle JPG and PNG files!" );
		// height/width
	$srcWidth = $imginfo [0];
	$srcHeight = $imginfo [1];
	
	echo "Creating thumbnail from $imginfo[2], $imginfo[0] x $imginfo[1]...<br>";
	
	$ratio = max ( $srcWidth, $srcHeight ) / $new_size;
	$ratio = max ( $ratio, 1.0 );
	$destWidth = ( int ) ($srcWidth / $ratio);
	$destHeight = ( int ) ($srcHeight / $ratio);
	// Method for thumbnails creation
	switch ( $method) {
		case "gd1" :
			if (! function_exists ( 'imagecreatefromjpeg' )) {
				die ( 'GD image library not installed!' );
			}
			if ($imginfo [2] == 'JPG')
				$src_img = imagecreatefromjpeg ( $src_file ); else if ($imginfo [2] == 'PNG')
				$src_img = imagecreatefrompng ( $src_file ); else
				$src_img = imagecreatefromgif ( $src_file );
			if (! $src_img) {
				$ERROR = $lang_errors ['invalid_image'];
				return false;
			}
			$dst_img = imagecreate ( $destWidth, $destHeight );
			imagecopyresized ( $dst_img, $src_img, 0, 0, 0, 0, $destWidth, ( int ) $destHeight, $srcWidth, $srcHeight );
			imagejpeg ( $dst_img, $dest_file, $dest_qual );
			imagedestroy ( $src_img );
			imagedestroy ( $dst_img );
		break;
		
		case "gd2" :
			if (! function_exists ( 'imagecreatefromjpeg' )) {
				die ( 'GD image library not installed!' );
			}
			if (! function_exists ( 'imagecreatetruecolor' )) {
				die ( 'GD2 image library does not support truecolor thumbnailing!' );
			}
			if ($imginfo [2] == 'JPG') {
				$src_img = imagecreatefromjpeg ( $src_file );
			} else if ($imginfo [2] == 'PNG') {
				$src_img = imagecreatefrompng ( $src_file );
			} else {
				$src_img = imagecreatefromgif ( $src_file );
			}
			if (! $src_img) {
				$ERROR = $lang_errors ['invalid_image'];
				return false;
			}
			$dst_img = imagecreatetruecolor ( $destWidth, $destHeight );
			imagecopyresampled ( $dst_img, $src_img, 0, 0, 0, 0, $destWidth, ( int ) $destHeight, $srcWidth, $srcHeight );
			imagejpeg ( $dst_img, $dest_file, $dest_qual );
			imagedestroy ( $src_img );
			imagedestroy ( $dst_img );
		break;
	}
	// Set mode of uploaded picture
	chmod ( $dest_file, octdec ( '755' ) );
	// We check that the image is valid
	$imginfo = getimagesize ( $dest_file );
	if ($imginfo == null) {
		return false;
	} else {
		return true;
	}
}

/**
 * exportRecipe()
 *
 * @param mixed $uid
 * @return
 */
function exportRecipe($uid) {
	global $database;
	global $mosConfig_db, $mosConfig_sitename, $version, $option, $task, $mosConfig_dbprefix, $id, $thumbnailpath, $picturepath, $temppath, $mosConfig_absolute_path, $ag_pathimages, $ag_makeMM_pic;
	$query1 = "SELECT id, catid, imgtitle, imgauthor, imgtext, imgdate, imgcounter, imgvotes, imgvotesum, published, imgfilename, imgthumbname, doc, price, country, portion, aging, years, grapes, properties, notes FROM " . $mosConfig_dbprefix . "garyscookbook  WHERE id = '$uid'";
	$result1 = mysql_query ( $query1 );
	list ( $id, $catid, $imgtitle, $imgauthor, $imgtext, $imgdate, $imgcounter, $imgvotes, $imgvotesum, $published, $imgfilename, $imgthumbname, $doc, $price, $country, $portion, $aging, $years, $grapes, $properties, $notes ) = mysql_fetch_row ( $result1 );
	// feststellen welcher Browser verwendet wird
	if (ereg ( 'Opera(/| )([0-9].[0-9]{1,2})', $UserAgent )) {
		$UserBrowser = "Opera";
	} elseif (ereg ( 'MSIE ([0-9].[0-9]{1,2})', $UserAgent )) {
		$UserBrowser = "IE";
	} else {
		$UserBrowser = '';
	}
	$filename = ereg_replace ( "[[:punct:]]", "", $imgtitle );
	$filename = strtolower ( $filename );
	$filename .= "_" . date ( "jmYHis" ) . ".gkb";
	$filename = str_replace ( " ", "_", $filename );
	$filename = str_replace ( "�", "ae", $filename );
	$filename = str_replace ( "�", "oe", $filename );
	$filename = str_replace ( "�", "ue", $filename );
	$filename = str_replace ( "�", "ss", $filename );
	$filename = ereg_replace ( '[^A-Za-z0-9.]', '-', $filename );
	$mime_type = 'application/x-zip';
	
	/* Store the "Create Tables" SQL in variable $CreateTable[$tblval] */
	// $tblval = $mosConfig_dbprefix;
	$tblval = "#__garyscookbook";
	$database->setQuery ( "SHOW CREATE table $tblval" );
	$database->query ();
	$CreateTable [$tblval] = $database->loadResultArray ( 1 );
	$opFile = $mosConfig_absolute_path . $ag_pathimages . "/" . $imgfilename;
	if ($ag_makeMM_pic) {
		// 'Hier mu� noch das Bild eingef�gt werden wenn vorhanden'
		if (file_exists ( $opFile ) && $imgfilename > "") {
			$fp = fopen ( $opFile, "r" );
			$bindata = fread ( $fp, filesize ( $opFile ) );
			$PictureImportname = "GKB_" . date ( "jmYHis" ) . $imgfilename;
			fclose ( $fp );
			$picexists = True;
		} else {
			$picexists = False;
		}
	}
	// Kopf erzeugen
	$OutBuffer = "";
	$OutBuffer .= "#\n";
	$OutBuffer .= "# Garyscookbook Recipe Export\n";
	$OutBuffer .= "# http://www.vb-dozent.net\n";
	$OutBuffer .= "#\n";
	$OutBuffer .= "# Host: $mosConfig_sitename\n";
	$OutBuffer .= "# Generation Time: " . date ( "M j, Y \a\\t H:i" ) . "\n";
	$OutBuffer .= "# Server version: " . $database->getVersion () . "\n";
	$OutBuffer .= "# PHP Version: " . phpversion () . "\n";
	$OutBuffer .= "# Included Files: " . $PictureImportname . "\n";
	$OutBuffer .= "# Database : `" . $mosConfig_db . "`\n# --------------------------------------------------------\n";
	$pictime = mktime ();
	if ($ag_makeMM_pic && $picexists) {
		// Ben�tigte Felder festlegen
		$myfields = "`catid`, `imgdate`, `imgfilename`, `imgthumbname`, `imgtitle`, `imgauthor`, `imgtext`,  `doc`, `price`, `country`,`portion`,`aging`,`years`,`grapes`,`properties`,`notes`";
		$database->setQuery ( "SELECT  `imgtitle`, `imgauthor`, `imgtext`,  `doc`, `price`, `country`,`portion`,`aging`,`years`,`grapes`,`properties`,`notes` FROM " . $mosConfig_dbprefix . "garyscookbook WHERE id='$uid'" );
	} else {
		// Ben�tigte Felder festlegen
		$myfields = "`catid`, `imgdate`, `imgtitle`, `imgauthor`, `imgtext`, `doc`, `price`, `country`,`portion`,`aging`,`years`,`grapes`,`properties`,`notes`";
		$database->setQuery ( "SELECT `imgtitle`, `imgauthor`, `imgtext`, `doc`, `price`, `country`,`portion`,`aging`,`years`,`grapes`,`properties`,`notes` FROM " . $mosConfig_dbprefix . "garyscookbook WHERE id='$uid'" );
	}
	
	$rows = $database->loadObjectList ();
	if ($ag_makeMM_pic && $picexists) {
		$InsertDump = "INSERT INTO $tblval ( $myfields ) VALUES ( '****' , '" . $pictime . "'," . "'" . $PictureImportname . "', 'tn_" . $PictureImportname . "',";
	} else {
		$InsertDump = "INSERT INTO $tblval ( $myfields ) VALUES ( '****' , '" . $pictime . "',";
	}
	foreach ( $rows as $row ) {
		$arr = mosObjectToArray ( $row );
		foreach ( $arr as $key => $value ) {
			$value = addslashes ( $value );
			$value = str_replace ( "\n", '\r\n', $value );
			$value = str_replace ( "\r", '', $value );
			if (preg_match ( "/\b" . $FieldType [$tblval] [$key] . "\b/i", "DATE TIME DATETIME CHAR VARCHAR TEXT TINYTEXT MEDIUMTEXT LONGTEXT BLOB TINYBLOB MEDIUMBLOB LONGBLOB ENUM SET" )) {
				$InsertDump .= "'$value',";
			} else {
				$InsertDump .= "$value,";
			}
		}
	}
	$OutBuffer .= rtrim ( $InsertDump, ',' ) . ");\n";
	// dump anything in the buffer
	@ob_end_clean ();
	ob_start ();
	header ( 'Content-Type: ' . $mime_type );
	header ( 'Expires: ' . gmdate ( 'D, d M Y H:i:s' ) . ' GMT' );
	
	if ($UserBrowser == 'IE') {
		header ( 'Content-Disposition: inline; filename="' . $filename . '"' );
		header ( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
		header ( 'Pragma: public' );
	} else {
		header ( 'Content-Disposition: attachment; filename="' . $filename . '"' );
		header ( 'Pragma: no-cache' );
	}
	
	if (function_exists ( 'gzcompress' )) {
		include "administrator/includes/pcl/zip.lib.php";
		$zipfile = new zipfile ( );
		$zipfile->addFile ( $OutBuffer, $filename . ".sql" );
		if ($ag_makeMM_pic && $picexists) {
			// 'Hier mu� noch das Bild eingef�gt werden wenn vorhanden'
			$zipfile->addFile ( $bindata, $PictureImportname );
		}
		echo $zipfile->file ();
		ob_end_flush ();
		ob_start ();
	}
	// do no more
	exit ();
	break;
}

/**
 * showGKBAdminMessage()
 *
 * @param mixed $message
 * @param mixed $title
 * @param mixed $option
 * @param mixed $task
 * @return
 */
function showGKBAdminMessage($message, $title, $option, $task) {
	global $PHP_SELF;
	
	?>
<table border="0" cellpadding="4" cellspacing="0" width="100%"
	class="adminlist">
	<tr>
		<th width="55%" class="title"><?php
	echo $title;
	?></th>
	</tr>
	<tr>
		<td align="left"><b><?php
	echo $message;
	?></td>
	</tr>
</table>
<?php
}

$func = strval ( mosGetParam ( $_REQUEST, 'func', '' ) );
$Itemid = intval ( mosGetParam ( $_REQUEST, 'Itemid', '' ) );
$id = intval ( mosGetParam ( $_REQUEST, 'id', '' ) );
$startpage = intval ( mosGetParam ( $_REQUEST, 'startpage', '' ) );

switch ( $func) {
	case 'special' :
		include ('components/com_garyscookbook/sub_viewspecial.php');
	break;
	case 'detail' :
		if ($ag_regonly && ! $my->id) {
			showNoAccess ();
			break;
		} else if ($ag_offlinecookbook && ! $is_admin) {
			showOfflineMsg ();
			break;
		}
		include ('components/com_garyscookbook/sub_viewdetails.php');
		$showedit = true;
	break;
	case 'print' :
		include ('components/com_garyscookbook/sub_printdetails.php');
	break;
	case 'mail' :
		emailContentForm ( $id );
	break;
	case 'emailsend' :
		emailContentSend ( $id );
	break;
	case 'rpdf' :
		include $mosConfig_absolute_path . '/components/com_garyscookbook/sub_pdfdetails.php';
		die ();
	case 'rmm' :
		functionheader ();
		exportRecipe ( $id );
	break;
	case 'vote' :
		include ('components/com_garyscookbook/sub_vote.php');
	break;
	case 'editpic' :
		cookbookHeader ( 0 );
		include ('components/com_garyscookbook/sub_editdetails.php');
		$showedit = false;
	break;
	case 'comment' :
		include ('components/com_garyscookbook/sub_comment.php');
	break;
	case 'deletecomment' :
		// functionheader();
		include ('components/com_garyscookbook/sub_deletecomment.php');
	break;
	case 'newItem' :
		cookbookHeader ( 0 );
		$showedit = false;
		if ($ag_postnewcookbook or $ag_editorpostnewcookbook) {
			// Get the list of categories
			$categories [] = mosHTML::makeOption ( '0', 'Select Category' );
			$database->setQuery ( "SELECT id AS value, title AS text FROM #__categories" . "\nWHERE section='com_garyscookbook' ORDER BY ordering" );
			$categories = array_merge ( $categories, $database->loadObjectList () );
			$clist = mosHTML::selectList ( $categories, 'catid', 'class="inputbox" size="1"', 'value', 'text', $id );
			editcookbook ( $option, $row, $clist, $imagelist, $thumblist, $ag_pathimages, $ag_paththumbs, $ag_upload );
		} else {
			echo "<table  class='sectiontableentry2' width='100%' border='0' cellspacing='1' cellpadding='4'>";
			echo "<tr><td colspan='3' class='sectiontableheader' width='100%'><div align='center'>" . _garyscookbook_CANNOT_ADD . "</div></td></tr>";
			echo "</table>";
		}
	break;
	
	case 'save' :
		$screenshot = (isset ( $_FILES ['screenshot'] ['tmp_name'] ) ? $_FILES ['screenshot'] ['tmp_name'] : "");
		$screenshot_name = (isset ( $_FILES ['screenshot'] ['name'] ) ? $_FILES ['screenshot'] ['name'] : "");
		$pic1 = (isset ( $_FILES ['pic1'] ['tmp_name'] ) ? $_FILES ['pic1'] ['tmp_name'] : "");
		$pic1_name = (isset ( $_FILES ['pic1'] ['name'] ) ? $_FILES ['pic1'] ['name'] : "");
		$pic2 = (isset ( $_FILES ['pic2'] ['tmp_name'] ) ? $_FILES ['pic2'] ['tmp_name'] : "");
		$pic2_name = (isset ( $_FILES ['pic2'] ['name'] ) ? $_FILES ['pic2'] ['name'] : "");
		$pic3 = (isset ( $_FILES ['pic3'] ['tmp_name'] ) ? $_FILES ['pic3'] ['tmp_name'] : "");
		$pic3_name = (isset ( $_FILES ['pic3'] ['name'] ) ? $_FILES ['pic3'] ['name'] : "");
		$pic4 = (isset ( $_FILES ['pic4'] ['tmp_name'] ) ? $_FILES ['pic4'] ['tmp_name'] : "");
		$pic4_name = (isset ( $_FILES ['pic4'] ['name'] ) ? $_FILES ['pic4'] ['name'] : "");
		
		cookbookHeader ( 0 );
		
		if (strlen ( $screenshot ) > 0 and $screenshot != "none") {
			if (move_uploaded_file ( $screenshot, $mosConfig_absolute_path . $ag_pathimages . "/$screenshot_name" )) {
				resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$screenshot_name", $mosConfig_absolute_path . $ag_pathimages . "/$screenshot_name", "$ag_picturewidth", "$ag_thumbcreation", "$ag_picturequality" );
				resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$screenshot_name", $mosConfig_absolute_path . $ag_paththumbs . "/tn_$screenshot_name", "$ag_thumbwidth", "$ag_thumbcreation", "$ag_thumbquality" );
			}
		}
		if ($ag_zpics == "1") {
			if (strlen ( $pic1 ) > 0 and $pic1 != "none") {
				if (move_uploaded_file ( $pic1, $mosConfig_absolute_path . $ag_pathimages . "/$pic1_name" )) {
					resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$pic1_name", $mosConfig_absolute_path . $ag_pathimages . "/$pic1_name", "$ag_picturewidth", "$ag_thumbcreation", "$ag_picturequality" );
					resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$pic1_name", $mosConfig_absolute_path . $ag_paththumbs . "/tn_$pic1_name", "$ag_thumbwidth", "$ag_thumbcreation", "$ag_thumbquality" );
				}
			}
			if (strlen ( $pic2 ) > 0 and $pic2 != "none") {
				if (move_uploaded_file ( $pic2, $mosConfig_absolute_path . $ag_pathimages . "/$$pic2_name" )) {
					resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$pic2_name", $mosConfig_absolute_path . $ag_pathimages . "/$$pic2_name", "$ag_picturewidth", "$ag_thumbcreation", "$ag_picturequality" );
					resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$pic2_name", $mosConfig_absolute_path . $ag_paththumbs . "/tn_$$pic2_name", "$ag_thumbwidth", "$ag_thumbcreation", "$ag_thumbquality" );
				}
			}
			if (strlen ( $pic3 ) > 0 and $pic3 != "none") {
				if (move_uploaded_file ( $pic3, $mosConfig_absolute_path . $ag_pathimages . "/$$pic3_name" )) {
					resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$pic3_name", $mosConfig_absolute_path . $ag_pathimages . "/$$pic3_name", "$ag_picturewidth", "$ag_thumbcreation", "$ag_picturequality" );
					resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$pic3_name", $mosConfig_absolute_path . $ag_paththumbs . "/tn_$$pic3_name", "$ag_thumbwidth", "$ag_thumbcreation", "$ag_thumbquality" );
				}
			}
			if (strlen ( $pic4 ) > 0 and $pic4 != "none") {
				if (move_uploaded_file ( $pic4, $mosConfig_absolute_path . $ag_pathimages . "/$$pic4_name" )) {
					resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$pic4_name", $mosConfig_absolute_path . $ag_pathimages . "/$$pic4_name", "$ag_picturewidth", "$ag_thumbcreation", "$ag_picturequality" );
					resize_image ( $mosConfig_absolute_path . $ag_pathimages . "/$pic4_name", $mosConfig_absolute_path . $ag_paththumbs . "/tn_$$pic4_name", "$ag_thumbwidth", "$ag_thumbcreation", "$ag_thumbquality" );
				}
			}
		}
		savePost ();
	break;
	case 'viewcategory' :
		if ($ag_regonly && ! $my->id) {
			showNoAccess ();
			break;
		} else if ($ag_offlinecookbook && ! $is_admin) {
			showOfflineMsg ();
			break;
		}
		cookbookHeader ( 0 );
		if ($ag_subcatleft) {
			$database->setQuery ( "SELECT d.* FROM #__categories AS d WHERE d.parent_id=$id and d.published=1 ORDER BY d.ordering" );
			$rows = $database->loadObjectList ();
			$num_rows = ceil ( count ( $rows ) / $ag_collist );
			echo "<table width='100%' cellspacing='6'>";
			echo "<tr><td valign='top'>";
			echo catdescription ( $id );
			echo "</td>";
			if ($num_rows > 0) {
				echo "<td width='30%' valign='top' >";
				echo parentcat ( $id, $Itemid );
				echo "</td>";
			}
			echo "</tr></table>";
		} else {
			echo parentcat ( $id, $Itemid );
		}
		$database->setQuery ( "SELECT count(id) FROM #__categories WHERE id = '$id' AND access <= '$gid'" );
		$is_allowed = $database->loadResult ();
		// Feststellen der Anzahl der verf�gbaren Datens�tze
		$database->setQuery ( "SELECT count(id) FROM #__garyscookbook WHERE published = '1' AND catid = '" . $id . "'" );
		$count = $database->loadResult ();
		// Berechnen der Gesamtseiten
		$gesamtseiten = floor ( $count / $ag_perpage );
		$seitenrest = $count % $ag_perpage;
		if ($seitenrest > 0) {
			$gesamtseiten ++;
		}
		// Feststellen der aktuellen Seite
		if (isset ( $startpage )) {
			if ($startpage > $gesamtseiten) {
				$startpage = $gesamtseiten;
			} else if ($startpage < 1) {
				$startpage = 1;
			}
		} else {
			$startpage = 1;
		}
		if ($count == "") {
			$count = 0;
		}
		$text = str_replace ( "#count", $count, _garyscookbook_NUMBER_garyscookbook );
		echo "<p>" . $text . "<br /><b>";
		echo _garyscookbook_PAGES . ": </b>";
		// Ausgeben der Seite zurueck Funktion
		$seiterueck = $startpage - 1;
		if ($seiterueck > 0) {
			echo '<a href="' .sefRelToAbs("index.php?option=com_garyscookbook&Itemid=$Itemid&func=viewcategory&id=$id&startpage=$seiterueck") .'"><b>�</b></a> ';
		}
		// Ausgeben der einzelnen Seiten
		for($i = 1; $i <= $gesamtseiten; $i ++) {
			if ($i == $startpage) {
				echo "$i ";
			} else {
				echo '<a href="' .sefRelToAbs("index.php?option=com_garyscookbook&Itemid=$Itemid&func=viewcategory&id=$id&startpage=$i").'">$i</a> ';
			}
		}
		// Ausgeben der Seite vorw�rts Funktion
		$seitevor = $startpage + 1;
		if ($seitevor <= $gesamtseiten) {
			echo '<a href="' . sefRelToAbs("index.php?option=com_garyscookbook&Itemid=$Itemid&func=viewcategory&id=$id&startpage=$seitevor") . '><b>�</b></a>';
		}
		// Limit und Seite Vor- & Rueckfunktionen
		$start = ($startpage - 1) * $ag_perpage;
		echo "</p>";
		$database->setQuery ( "SELECT name FROM #__categories WHERE id = '" . $id . " ORDER BY name'" );
		$catname = $database->loadResult ();
		echo "<table  class='sectiontableentry2' width='100%' border='0' cellspacing='1' cellpadding='4'>";
		echo "<tr><td colspan='3' class='sectiontableheader' width='100%'>" . _gkb_CatTabheader . " ";
		echo stripslashes ( $catname );
		echo "</td></tr>";
		$query1 = "SELECT * FROM #__garyscookbook WHERE published = '1' AND catid = '" . $id . "' ORDER BY imgtitle ASC LIMIT " . $start . "," . $ag_perpage;
		$database->setQuery ( $query1 );
		$rows = $database->loadObjectList ();
		echo "<tr>";
		
		$rowcounter = 0;
		
		foreach ( $rows as $row1 ) {
			if (($rowcounter % $ag_collist == 0) and ($rowcounter != 0))
				echo "</tr><tr>";
			echo "<td class='sectiontableentry1' width='34%' align='left' valign='top'>";
			if ($row1->imgfilename != "") {
				echo "";
				echo '<p><a href="' . sefRelToAbs("index.php?option=com_garyscookbook&Itemid=$Itemid&func=detail&id=$row1->id") . '">';
				echo "<img src='$mosConfig_live_site$ag_paththumbs/$row1->imgthumbname'  hspace='4' border='0'/></a></p>";
			} else {
				echo '<p><a href="' . sefRelToAbs("index.php?option=com_garyscookbook&Itemid=$Itemid&func=detail&id=$row1->id") . '">';
				echo "<img src='$mosConfig_live_site/components/com_garyscookbook/images/tn_nopicture.jpg'  hspace='4' border='0'/></a></p>";
			}
			
			echo "<img src='images\M_images\arrow.png'/><a href='" . sefRelToAbs( "index.php?option=com_garyscookbook&Itemid=$Itemid&func=detail&id=$row1->id" ) . "'><b>$row1->imgtitle</b></a>";
			echo "<br />";
			if (strlen ( $row1->imgtext ) > $ag_reclength) {
				echo substr ( strip_tags ( $row1->imgtext ), 0, $ag_reclength );
				echo "...";
			} else {
				echo strip_tags ( $row1->imgtext );
			}
			if ($ag_showdetail)
				echo "<br /><b>" . _garyscookbook_ADMIN_HITS . ":</b> $row1->imgcounter";
			if ($ag_showrating) {
				if ($row1->imgvotes > 0) {
					$filename = "point_kl";
					$fimgvotesum = number_format ( $row1->imgvotesum / $row1->imgvotes, 0, ",", "." );
					// $frating = <img border='0' src='components/com_garyscookbook/images/$fimgvotesumpoint_kl.gif'>"$fimgvotesum ($row1->imgvotes "._garyscookbook_VOTES.")";
					if ($row1->imgvotes > 1) {
						$frating = "<img border='0' src='components/com_garyscookbook/images/$fimgvotesum$filename.gif' /> <br />($row1->imgvotes " . _garyscookbook_VOTES . ")";
					} else {
						$frating = "<img border='0' src='components/com_garyscookbook/images/$fimgvotesum$filename.gif' /> <br />($row1->imgvotes " . _garyscookbook_RATING . ")";
					}
				} else {
					$frating = _garyscookbook_NO_VOTES;
				}
				echo "<br /><b>" . _garyscookbook_RATING . ":</b> $frating";
			}
			if ($ag_showcomment) {
				// Check how many comments exist
				$comments_query = "SELECT cmtid FROM " . $mosConfig_dbprefix . "garyscookbook_comments WHERE cmtpic='$row1->id'";
				$comments_result = mysql_query ( $comments_query );
				// $comments_result = $database->openConnectionWithReturn($comments_query);
				$comments = mysql_num_rows ( $comments_result );
				echo "<br /><b>" . _garyscookbook_DEL_COMMENT . ":</b> $comments";
			}
			echo "</td>";
			$rowcounter ++;
		}
		if ($rowcounter % $ag_collist != 0) {
			for($i = 1; $i <= ($ag_collist - ($rowcounter % $ag_collist)); $i ++) {
				echo "<td class='sectiontableentry1' width='34%' valign='top'> </td>";
			}
		}
		echo "</tr></table>";
	break;
	// Standard if select at Menu
	default :
		
		global $ag_regonly, $ag_offlinecookbook, $rowcounter, $is_admin, $rowcounter, $mosConfig_absolute_path;
		require ($mosConfig_absolute_path . "/administrator/components/com_garyscookbook/config.garyscookbook.php");
		if ($ag_regonly && ! $my->id) {
			showNoAccess ();
			break;
		} else if ($ag_offlinecookbook && ! $is_admin) {
			showOfflineMsg ();
			break;
		}
		
		cookbookHeader ( 1 );
		echo "<table width='100%' border='0' cellspacing='1' cellpadding='4'>";
		echo "<tr><td class='sectiontableheader' colspan='" . $ag_collist . "'>" . _garyscookbook_CATEGORIES . "</td></tr>";
		$query1 = "SELECT * FROM #__categories WHERE section = 'com_garyscookbook' AND published = '1' AND Parent_id = 0 ORDER BY ordering ASC";
		$database->setQuery ( $query1 );
		$rows = $database->loadObjectList ();
		$line = 1;
		$linecolor = 2;
		echo "<tr>";
		foreach ( $rows as $row1 ) {
			if (($rowcounter % $ag_collist == 0) and ($rowcounter != 0)) {
				echo "</tr><tr>";
				if ($linecolor == 1) {
					$linecolor = 2;
				} else {
					$linecolor = 1;
				}
			}
			echo "<td class='sectiontableentry" . $linecolor . "' width='34%' valign='top' align='left'>";
			if ($row1->image != "") {
				echo '<a href="' . sefRelToAbs("index.php?option=com_garyscookbook&Itemid=$Itemid&func=viewcategory&id=$row1->id"). '">';
				if ($ag_catTumb) {
					echo "<img src='$thumbnailpath$row1->image' align='$row1->image_position' hspace='4' border='0' width='$ag_catpicturewidth'/></a>";
				} else {
					echo "<img src='images/stories/$row1->image' align='$row1->image_position' hspace='4' border='0' width='$ag_catpicturewidth'/></a>";
				}
			}
			if (GetNumberOfLinks ( $row1->id ) == 1) {
				$insertbez = _garyscookbook_ADMIN_PICTURE;
			} else {
				$insertbez = _gkb_Cat_Recipes;
			}
			echo "<img src='images/M_images/arrow.png' />";
			echo '<a href="' . sefRelToAbs("index.php?option=com_garyscookbook&Itemid=$Itemid&func=viewcategory&id=$row1->id") . '">';
			echo "<b>$row1->title</b></a><br /> (" . GetNumberOfLinks ( $row1->id ) . " $insertbez)";
			if ($row1->description != "") {
				if (strlen ( $row1->description ) > $ag_catlength_fp) {
					$thisdescription = substr ( strip_tags ( $row1->description ), 0, $ag_catlength_fp );
					echo "<br/>$thisdescription <a href='" . sefRelToAbs("index.php?option=com_garyscookbook&Itemid=$Itemid&func=viewcategory&id=$row1->id"); '">' . _READ_MORE . "</a></td>";
				} else {
					echo "<br/>";
					echo strip_tags ( $row1->description );
					echo "</td>";
				}
			} else {
				echo "<br/></td>";
			}
			// echo "</tr>";
			$line ++;
			$rowcounter ++;
		}
		if ($rowcounter % $ag_collist != 0) {
			for($i = 1; $i <= ($ag_collist - ($rowcounter % $ag_collist)); $i ++) {
				echo "<td class='sectiontableentry" . $linecolor . "' width='34%' valign='top'> </td>";
			}
		}
		echo "</tr></table>";
	
	break;
}
cookbookFooter ();

?>