<?php
/**
 * Gary's Cook Book SEF extension for Joomla!
 *
 * @author      $Author: Jiri Trumpes $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Security check to ensure this file is being included by a parent file.
if (! defined ( '_VALID_MOS' ))
	die ( 'Direct Access to this location is not allowed.' );

class sefext_com_garyscookbook extends sef_joomsef {
	var $params;
	
	function getCategories($id) {
		global $database;
		$database->setQuery ( "SELECT `name` FROM `#__categories` WHERE `id` = $id" );
		return $database->loadResult ();
	}
	function getImgTitle($id) {
		global $database;
		$database->setQuery ( "SELECT `imgtitle` FROM `#__garyscookbook` WHERE `id` = $id" );
		return $database->loadResult ();
	}
	function create($string, &$vars) {
		global $mosConfig_absolute_path, $mosConfig_lang;
		
		if (! defined ( '_COMPONENT_NAME' ))
			define ( '_COMPONENT_NAME', 'com_garyscookbook' );
		
		if (! defined ( '_LANG_PATH' ))
			define ( '_LANG_PATH', '/administrator/components/com_garyscookbook/language/' );
		if (! defined ( '_CUSTOM_LANG_FILE' ))
			define ( '_CUSTOM_LANG_FILE', $mosConfig_absolute_path . _LANG_PATH . $mosConfig_lang . 'php' );
		if (! defined ( '_DEFAULT_LANG_FILE' ))
			define ( '_DEFAULT_LANG_FILE', $mosConfig_absolute_path . _LANG_PATH . 'english.php' );
		
		require_once (file_exists ( _CUSTOM_LANG_FILE ) ? _CUSTOM_LANG_FILE : _DEFAULT_LANG_FILE);
		
		extract ( $vars );
		$title = array ( );
		
		$this->params = SEFTools::getExtParams ( _COMPONENT_NAME );
		$texts = SEFTools::getExtTexts ( _COMPONENT_NAME );
		$title [] = getMenuTitle ( @$option, @$func, @$Itemid );
		
		if (! defined ( '_garyscookbook_MOST_VIEWED' ))
			define ( '_garyscookbook_MOST_VIEWED', 'Most Viewed' );
		if (! defined ( '_garyscookbook_TOP_RATED' ))
			define ( '_garyscookbook_TOP_RATED', 'Top Rated' );
		if (! defined ( '_garyscookbook_LAST_ADDED' ))
			define ( '_garyscookbook_LAST_ADDED', 'Last Added' );
		if (! defined ( '_garyscookbook_LAST_COMMENTED' ))
			define ( '_garyscookbook_LAST_COMMENTED', 'Last Commented' );
		if (! defined ( '_garyscookbook_CATEGORIES' ))
			define ( '_garyscookbook_CATEGORIES', "Categories" );
		if (! defined ( '_garyscookbook_ADD_cookbook' ))
			define ( '_garyscookbook_ADD_cookbook', 'Add a Recipe to the Cookbook' );
		if (! defined ( '_garyscookbook_EDIT_RECIPE' ))
			define ( '_garyscookbook_EDIT_RECIPE', 'Edit recipe' );
		
		switch ( @$func) {
			case 'special' :
				switch ( @$sorting) {
					case 'rating' :
						$title [] = _garyscookbook_TOP_RATED;
					break;
					case 'lastadd' :
						$title [] = _garyscookbook_LAST_ADDED;
					break;
					case 'lastcomment' :
						$title [] = _garyscookbook_LAST_COMMENTED;
					break;
					default :
						$title [] = _garyscookbook_MOST_VIEWED;
					break;
				}
			break;
			case 'viewcategory' :
				$title [] = $this->getCategories ( $id );
			break;
			case 'detail' :
				$title [] = $this->getImgTitle ( $id );
			break;
			case 'newItem' :
				$title [] = _garyscookbook_ADD_cookbook;
			break;
			case 'editpic' : 
				$title [] = _garyscookbook_EDIT_RECIPE . ' ' . $this->getImgTitle($id);
			break;
		}
		
		if (count ( $title ) > 0) {
			$nonSefVars = array ( );
			if (isset ( $limit ))
				$nonSefVars ['limit'] = $limit;
			if (isset ( $limitstart ))
				$nonSefVars ['limitstart'] = $limitstart;
			$string = sef_joomsef::sefGetLocation ( $string, $title, @$task, null, null, @$lang, $nonSefVars );
		}
		return $string;
	}
}

?>