<?php
/**
 * VirtueMart SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

if( !defined('') )  define('', '');
if( !defined('_SEYRETSEF_ADDLINKFRONT') )       define('_SEYRETSEF_ADDLINKFRONT', 'add link');
if( !defined('_SEYRETSEF_ALLVIDEOSLIST') )      define('_SEYRETSEF_ALLVIDEOSLIST', 'all');
if( !defined('_SEYRETSEF_CHANGEDIRECTORY') )    define('_SEYRETSEF_CHANGEDIRECTORY', 'change directory');
if( !defined('_SEYRETSEF_EDITVIDEOS') )         define('_SEYRETSEF_EDITVIDEOS', 'edit');
if( !defined('_SEYRETSEF_FEATUREDVIDEOS') )     define('_SEYRETSEF_FEATUREDVIDEOS', 'featured');
if( !defined('_SEYRETSEF_HELP') )               define('_SEYRETSEF_HELP', 'help');
if( !defined('_SEYRETSEF_PENDINGVIDEOSLIST') )  define('_SEYRETSEF_PENDINGVIDEOSLIST', 'pending');
if( !defined('_SEYRETSEF_REPORTEDVIDEOS') )     define('_SEYRETSEF_REPORTEDVIDEOS', 'reported');
if( !defined('_SEYRETSEF_REPORTVIDEO') )        define('_SEYRETSEF_REPORTVIDEO', 'report');
if( !defined('_SEYRETSEF_SHOWVIDEO') )          define('_SEYRETSEF_SHOWVIDEO', 'show');
if( !defined('_SEYRETSEF_UPLOADVIDEO') )        define('_SEYRETSEF_UPLOADVIDEO', 'upload');
if( !defined('_SEYRETSEF_USERVIDEOSLIST') )     define('_SEYRETSEF_USERVIDEOSLIST', 'user');
if( !defined('_SEYRETSEF_VIDEODIRECTLINK') )    define('_SEYRETSEF_VIDEODIRECTLINK', '');
if( !defined('_SEYRETSEF_VIDEOLIST') )          define('_SEYRETSEF_VIDEOLIST', 'videos');

class sefext_com_seyret extends sef_joomsef
{
    var $params;

    function GetParentId($catId) {
        $parentId = intval(preg_replace('/^(.*)\*([^\*]*)\*#/', '$2', $catId));
        return $parentId;
    }

    // Creates an array of nested categories from given category id
    function GetCategories($catId) {
        global $database;

        $categories = array();

        // If set not to add any category
        if( $this->params->get('categories', '2') == '0' )  $catId = 0;

        while ($catId > 0) {
            $database->setQuery("SELECT `id`, `categoryname`, `parentcat` FROM `#__seyret_categories` WHERE `id` = '$catId'");
            $row = null;
            $database->loadObject($row);

            $name = $row->categoryname;
            array_unshift ($categories, $name);

            // If set to add last category only
            if( $this->params->get('categories', '2') == '1' )   break;

            $catId = $this->GetParentId($row->parentcat);
        }
        return $categories;
    }

    function GetItemInfo($id) {
        global $database;

        $query = "SELECT `id`, `catid`, `title` FROM `#__seyret_items` WHERE `id` = '$id'";
        $database->setQuery($query);
        $row = null;
        $database->loadObject($row);

        return $row;
    }

    function GetUserInfo($id) {
        global $database;

        $query = "SELECT `id`, `username` FROM `#__users` WHERE `id` = '$id'";
        $database->setQuery($query);
        $row = null;
        $database->loadObject($row);

        return $row;
    }

    function create($string, &$vars) {
        // Load extension parameters
        $this->params = SEFTools::GetExtParams('com_seyret');

        // Create an associative array for task => url_text conversion
        $tasks = array();
        $tasks['addlinkfront']      = _SEYRETSEF_ADDLINKFRONT;
        $tasks['allvideoslist']     = _SEYRETSEF_ALLVIDEOSLIST;
        $tasks['changedirectory']   = _SEYRETSEF_CHANGEDIRECTORY;
        $tasks['editvideos']        = _SEYRETSEF_EDITVIDEOS;
        $tasks['featuredvideos']    = _SEYRETSEF_FEATUREDVIDEOS;
        $tasks['help']              = _SEYRETSEF_HELP;
        $tasks['pendingvideoslist'] = _SEYRETSEF_PENDINGVIDEOSLIST;
        $tasks['reportedvideos']    = _SEYRETSEF_REPORTEDVIDEOS;
        $tasks['reportvideo']       = _SEYRETSEF_REPORTVIDEO;
        $tasks['showvideo']         = _SEYRETSEF_SHOWVIDEO;
        $tasks['uploadvideo']       = _SEYRETSEF_UPLOADVIDEO;
        $tasks['uservideoslist']    = _SEYRETSEF_USERVIDEOSLIST;
        $tasks['videodirectlink']   = _SEYRETSEF_VIDEODIRECTLINK;
        $tasks['videolist']         = _SEYRETSEF_VIDEOLIST;

        // Extract variables
        extract($vars);
        $title = array();

        $title[] = getMenuTitle(@$option, @$task, @$Itemid);

        // Find catid for item id
        if( isset($id) ) {
            $item = $this->GetItemInfo($id);
            if( !isset($catid) ) {
                $catid = $this->GetParentId($item->catid);
            }
        }

        // Create nested categories
        if( isset($catid) ) {
            $title = array_merge($title, $this->GetCategories($catid));
        }

        // Add item title
        if( isset($item) ) {
            $title[] = $item->title;
        }

        // Set the text according to task
        if( isset($task) && in_array($task, array_keys($tasks)) ) {
            if( $tasks[$task] != '' ) {
                $title[] = $tasks[$task];
            }

            switch($task) {
                case 'uservideoslist':
                    // Add username if userid given
                    if( isset($userid) ) {
                        $user = $this->GetUserInfo($userid);
                        if( isset($user) ) {
                            $title[] = $user->username;
                        }
                    }
                    break;
            }

            unset($task);
        }

        if (count($title) > 0) {
            $nonSefVars = array();
            $ignoreVars = array();

            // non-sef vars
            if (isset($from))       $nonSefVars['from'] = $from;
            if (isset($no_html))    $nonSefVars['no_html'] = $no_html;
            if (isset($sender))     $nonSefVars['sender'] = $sender;

            // ignored vars

            $string = sef_joomsef::sefGetLocation($string, $title, @$task, null, null, @$lang, $nonSefVars, $ignoreVars);
        }

        return $string;
    }
}
?>