<?php
/**
 * SEF module for Joomla!
 * Extension for Mosets Tree component.
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

class sefext_com_zoom extends sef_joomsef
{
    /**
     * Helper function to get parent and sub category tree array for building URL
     */
    function GetCategoryArray($catid)
    {
        global $database;

        static $tree = false;
        if (!$tree){
            $database->setQuery("SELECT `catname`, `catid`, `subcat_id` FROM `#__zoom`");
            $tree = $database->loadObjectList('catid');
        }
        $title = array();
        while ($catid != 0) {
            $title[] = $tree[$catid]->catname;
            $catid = $tree[$catid]->subcat_id;
        }

        return array_reverse($title);
    }

    function GetCategoryName($catid)
    {
        global $database;

        $cat = null;
        $database->setQuery("SELECT `catname`, `catid` FROM `#__zoom` WHERE `catid` = '$catid' LIMIT 1");
        $database->loadObject($cat);

        return (isset($cat->catname) ? $cat->catname : '');
    }

    function GetMediaName($id)
    {
        global $database;

        $media = null;
        $database->setQuery("SELECT `imgname`, `imgid` FROM `#__zoomfiles` WHERE `imgid` = '$id' LIMIT 1");
        $database->loadObject($media);

        return (isset($media->imgname) ? $media->imgname : '');
    }

    function beforeCreate($string)
    {
        // Remove the PageNo variable if it's 1
        if (preg_match('/PageNo=(([^0-9]+)|$)/', $string) >= 1 && stristr($string, 'PageNo=') !== false) {
            $string = SEFTools::RemoveVariable($string, 'PageNo');
        }

        return $string;
    }

    function create($string, &$vars) {
        global $database;

        // Load the texts to use in URL
        $texts = SEFTools::getExtTexts('com_zoom');

        // Create an associative array for page => url_text conversion
        $pages = array();
        $pages['admin'] =       isset($texts['_ZOOM_ADMIN']) ? $texts['_ZOOM_ADMIN'] : 'Admin';
        $pages['catsmgr'] =     isset($texts['_ZOOM_CATSMGR']) ? $texts['_ZOOM_CATSMGR'] : 'Gallery Manager';
        $pages['mediamgr'] =    isset($texts['_ZOOM_MEDIAMGR']) ? $texts['_ZOOM_MEDIAMGR'] : 'Media Manager';
        $pages['zoomthumb'] =   isset($texts['_ZOOM_ZOOMTHUMB']) ? $texts['_ZOOM_ZOOMTHUMB'] : 'Thumb Coder';
        $pages['settings'] =    isset($texts['_ZOOM_SETTINGS']) ? $texts['_ZOOM_SETTINGS'] : 'Settings';
        $pages['optimize'] =    isset($texts['_ZOOM_OPTIMIZE']) ? $texts['_ZOOM_OPTIMIZE'] : 'Optimize';
        $pages['ecard'] =       isset($texts['_ZOOM_ECARD']) ? $texts['_ZOOM_ECARD'] : 'e-card';
        $pages['lightbox'] =    isset($texts['_ZOOM_LIGHTBOX']) ? $texts['_ZOOM_LIGHTBOX'] : 'Lightbox';
        $pages['quicksearch'] = isset($texts['_ZOOM_QUICKSEARCH']) ? $texts['_ZOOM_QUICKSEARCH'] : 'Quick Search';
        $pages['search'] =      isset($texts['_ZOOM_SEARCH']) ? $texts['_ZOOM_SEARCH'] : 'Search';
        $pages['credits'] =     isset($texts['_ZOOM_CREDITS']) ? $texts['_ZOOM_CREDITS'] : 'Credits';
        $pages['view'] =        isset($texts['_ZOOM_VIEW']) ? $texts['_ZOOM_VIEW'] : 'View';
        $pages['editimg'] =     isset($texts['_ZOOM_EDITIMG']) ? $texts['_ZOOM_EDITIMG'] : 'Edit Media';

        $sortings = array();
        $sortings[0] = isset($texts['_ZOOM_TOPTEN']) ? $texts['_ZOOM_TOPTEN'] : 'Top Ten';
        $sortings[1] = isset($texts['_ZOOM_LASTSUBMITTED']) ? $texts['_ZOOM_LASTSUBMITTED'] : 'Last submitted';
        $sortings[2] = isset($texts['_ZOOM_LASTCOMMENTED']) ? $texts['_ZOOM_LASTCOMMENTED'] : 'Last commented';
        $sortings[4] = isset($texts['_ZOOM_TOPRATED']) ? $texts['_ZOOM_TOPRATED'] : 'Top Rated';

        $tasks = array();
        $tasks['edtimg']    = isset($texts['_ZOOM_EDITIMG']) ? $texts['_ZOOM_EDITIMG'] : 'Edit Media';
        $tasks['step']      = isset($texts['_ZOOM_STEP']) ? $texts['_ZOOM_STEP'] : 'Step';
        $tasks['step1']     = isset($texts['_ZOOM_STEP1']) ? $texts['_ZOOM_STEP1'] : 'Step1';
        $tasks['step2']     = isset($texts['_ZOOM_STEP2']) ? $texts['_ZOOM_STEP2'] : 'Step2';
        $tasks['step3']     = isset($texts['_ZOOM_STEP3']) ? $texts['_ZOOM_STEP3'] : 'Step3';
        $tasks['step4']     = isset($texts['_ZOOM_STEP4']) ? $texts['_ZOOM_STEP4'] : 'Step4';

        $params = SEFTools::getExtParams('com_zoom');

        /**
         * Use this to get variables from the original Joomla! URL, such as $task, $page, $id, $catID, ...
         */
        extract($vars);
        $title = array();

        $title[] = getMenuTitle(@$option, @$task, @$Itemid);

        /**
         * Get category tree (parent cat and sub cats).
         */
        $categories = $params->get('categories', '2');
        if (isset($catid) && ($catid != 0) && (@$page != 'zoomthumb') && ((@$page != 'mediamgr') && (@$task != 'edtimg')) ) {
            if( $categories != '0' ) {
                if( $categories == '1' ) {
                    $title[] = $this->GetCategoryName($catid);
                } else {
                    $title = array_merge($title, $this->GetCategoryArray($catid));
                }
            }
            unset($vars['catid']);
        }

        if( isset($key) && ((@$page != 'mediamgr') && (@$task != 'editimg')) ) {
            $title[] = $this->GetMediaName($key+1);
            unset($key);
        }

        if( isset($page) ) {
            switch($page) {
                case 'catsmgr':
                case 'mediamgr':
                case 'zoomthumb':
                case 'settings':
                case 'editimg':
                    $title[] = $pages['admin'];
                    $title[] = $pages[$page];

                    if( ($page == 'mediamgr') ) {
                        if( @$task == 'edtimg' )    $title[] = $tasks['edtimg'];

                        if( isset($catid) ) $title[] = $catid;
                        if( isset($key) )   $title[] = $key;
                        unset($task);
                    }

                    if( ($page == 'zoomthumb') && isset($task) ) {
                        if( in_array($task, array_keys($tasks)) ) {
                            $title[] = $tasks[$task];
                        }
                        if( isset($catid) ) $title[] = $catid;
                        if( isset($imgid) ) $title[] = $imgid;
                        unset($task);
                    }
                    break;

                case 'admin':
                    $title[] = $pages['admin'];
                    if( isset($action) && ($action == 'optimize') ) {
                        $title[] = $pages['optimize'];
                    }
                    break;

                case 'special':
                    if( isset($sorting) && in_array($sorting, array_keys($sortings)) ) {
                        $title[] = $sortings[$sorting];
                        unset($sorting);
                    }
                    break;

                case 'ecard':
                case 'lightbox':
                case 'view':
                case 'credits':
                    if( in_array($page, array_keys($pages)) ) {
                        $title[] = $pages[$page];
                    }
                    break;

                case 'search':
                    if( isset($type) && ($type == 'quicksearch') ) {
                        $title[] = $pages['quicksearch'];
                    } else {
                        $title[] = $pages['search'];
                    }
                    break;
            }

            unset($page);
        }

        /**
         * Pass the title array to the sefGetLocation function.
         */ 
        if (count($title) > 0) {
            $nonSefVars = array();
            if( isset($sorting) )   $nonSefVars['sorting'] = $sorting;
            if( isset($sstring) )   $nonSefVars['sstring'] = $sstring;
            if( isset($PageNo) )    $nonSefVars['PageNo'] = $PageNo;
            if( isset($offset) )    $nonSefVars['offset'] = $offset;

            // Only add these variables when their values aren't default
            if( isset($hit) && ($hit != 1) )        $nonSefVars['hit'] = $hit;

            $string = sef_joomsef::sefGetLocation($string, $title, null, @$limit, @$limitstart, @$lang, $nonSefVars);
        }

        return $string;
    }
}
?>
