<?php
/**
 * SimpleCalendar SEF extension for Joomla!
 *
 * @copyright  2009 Denis Dulici
 * @license	    GNU General Public License
 * www.denisdulici.com
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_simplecalendar extends SefExt
{
    var $params;

    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        if (!is_null($uri->getVar('limit')))
            $this->nonSefVars['limit'] = $uri->getVar('limit');
        if (!is_null($uri->getVar('limitstart')))
            $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
    }
    
    function getCategoryTitle($catid) {
        $database =& JFactory::getDBO();
        $database->setQuery("SELECT `categoryID`, `categoryName` FROM `#__simplecal_categories` WHERE `categoryID` = $catid");
        $cat = $database->loadObject();
        if($cat) {
            $name = ( ($this->params->get('categoryid_inc', '0') != '0') ? $catid.'-' : '' ).$cat->categoryName;
            return $name;
        } else {
            return null;
        }
    }

    function getEventTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery("SELECT `id`, `entryName`, `categoryID` FROM `#__simplecal` WHERE `id` = $id");
        $event = $database->loadObject();
        if($event) {
            $name = ( ($this->params->get('eventid_inc', '0') != '0') ? $id.'-' : '' ).$event->entryName;
            if( $this->params->get('category_inc', '1') != '1' ) {
                return array( $name );
            } else {
                return array( $this->getCategoryTitle($event->categoryID), $name );
            }
        }
        else {
            return array();
        }
    }

    function beforeCreate(&$uri) {
        if (!is_null($uri->getVar('catid')) && ($uri->getVar('catid') == '')) {
            $uri->delVar('catid');
        }
        
        if (($uri->getVar('view') == 'detail') && !is_null($uri->getVar('id')) && !is_null($uri->getVar('catid'))) {
            $uri->delVar('catid');
        }
        
        // Remove the part after ':' from variables
        if( !is_null($uri->getVar('id')) )       SEFTools::fixVariable($uri, 'id');
        if( !is_null($uri->getVar('catid')) )    SEFTools::fixVariable($uri, 'catid');
        
        return;
    }

    function create(&$uri) {
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $this->params = SEFTools::getExtParams('com_simplecalendar');
		
		$title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
		
		if( isset($view) ) {
            switch($view) {
				case 'calendar':
                    if( isset($catid) && $catid != 0 ) {
                        $title[] = $this->getCategoryTitle($catid);
                    }
					if (isset($order)) {
			            switch($order) {
							case 'category':
								$title[] = JText::_('BY_CATEGORY');
				                break;
							case 'date':
								$title[] = JText::_('BY_DATE');
				                break;
						}
					}
                    unset($view);
                    break;
				case 'detail':
				    if (isset($id)) {
                        $title = array_merge($title, $this->getEventTitle($id));
				    }
					unset($view);
                    break;
				case 'form':
				    $title[] = JText::_('NEW EVENT');
					unset($view);
                    break;
			}
		}
		
        if (isset($format)) {
            if ($format == 'pdf') {
                $title[] = 'pdf';
            }
            else if ($format == 'feed' && isset($type)) {
                $title[] = $type;
            }
        }
        if (isset($print) && ($print == 1)) {
            $title[] = JText::_('Print');
        }
        if (isset($vcal) && ($vcal == 1)) {
            $title[] = 'vcal';
        }
		
        $newUri = $uri;
        if (count($title) > 0) {
            $this->_createNonSefVars($uri);
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$view, @$limit, @$limitstart, @$lang, $this->nonSefVars);
        }

        return $newUri;
    }
}
?>