<?php 
/**
 * SEF extension for Estate Agent Improved
 *
 * @author      Giannis from Estate Impeoved team
 * 
 * @package     
 */

class SefExt_com_estateagent extends SefExt
{
    var $params;
	
		
    
    function beforeCreate(&$uri) {
		$lang =& JFactory::getLanguage();
		$lang->load('com_estateagent',JPATH_SITE);
		if( !is_null($uri->getVar('limitstart')) && ($uri->getVar('limitstart') == '0') ) {
            $uri->delVar('limitstart');
            $uri->delVar('limit');
        }
		
		
		if( !is_null($uri->getVar('id'))) SEFTools::fixVariable($uri, 'id');
        return;
    }


    function create(&$uri) {
 
 		$vars = $uri->getQuery(true);
        extract($vars);
		
		$excludelist=array('mtgcalc','curncyconverter','sendmail','eaadmin','gallery','newCaptcha','sendmtf','export');
		if( isset($view) && (@in_array($view, $excludelist)) ) {
            return $uri;
        }
			
        $title = array();
        $this->params = SEFTools::getExtParams('com_estateagent');
		
       $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
		//$title[] = JoomSEF::_getMenuTitle(@$option, @$view, @$Itemid);
//die($vars);
if( isset($view) ) {
			switch($view){
				
				//default:
				case "categories":
					$title[]=JText::_('categories');
					unset($view);
				break;

				case "category":
					if(isset($id)){
						$alias=getTheAlias('estateagent_categories', 'id', $id, 'alias');
						if ($alias !==""){
							$title[] = $alias;
						}else{
							$name=getTheAlias('estateagent_categories', 'id', $id, 'name');
							$title[] = $name;
						}
			
						unset($id);
					}
					unset($view);
				break;
				case "showproperty":
					if(isset($id)){
						$alias=getTheAlias('estateagent', 'id', $id,'alias');
						$catid=getCategoryId($id);
						$cat_alias=getTheAlias('estateagent_categories', 'id', $catid,'alias');
						if ($alias !==""){
							$title[] = $cat_alias;
							$title[] = $alias;
						}else{
							$propertytitle=getTheAlias('estateagent', 'id', $id,'title');
							$name=getTheAlias('estateagent_categories', 'id', $catid,'name');
							$title[] = $name;
							$title[] = $propertytitle;
						}
						
						unset($id);
					}
				unset($view);
				break;
				case "agents":
					$title[]=JText::_('agents');
					unset($view);
				break;
				case "showagent":
					$title[]=JText::_('agent');
					if(isset($id)){
						$alias=getTheAlias('estateagent_agents', 'id', $id,'alias');
						if ($alias !=="") $title[] = $alias;
						
						unset($id);
					}
					unset($view);
				break;
				case "agentproperties"://---------------------------------------
					$title[]=JText::_('properties list');
					if(isset($id)){
						$alias=getTheAlias('estateagent_agents', 'id', $id,'alias');
						if ($alias !==""){
							$title[] = $alias;
						}
						
						unset($id);
					}
					unset($view);
				break;
				case "showtype":
					$title[]=JText::_('types');
					if(isset($id)){
						$alias=getTheAlias('estateagent_type', 'id', $id,'alias');
						if ($alias !==""){
							$title[] = $alias;
						}
						
						unset($id);
					}
					unset($view);
				break;
				case "showhot":
					$title[]=JText::_('hot properties');
					unset($view);
				break;
				case "easearch":
					$title[]=JText::_('search');
					unset($view);
				break;
				case "dosearch":
					$title[]=JText::_('results');
					unset($view);
				break;
				case "searchresults"://-------------------------------------
					$title[]=JText::_('show results');
					unset($view);
				break;
				case "shortlist":
					$title[]=JText::_('EA_VIEW MY SHORTLIST');
					unset($view);
				break;
				case "rss"://-----------------
					$title[]=JText::_('rss');
					unset($view);
				break;
				case "properties"://-----------------
					$title[]=JText::_('show all properties');
					unset($view);
				break;
				case "curncyconverter"://-----------------
					$title[]=JText::_('EA_CURRENCY_CONVERTER');
					unset($view);
				break;
				case "mtfform"://-----------------
						if(isset($id)){
						$alias=getTheAlias('estateagent', 'id', $id,'alias');
						$catid=getCategoryId($id);
						$cat_alias=getTheAlias('estateagent_categories', 'id', $catid,'alias');
						if ($alias !==""){
							$title[] = $cat_alias;
							$title[] = $alias;
							$title[]=JText::_('EA_EMAIL_FRIEND');
						}else{
							$title[]=JText::_('EA_EMAIL_FRIEND');
						}
						
						unset($id);
					}else{
						$title[]=JText::_('EA_EMAIL_FRIEND');
					}
					unset($view);
				break;
				case "pdfexport"://-----------------
					if(isset($id)){
						$alias=getTheAlias('estateagent', 'id', $id, 'alias' );
						$catid=getCategoryId($id);
						$cat_alias=getTheAlias('estateagent_categories', 'id', $catid,'alias');
						if ($alias !==""){
							$title[] = $cat_alias;
							$title[] = $alias;
							$title[]=JText::_('PDF');
						}else{
							$title[]=JText::_('PDF');
						}
						
						unset($id);
					}else{
						$title[]=JText::_('PDF');
					}
					unset($view);	
				break;
				case "print"://-----------------
					if(isset($id)){
						$alias=getTheAlias('estateagent', 'id', $id,'alias');
						$catid=getCategoryId($id);
						$cat_alias=getTheAlias('estateagent_categories', 'id', $catid,'alias');
						if ($alias !==""){
							$title[] = $cat_alias;
							$title[] = $alias;
							$title[]=JText::_('print');
						}else{
							$title[]=JText::_('print');
						}
						
						unset($id);
					}else{
						$title[]=JText::_('print');
					}
					unset($view);
					
				break;
				case "emailmyshortlist"://-----------------
					$title[]=JText::_('EA_GET_MY_SHORTLIST');
					unset($view);
				break;
				case "mailform"://-----------------
					
					if(isset($id)){	
						$title[]=JText::_('agent');
						$alias=getTheAlias('estateagent_agents', 'id', $id,'alias');
						if ($alias !=="") $title[] = $alias;
						$title[] = JText::_('contact');
						unset($id);
					}else{
						$title[]=JText::_('EA_AGENT_CONTACT');
					}
					unset($view);
				
				break;
			}
}

			

		$nonSefVars = array();
       if( isset($vars['limit']))       $nonSefVars['limit'] = $limit;
        if( isset($vars['limitstart']))  $nonSefVars['limitstart'] = $limitstart;
		
		
		$ignoreVars = array();
		
        $newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars,$ignoreVars,null, null, true );
        }

        return $newUri;
	}
}

function getTheAlias($table, $id_name, $id_value, $field) {		
		
		$alias ="";
		$database =& JFactory::getDBO();
		$query  = "SELECT * FROM #__".$table." WHERE ".$id_name."=". ( int )$id_value;
	    $database->setQuery($query);
	    $result = $database->loadObject();
	    $alias = $result->$field;
		return $alias;
    }

function getCategoryId($id) {			
		$cid ="";
		$database =& JFactory::getDBO();
		$query  = "SELECT * FROM #__estateagent WHERE id=". ( int )$id;
	    $database->setQuery($query);
	    $result = $database->loadObject();
	    $cid = $result->cat;
		return $cid;
    }


?>