<?php

/**
 * Install component script.
 * 
 * @version		$Id$
 * @package		ARTIO Booking 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');
if(!defined('DS')){
	define('DS',DIRECTORY_SEPARATOR);
}
$helpers = JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_booking' . DS . 'helpers' . DS;

include_once ($helpers . 'importer.php');
include_once ($helpers . 'html.php');
include_once ($helpers . 'model.php');

if (! class_exists('JFile'))
    jimport('joomla.filesystem.file');

AImporter::defines();
//import needed JoomLIB helpers
AImporter::helper('installer', 'parameter');
//import needed model
AImporter::model('admin', 'config');

/* @var $jinstaller JInstallerComponent */
if(isset($parent))
  BookingInstaller::jinstaller('set', $parent);
else
  BookingInstaller::jinstaller('set', $this);

function com_install()
{
    AInstaller::install();
    AInstallerJoomFish::install();
    BookingInstaller::rename();
    BookingInstaller::update();
    BookingInstaller::setConfig();
    BookingInstaller::info();
    return true;
}

class BookingInstaller
{

    /**
	 * Store instance of Joomla installer.
	 * @param string $operation set or get
	 * @param JInstallerComponent $instance
	 * @return JInstallerComponent
	 */
    function jinstaller($operation, $instance = null)
    {
        static $jinstaller;
        switch ($operation) {
            case 'set':
                $jinstaller = $instance;
                break;
            case 'get':
                return $jinstaller;
        }
    }

    function rename()
    {
        if (file_exists($manifest = JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_booking' . DS . 'booking.xml'))
            if (($handle = fopen($manifest, 'r'))) {
                $content = '';
                while (! feof($handle))
                    $content .= fgets($handle);
                fclose($handle);
                if (($handle = fopen($manifest, 'w'))) {
                    fwrite($handle, str_replace('<name>Booking</name>', '<name>' . COMPONENT_NAME . '</name>', $content));
                    fclose($handle);
                }
            }
    }

	function setConfig()
    {
        JFactory::getDbo()->setQuery("SELECT COUNT(*) FROM #__booking_config");
        
        if (JFactory::getDbo()->loadResult() === '0') { // fresh installation => config is completely empty
        
        	$params = new JParameter('');
        	$model = new BookingModelConfig();
        
        	// copy e-mailing data from Joomla config
        	$params->set('mailing_manager', JFactory::getApplication()->getCfg('mailfrom'));

			foreach (BookingInstaller::jinstaller('get')->manifest->getElementByPath('params')->children() as $param)
       			/* @var $param JSimpleXMLElement */
       			$params->setValue($param->attributes('name'), $param->attributes('default'));
        
        	$params = $params->toArray();
        	$data['params'] = $params;
        	$model->store($data);
        	$model->setAdmins();
        }
    }

    function info()
    {
        $language = &JFactory::getLanguage();
        /* @var $language JLanguage */
        $language->load('com_booking', JPATH_ADMINISTRATOR);
        echo '<div class="install" style="background-color: #FFF;padding: 20px;">';
        echo '<a href="index.php?option=com_booking" title="">';
        echo '<img src="'.JURI::root().'components/com_booking/assets/images/logo-150.png" alt="" style="float: left;padding-right: 20px;" />';
        echo '</a>';
        echo '<h2 style="color: #0B55C4;font-size: 30px;line-height: 30px;margin: 0;padding: 0 0 10px 170px;">';
        echo '<a href="index.php?option=com_booking" title="">ARTIO Booking</a>';
        echo '</h2>';
        echo '<p style="font-size: 14px;margin: 0;padding: 0 0 10px 170px;width: 50%;">' . JText::_('Booking description') . '</p>';
        echo '<p style="font-size: 14px;margin: 0;padding: 0 0 10px 170px;width: 50%;">' . str_replace('"_QQ_"', '"', JText::_('Sample data')) . '</p>';
        echo '</div>';
    }

    function update($sql = null)
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $db = &JFactory::getDBO();
        /* @var $db JDatabaseMySQL */
        
        $fields = BookingInstaller::getTableFields('#__booking_template');
        if (! in_array('params', $fields) && in_array('calendars', $fields)) {
            BookingInstaller::query($db, $mainframe, 'ALTER TABLE `#__booking_template` ADD `params` TEXT NOT NULL AFTER `id`');
            $db->setQuery('SELECT `id`,`calendars` FROM `#__booking_template`');
            foreach ($db->loadObjectList() as $calendar)
                BookingInstaller::query($db, $mainframe, 'UPDATE `#__booking_template` SET `params` = ' . $db->Quote('calendars=' . $calendar->calendars . "\n") . ' WHERE `id` = ' . $calendar->id);
            BookingInstaller::query($db, $mainframe, 'ALTER TABLE `#__booking_template` DROP `calendars`');
        }
        
        $fields = BookingInstaller::getTableFields('#__booking_subject');
        if (! in_array('params', $fields) && in_array('image', $fields) && in_array('images', $fields)) {
            BookingInstaller::query($db, $mainframe, 'ALTER TABLE `#__booking_subject` ADD `params` TEXT NOT NULL AFTER `hits`');
            $db->setQuery('SELECT `id`,`image`,`images` FROM `#__booking_subject`');
            foreach ($db->loadObjectList() as $subject)
                BookingInstaller::query($db, $mainframe, 'UPDATE `#__booking_subject` SET `params` = ' . $db->Quote('image=' . $subject->image . "\n" . 'images=' . $subject->images . "\n") . ' WHERE `id` = ' . $subject->id);
            BookingInstaller::query($db, $mainframe, 'ALTER TABLE `#__booking_subject` DROP `image`,DROP `images`');
        }
        
        $fields = BookingInstaller::getTableFields('#__booking_customer');
        if (in_array('title_behind', $fields))
            BookingInstaller::query($db, $mainframe, 'ALTER TABLE `#__booking_customer` CHANGE `title_behind` `title_before` VARCHAR( 20 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ');
        
        $fields = BookingInstaller::getTableFields('#__booking_reservation');
        if (in_array('title_behind', $fields))
            BookingInstaller::query($db, $mainframe, 'ALTER TABLE `#__booking_reservation` CHANGE `title_behind` `title_before` VARCHAR( 20 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL');
        if (in_array('pay', $fields))
            BookingInstaller::query($db, $mainframe, 'ALTER TABLE `#__booking_reservation` CHANGE `pay` `paid` TINYINT( 4 ) NULL DEFAULT NULL');
        
        if (! $sql)
            $queries = JFile::read(JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_booking' . DS . 'sql' . DS . 'install.mysql.utf8.sql');
        else
            $queries = JFile::read($sql);
            
        $matches = array();
        if (preg_match_all('#CREATE TABLE IF NOT EXISTS `([^`]*)` ([^;]*);#isU', $queries, $matches, PREG_SET_ORDER)) {
            foreach ($matches as $match) {
                $table = new stdClass();
                $table->name = $match[1];
                $atribs = array();
                if (preg_match_all("#`([^`]*)` ([^ ]*) ([^,]*),#isU", $match[2], $atribs, PREG_SET_ORDER)) {
                    foreach ($atribs as $atrib) {
                        $table->atribs[$atrib[1]] = $atrib[2];
                    }
                }
                $tables[] = $table;
            }
        }
        
        $queries = $db->splitSql($queries);
        $count = count($queries);
        for ($i = 0; $i < $count; $i ++)
            if (($query = JString::trim($queries[$i])))
                BookingInstaller::query($db, $mainframe, $query);
        
        if (isset($tables)) {
            foreach ($tables as $table) {
                if (AModel::tableExists($table->name)) {
                    $fields = BookingInstaller::getTableFields($table->name);
                    foreach ($table->atribs as $atribname => $datatype) {
                        if (! in_array($atribname, $fields)) {
                            BookingInstaller::query($db, $mainframe, sprintf('ALTER TABLE `%s` ADD `%s` %s', $table->name, $atribname, $datatype));
                        } else {
                            unset($fields[array_search($atribname, $fields)]);
                        }
                    }
                    if (count($fields)) {
                        $drops = array();
                        foreach ($fields as $field) {
                            $drops[] = sprintf('DROP `%s`', $field);
                        }
                        BookingInstaller::query($db, $mainframe, sprintf('ALTER TABLE `%s` %s', $table->name, implode(',', $drops)));
                    }
                }
            }
        }
        
        // add fields for periodic reservations
        $columns = array_keys($db->getTableFields('#__booking_reservation_items'));
        if (!in_array('period_time_up', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_time_up time NOT NULL');
        	$db->query();
        }
        if (!in_array('period_time_down', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_time_down time NOT NULL');
        	$db->query();
        }
        if (!in_array('period_type', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_type tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_recurrence', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_recurrence int(11) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_monday', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_monday tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_tuesday', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_tuesday tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_wednesday', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_wednesday tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_thursday', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_thursday	tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_friday', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_friday tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_saturday', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_saturday	tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_sunday', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_sunday tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_month', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_month tinyint(2) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_week', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_week tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_day', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_day tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_date_up', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_date_up date NOT NULL');
        	$db->query();
        }
        if (!in_array('period_end', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_end tinyint(1) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_occurrences', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_occurrences int(11) NOT NULL');
        	$db->query();
        }
        if (!in_array('period_date_down', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_date_down date NOT NULL');
        	$db->query();
        }
        if (!in_array('period_total', $columns)) {
        	$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_total int(11) NOT NULL');
        	$db->query();
        }
    }

    function query(&$db, &$mainframe, $query)
    {
        $db->setQuery($query);
        $db->query();
    }

    function getTableFields($tableName)
    {
        $db = &JFactory::getDBO();
        /* @var $db JDatabaseMySQLi */
        return array_keys(reset($db->getTableFields($tableName)));
    }
}

?>