<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage 	models
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.model');

class BookingModelClosingday extends JModel
{
	public function getItem($id = 0)
	{
		$id = reset(JRequest::getVar('cid', array(JRequest::getInt('id', $id))));
		$item = $this->getTable();
		/* @var $item TableClosingday */
		$item->load($id);
		return $item;
	}
	
	public function save()
	{
		$data = JRequest::get('request');
		$closingday = $this->getTable();
		/* @var $closingday TableClosingday */
		$data['text'] = JRequest::getVar('text', '', 'default', 'string', JREQUEST_ALLOWHTML);
		$closingday->bind($data);
		$closingday->store();
		
		$items = JRequest::getVar('item', array(), 'default', 'array');
		
		$this->_db->setQuery('DELETE FROM #__booking_closingday_subject where closingday_id = ' . $closingday->id);
		$this->_db->query();
		
		foreach ($items as $item) {
			$this->_db->setQuery("INSERT INTO #__booking_closingday_subject (closingday_id, subject_id) VALUES({$closingday->id}, {$item})");
			$this->_db->query();
		}
		
		return $closingday->id;
	}
	
	public function delete()
	{
		$cid = JRequest::getVar('cid', array(), 'default', 'array');
		$query = 'DELETE d, s 
				FROM #__booking_closingday AS d 
				LEFT JOIN #__booking_closingday_subject AS s ON s.closingday_id = d.id
				WHERE d.id IN (' . implode(', ', $cid) . ')';
		$this->_db->setQuery($query);
		return $this->_db->query();
	}
	
	public function getAffectedSubjects()
	{
		$this->_db->setQuery('SELECT subject_id 
				FROM #__booking_closingday_subject
				WHERE closingday_id = ' . $this->getItem()->id);
		$affected = $this->_db->loadResultArray();
		
		$model = JModel::getInstance('Subjects', 'BookingModel');
		/* @var $model BookingModelSubjects */
		$subjects = $model->getData();
		
		foreach ($subjects as $i => $subject)
			$subject->affected = in_array($subject->id, $affected);
		
		$subjects = array_merge($subjects);
		
		return $subjects;
	}
}