<?php

/**
 * Rezervations list model. Support for loading database data with apply filter.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  models 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

//import needed JoomLIB helpers
AImporter::helper('request', 'model');

class BookingModelReservations extends AModel
{
    /**
     * Main table
     * 
     * @var TableReservation
     */
    var $_table;

    function __construct()
    {
        parent::__construct();
        $this->_table = $this->getTable('reservation');
    }

    /**
     * Get MySQL loading query for rezervations list
     * 
     * @return string complet MySQL query
     */
    function buildQuery()
    {
        static $query;
        if (is_null($query)) {
            $subjectTable = &$this->getTable('subject');
            /* @var $subjectTable TableSubject */
            $customerTable = &$this->getTable('customer');
            /* @var $customerTable TableCustomer */
            $supplementTable = &$this->getTable('reservationsupplement');
            /* @var $supplementTable TableReservationSupplement */
            $itemsTable = &$this->getTable('reservationitems');
            /* @var $itemsTable TableReservationitems */
            $query = 'SELECT `reservation`.*, ';
            $query .= '`editorUser`.`name` as `editor`, `customer`.`checked_out` AS `customerCheckedOut`,';
            $query .= 'SUM(`items`.`fullPriceSupplements`) AS `reservationFullPrice`, ';
            $query .= 'SUM(`items`.`fullDeposit`) AS `reservationFullDeposit`, ';
            $query .= 'SUM(`items`.`capacity`) AS `fullCapacity`, ';
            $query .= '`creator`.`name` AS `creator`, `modifier`.`name` AS `modifier` ';
            $query .= 'FROM `' . $this->_table->getTableName() . '` AS `reservation` ';
            $query .= 'LEFT JOIN `#__users` AS `editorUser` ON `editorUser`.`id` = `reservation`.`checked_out` ';
            $query .= 'LEFT JOIN `' . $customerTable->getTableName() . '` AS `customer` ON `customer`.`id` = `reservation`.`customer` ';
            $query .= 'LEFT JOIN `' . $itemsTable->getTableName() . '` AS `items` ON `items`.`reservation_id` = `reservation`.`id` ';
            $query .= 'LEFT JOIN `' . $subjectTable->getTableName() . '` AS `subjects` ON `items`.`subject` = `subjects`.`id` ';
            $query .= 'LEFT JOIN `#__users` AS `creator` ON `reservation`.`created_by` = `creator`.`id` ';
            $query .= 'LEFT JOIN `#__users` AS `modifier` ON `reservation`.`modified_by` = `modifier`.`id` ';
            /* note: if you join supplements, SUMs are computed wrongly because thay are multiplied by supplements count
             * $query .= 'LEFT JOIN `' . $supplementTable->getTableName() . '` AS `supplement` ON `supplement`.`reservation` = `items`.`id` '; */ 
            $query .= $this->buildContentWhere();
            $query .= ' GROUP BY `reservation`.`id` ';
            $query .= $this->buildContentOrderBy();
        }
        return $query;
    }

    /**
     * Add subject title and alias translate by JoomFISH component. Array given as function parameter
     * must contain objects with variables 'subject' (subject ID) and 'subjectTitle' to add translate title
     * and 'subjectAlias' to add translate alias. 
     * 
     * @param array $items array of stdClasses with variables: subject, subjectTitle and subjectAlias
     */
    function addTitleTranslation(&$items)
    {
        $countItems = count($items);
        if ($countItems) {
            $subjectTable = &$this->getTable('subject');
            $subjectIDs = array();
            foreach ($items as $item) {
                $subjectIDs[] = $item->subject;
            }
            $subjectIDs = array_unique($subjectIDs);
            $query = 'SELECT `id`, `title`, `alias` FROM ' . $subjectTable->getTableName() . ' WHERE `id` IN (' . implode(',', $subjectIDs) . ')';
            $this->_db->setQuery($query);
            $rows = $this->_db->loadAssocList('id');
            foreach ($items as &$item) {
                if (isset($rows[$item->subject])) {
                    $row = &$rows[$item->subject];
                    $item->subjectTitle = $row['title'];
                    $item->subjectAlias = $row['alias'];
                }
            }
        }
    }

    /**
     * Get MySQL filter criteria for rezervations list
     * 
     * @return string filter criteria in MySQL format
     */
    function buildContentWhere()
    {
        $where = array();
        $this->addStringProperty($where, 'reservation-surname', 'items-subject_title');
        $this->addIntProperty($where, 'reservation-id');
        $this->addIntProperty($where, 'customer-id');
        $this->addTimeLimit($where, 'from', 'to');
        
        if (isset($this->_lists['reservation_status']) && $this->_lists['reservation_status'] !== '')
        	$where[] = 'reservation.state = ' . $this->_lists['reservation_status'];
        if (isset($this->_lists['payment_status']) && $this->_lists['payment_status'] !== '')
        	$where[] = 'reservation.paid = ' . $this->_lists['payment_status'];                        
        
        return $this->getWhere($where);
    }
}

?>