<?php
/**
 * View component configuration 
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.tooltip');
JHTML::_('behavior.modal');
JHTML::_('behavior.mootools');
bookingHelper::upgradeModal(); //we need better modal to open queezebox from hidden div

/* @var $this BookingViewConfig */
JToolBarHelper::title(JText::_(COMPONENT_NAME).": ".JText::_('Configuration'), 'configuration');

JToolBarHelper::save();
JToolBarHelper::apply();
JToolBarHelper::cancel();

BookingHelper::setSubmenu(4);

$tabsParams['startOffset'] = isset($_COOKIE['startOffset']) ? $_COOKIE['startOffset'] : 0;
$pane = &JPane::getInstance('tabs', $tabsParams, true);

ADocument::addDomreadyEvent('ViewConfig.setEvents(true);');
?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<div class="width-100">
		<fieldset class="adminlist">
			<legend><?php echo JText::_('Component settings'); ?></legend>		
			<?php 
				$groups = &$this->params->getGroups();
				echo $pane->startPane('tabone');
				foreach ($groups as $name=>$count) {
					echo $pane->startPanel(JText::_($name), JFilterOutput::stringURLSafe($name));
			?>
				<div class="ieHelper">&nbsp;</div>
				<table class="admintable">
			<?php
					//echo $this->params->render('params', $name);
					foreach ($this->params->renderToArray('params', $name) as $param) {
			?>
		        		<tr><td class="key"><?php echo $param[0]; ?></td><td><?php echo $param[1]; ?></td></tr>
		  	<?php 
			        }
					echo $pane->endPanel();
			?>
				</table>
			<?php	
				}
				echo $pane->endPane();
			?>
			<div class="clr"></div>
		</fieldset>
	</div>
	
	<script type="text/javascript">
		function display_formats()
		{
			SqueezeBox.initialize();
			SqueezeBox.open($('supported_time_formats'),{handler: 'adopt'});
		}
	</script>
	
	<div style="display:none">
		<div id="supported_time_formats">
			<![CDATA[
				<?php echo AHTML::getSupportedTimeFormats(); ?>
			]]>
		</div>
	</div>
	
	<input type="hidden" name="option" value="<?php echo OPTION; ?>" />
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_CONFIG; ?>" />
	<input type="hidden" name="task" value="" />
	<?php echo JHTML::_('form.token'); ?>
</form>