<?php

/**
 * Subject-prices edit form template
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubject */

$config = &AFactory::getConfig();
/* @var $config BookingConfig */

$rtypes = $this->rtypes;
unset($rtypes[0]);

$checkThisDayInAllPrices = $this->escape(JText::_('Check this day in all prices'));
$checkAllDaysInThisPrice = $this->escape(JText::_('Check all days in this price'));
$checkAllDaysInAllPrices = $this->escape(JText::_('Check all days in all prices'));

$weeks[] = JHtml::_('select.option', WEEK_EVERY, JText::_('Every weeks'));
$weeks[] = JHtml::_('select.option', WEEK_EVEN, JText::_('Only even weeks'));
$weeks[] = JHtml::_('select.option', WEEK_ODD, JText::_('Only odd weeks'));

$canceltimesettings[] = JHtml::_('select.option', CANCEL_NONE, JText::_('Disabled'));
$canceltimesettings[] = JHtml::_('select.option', CANCEL_IMMEDIATELY, JText::_('Online Payment Only'));
$canceltimesettings[] = JHtml::_('select.option', CANCEL_AFTER, JText::_('After Reservation'));
$canceltimesettings[] = JHtml::_('select.option', CANCEL_BEFORE, JText::_('Before Booking'));

$canceltime[] = JHtml::_('select.option', EXPIRE_FORMAT_HOUR, JText::_('Hours'));
$canceltime[] = JHtml::_('select.option', EXPIRE_FORMAT_DAY, JText::_('Days'));

$customcolor[] = JHtml::_('select.option', '');
$customcolor[] = JHtml::_('select.option', 'red', JText::_('Red'));
$customcolor[] = JHtml::_('select.option', 'green', JText::_('Green'));
$customcolor[] = JHtml::_('select.option', 'blue', JText::_('Blue'));
$customcolor[] = JHtml::_('select.option', 'grey', JText::_('Grey'));

?>	
<div class="width-100" id="prices">
	<input type="hidden" name="<?php echo PRICES_PREFIX . 'date_up[]'; ?>" value="" />
	<input type="hidden" name="<?php echo PRICES_PREFIX . 'date_down[]'; ?>" value="" />
	<input type="hidden" name="<?php echo PRICES_PREFIX . 'time_up[]'; ?>" value="" />
	<input type="hidden" name="<?php echo PRICES_PREFIX . 'time_down[]'; ?>" value="" />
	<fieldset class="adminform">
    	<legend class="hasTip" title="<?php echo $this->escape(JText::_('Prices')) . '::' . $this->escape(JText::_('Prices top info')); ?>">
    		<?php echo JText::_('Prices'); ?>
    	</legend>
    	<?php if (count($this->rtypes) > 1) { ?>
	    	<div>
	    		<?php
	    			$bar = &JToolBar::getInstance('prices');
        			$bar->appendButton('ALink', 'new', 'Add', 'EditSubject.addPrice()');
        			$bar->appendButton('ALink', 'delete', 'Delete', 'EditSubject.removePrices()');
        			echo $bar->render();
	    		?>
				
				<div class="clr"></div>
    			<table class="template">
					<tr>
						<td colspan="2">
    						<input type="checkbox" class="inputCheckbox" name="book_over_timeliness" id="book_over_timeliness" value="1" <?php if ($this->subject->book_over_timeliness == 1) { ?>checked="checked"<?php } ?> />
    						<label class="hasTip" for="book_over_timeliness" title="<?php echo $this->escape(($title = JText::_('Book over timeliness'))) . '::' . $this->escape(JText::_('Book over timeliness info')); ?>"><?php echo $title; ?></label>
    					</td>
    					<td rowspan="3">
    						<h3 class="hasTip" title="<?php echo $this->escape(($title = JText::_('Single time discounts'))) . '::' . $this->escape(JText::_('Single time discounts info')); ?>"><?php echo JText::_('Single time discounts'); ?></h3>
    						<table style="width: 100%">
    							<tr>
    								<td width="50%">
    									<label class="hasTip" for="single_deposit" title="<?php echo JText::_('Unit counts'); ?>::<?php echo JText::_('Time unit counts info'); ?>"><?php echo JText::_('Unit counts'); ?></label>
    									<br/>
    									<textarea class="price" rows="1" cols="1" id="single_discount_unit" name="single_discount_unit"><?php echo $this->subject->single_discount_unit; ?></textarea>
    								</td>
    								<td width="50%">
    									<label class="hasTip" for="single_deposit"  title="<?php echo JText::_('Unit discount'); ?>::<?php echo JText::_('Time unit discount info'); ?>"><?php echo JText::_('Unit discount'); ?></label>
    									<br/>
    									<textarea class="price" rows="1" cols="1" id="single_discount" name="single_discount"><?php echo $this->subject->single_discount; ?></textarea>
    								</td>
    							</tr>
    						</table>
    					</td>
    				</tr>
    				<tr>
    					<td>
    						<label class="hasTip" for="single_deposit" title="<?php echo $this->escape(($title = JText::_('Single deposit'))) . '::' . $this->escape(JText::_('Single deposit info')); ?>"><?php echo $title; ?></label>
    					</td>
    					<td>
    						<input class="number" type="text" name="single_deposit" id="single_deposit" value="<?php echo $this->escape($this->subject->single_deposit); ?>" onkeyup="ACommon.toFloat(this)" />
    					</td>
    				</tr>
    				<tr>
    					<td>
    						<label class="hasTip" for="tax" title="<?php echo $this->escape(($title = JText::_('Tax Rate'))) . '::' . $this->escape(JText::_('Tax info')); ?>"><?php echo $title; ?></label>
    					</td>
    					<td>
    						<?php
    							$options = array(JHtml::_('select.option', '-1', JText::_('No Tax'))); 
    							foreach ($config->taxRates as $id => $taxrate)
									$options[] = JHtml::_('select.option', $id, $taxrate[0]);
    							echo JHtml::_('select.genericlist', $options, 'tax_rate_id', '', 'value', 'text', $this->subject->tax_rate_id);
    						?>
    					</td>
    				</tr>
    			</table>
    			<div class="clr"></div>
				<table class="template">
					<thead>
						<tr>
							<th rowspan="2" valign="top">&nbsp;</th>
							<th rowspan="2" valign="top" width="20"><h3><?php echo JText::_('ID'); ?></h3></th>
							<th rowspan="2" valign="top" width="50"><h3><?php echo JText::_('Value'); ?><span class="star"> *</span></h3></th>
							<th rowspan="2" valign="top" class="hasTip" width="50" title="<?php echo JText::_('Multiply Capacity'); ?>::<?php echo JText::_('Price Multiply Capacity info'); ?>"><h3><?php echo JText::_('Multiply Capacity'); ?></h3></th>
							<th colspan="4" align="center" valign="top"><h3><?php echo JText::_('Deposit'); ?></h3></th>
							<th colspan="2" align="center" valign="top" class="hasTip" title="<?php echo JText::_('Time Discounts'); ?>::<?php echo JText::_('Time Discounts info'); ?>"><h3><?php echo JText::_('Time Discounts'); ?></h3></th>
							<th rowspan="2" valign="top"><h3><?php echo JText::_('Reservation Type'); ?><span class="star"> *</span></h3></th>
							<th colspan="2" align="center" valign="top"><h3><?php echo JText::_('Date Range'); ?></h3></th>
							<th colspan="2" align="center" valign="top"><h3><?php echo JText::_('Time range only for hourly type'); ?></h3></th>
							<th colspan="8" align="center" valign="top"><h3><?php echo JText::_('Days Availability'); ?></h3></th>
						</tr>
						<tr>
							<th rowspan="2" valign="top" class="hasTip" title="<?php echo JText::_('Value'); ?>::<?php echo JText::_('Value'); ?>"><h3><?php echo JText::_('Value'); ?></h3></th>
							<th rowspan="2" valign="top" class="hasTip" title="<?php echo JText::_('Reservation Expiration'); ?>::<?php echo JText::_('Reservation Expiration info'); ?>"><h3><?php echo JText::_('Reservation Expiration'); ?></h3></th>
							<th rowspan="2" valign="top" class="hasTip" width="50" title="<?php echo JText::_('Deposit Multiply'); ?>::<?php echo JText::_('Deposit Multiply info'); ?>"><h3><?php echo JText::_('Deposit Multiply'); ?></h3></th>
							<th rowspan="2" valign="top" class="hasTip" width="50" title="<?php echo JText::_('Multiply Capacity'); ?>::<?php echo JText::_('Deposit Multiply Capacity info'); ?>"><h3><?php echo JText::_('Multiply Capacity'); ?></h3></th>
							
							<th valign="top" class="hasTip" title="<?php echo JText::_('Unit Counts Booked'); ?>::<?php echo JText::_('Time Unit Counts info'); ?>"><h3><?php echo JText::_('Unit Counts Booked'); ?></h3></th>
							<th valign="top" class="hasTip" title="<?php echo JText::_('Unit Discount'); ?>::<?php echo JText::_('Time Unit Discount info'); ?>"><h3><?php echo JText::_('Unit Discount'); ?></h3></th>
							<th valign="top"><h3><?php echo JText::_('From'); ?><span class="star"> *</span></h3></th>
							<th valign="top"><h3><?php echo JText::_('To'); ?><span class="star"> *</span></h3></th>
							<th valign="top"><h3><?php echo JText::_('From'); ?><span class="star"> *</span></h3></th>
							<th valign="top"><h3><?php echo JText::_('To'); ?><span class="star"> *</span></h3></th>
							<th valign="top" align="center"><h3><?php echo JText::_('Mon'); ?></h3><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceColDays(this,1)" title="<?php echo $checkThisDayInAllPrices; ?>" class="checkall"></a></th>
							<th valign="top" align="center"><h3><?php echo JText::_('Tue'); ?></h3><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceColDays(this,2)" title="<?php echo $checkThisDayInAllPrices; ?>" class="checkall"></a></th>
							<th valign="top" align="center"><h3><?php echo JText::_('Wed'); ?></h3><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceColDays(this,3)" title="<?php echo $checkThisDayInAllPrices; ?>" class="checkall"></a></th>
							<th valign="top" align="center"><h3><?php echo JText::_('Thu'); ?></h3><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceColDays(this,4)" title="<?php echo $checkThisDayInAllPrices; ?>" class="checkall"></a></th>
							<th valign="top" align="center"><h3><?php echo JText::_('Fri'); ?></h3><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceColDays(this,5)" title="<?php echo $checkThisDayInAllPrices; ?>" class="checkall"></a></th>
							<th valign="top" align="center"><h3><?php echo JText::_('Sat'); ?></h3><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceColDays(this,6)" title="<?php echo $checkThisDayInAllPrices; ?>" class="checkall"></a></th>
							<th valign="top" align="center"><h3><?php echo JText::_('Sun'); ?></h3><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceColDays(this,7)" title="<?php echo $checkThisDayInAllPrices; ?>" class="checkall"></a></th>
							<th valign="bottom" align="center"><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceAllDays(this)" title="<?php echo $checkAllDaysInAllPrices; ?>" class="checkall"></a></th>
							<th valign="top" class="hasTip" align="center" title="<?php echo JText::_('Color of price field in calendar'); ?>"><h3><?php echo JText::_('Color In Calendar'); ?></h3></th>
						</tr>
					</thead>
					<tbody id="tprices">
						<?php 
							$pcount = count($this->prices);					
							for ($i = 0; $i < $pcount; $i++) {
								$price = &$this->prices[$i];
								TablePrice::display($price);
								/* @var $price TablePrice */
								JFilterOutput::objectHTMLSafe($price);
								$id = $i ? $price->id : '';
							?>
							<tr <?php if (! $id) { ?>id="price" style="display: none"<?php } ?>>
								<td class="check">
									<input type="checkbox" class="inputCheckbox" name="pcid[]" value="1"/>
								</td>
								<td class="id">
									<?php echo $price->id ? $price->id : '<i>' . JText::_('New') . '</i>'; ?>
								</td>
								<td>
									<input type="text" name="<?php echo PRICES_PREFIX; ?>value[<?php echo $id; ?>]" value="<?php echo $price->value; ?>" class="number" onkeyup="ACommon.toFloat(this)" />
									<br />
									<?php echo $config->mainCurrency;?>
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>price_capacity_multiply[<?php echo $id; ?>]" value="<?php echo $price->price_capacity_multiply; ?>" />
									<input type="checkbox" class="inputCheckbox" id="<?php echo 'price_capacity_multiply' . $id; ?>" name="another_fake[]" <?php if ($price->price_capacity_multiply) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" /> 			
								</td>
								<td>
									<input type="text" name="<?php echo PRICES_PREFIX; ?>deposit[<?php echo $id; ?>]" value="<?php echo $price->deposit; ?>" class="number" onkeyup="ACommon.toFloat(this)" />
									<br />
									<?php echo $config->mainCurrency;?>
								</td>
								<td>
									<?php echo JHTML::_('select.genericlist', $canceltimesettings, PRICES_PREFIX . 'expiration_setting[' . $id . ']', 'onchange="EditSubject.setPaymentExpirationType(this)"', 'value', 'text', BookingHelper::typeOfCancelTime($price->cancel_time)); ?>
									<br />
									<input type="text" name="<?php echo PRICES_PREFIX; ?>cancel_time[<?php echo $id; ?>]" value="<?php echo BookingHelper::formatFromCancelTime($price->cancel_time); ?>" class="number" onkeyup="ACommon.toFloat(this)"/>
									<?php echo JHTML::_('select.genericlist', $canceltime, PRICES_PREFIX . 'expiration_format[' . $id . ']', '', 'value', 'text', BookingHelper::formatOfCancelTime($price->cancel_time)); ?>
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>deposit_multiply[<?php echo $id; ?>]" value="<?php echo $price->deposit_multiply; ?>" />
									<input type="checkbox" class="inputCheckbox" name="another_fake[]" <?php if ($price->deposit_multiply) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>deposit_capacity_multiply[<?php echo $id; ?>]" value="<?php echo $price->deposit_capacity_multiply; ?>" />
									<input type="checkbox" class="inputCheckbox" id="<?php echo 'deposit_capacity_multiply' . $id; ?>" name="another_fake[]" <?php if ($price->deposit_capacity_multiply) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" /> 			
								</td>
								<td>
									<textarea class="price" rows="1" cols="1" name="<?php echo PRICES_PREFIX; ?>unit_count[<?php echo $id; ?>]"><?php echo $price->unit_count; ?></textarea>
								</td>
								<td>
									<textarea class="price" rows="1" cols="1" name="<?php echo PRICES_PREFIX; ?>unit_discount[<?php echo $id; ?>]"><?php echo $price->unit_discount; ?></textarea>
								</td>
								<td class="select">
									<?php echo AHtml::getFilterSelect(PRICES_PREFIX . 'rezervation_type[' . $id . ']', 'select', $rtypes, $price->rezervation_type, false, 'onchange="EditSubject.setPriceReservationType(this)"', 'id', 'fullTitle'); ?>
									<label><?php echo JText::_('Week Availability'); ?></label>
									<?php echo JHTML::_('select.genericlist', $weeks, PRICES_PREFIX . 'week[' . $id . ']', '', 'value', 'text', $price->week); ?>
								</td>	
								<td class="date">
									<?php 
										if ($i) {
											echo AHtml::getCalendar($price->date_up, PRICES_PREFIX . 'date_up[' . $id . ']', 'priceDateUp' . $price->id, ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL, '', false);
										} 
									?>
								</td>
								<td class="date">
									<?php 
										if ($i) {
											echo AHtml::getCalendar($price->date_down, PRICES_PREFIX . 'date_down[' . $id . ']', 'priceDateDown' . $price->id, ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL, '', false);
										}
									?>
								</td>
								<td class="time">
									<?php 
										if ($i) {
											echo AHtml::getTimePicker($price->time_up, PRICES_PREFIX . 'time_up[' . $id . ']', true, '', true);
										}
									?>
								</td>							
								<td class="time">
									<?php 
										if ($i) {
											echo AHtml::getTimePicker($price->time_down, PRICES_PREFIX . 'time_down[' . $id . ']', true, '', true);
										} 
									?>
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>monday[<?php echo $id; ?>]" value="<?php echo $price->monday; ?>" />
									<input type="checkbox" class="inputCheckbox" name="fake[]" <?php if ($price->monday) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>tuesday[<?php echo $id; ?>]" value="<?php echo $price->tuesday; ?>" />
									<input type="checkbox" class="inputCheckbox" name="fake[]" <?php if ($price->tuesday) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>wednesday[<?php echo $id; ?>]" value="<?php echo $price->wednesday; ?>" />
									<input type="checkbox" class="inputCheckbox" name="fake[]" <?php if ($price->wednesday) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>thursday[<?php echo $id; ?>]" value="<?php echo $price->thursday; ?>" />
									<input type="checkbox" class="inputCheckbox" name="fake[]" <?php if ($price->thursday) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>friday[<?php echo $id; ?>]" value="<?php echo $price->friday; ?>" />
									<input type="checkbox" class="inputCheckbox" name="fake[]" <?php if ($price->friday) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>saturday[<?php echo $id; ?>]" value="<?php echo $price->saturday; ?>" />
									<input type="checkbox" class="inputCheckbox" name="fake[]" <?php if ($price->saturday) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
								</td>
								<td>
									<input type="hidden" name="<?php echo PRICES_PREFIX; ?>sunday[<?php echo $id; ?>]" value="<?php echo $price->sunday; ?>" />
									<input type="checkbox" class="inputCheckbox" name="fake[]" <?php if ($price->sunday) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
								</td>		
								<td><a href="javascript:void(0)" onclick="javascript:EditSubject.checkPriceRowDays(this)" title="<?php echo $checkAllDaysInThisPrice; ?>" class="checkall"></a></td>
								<td>
									<?php echo JHTML::_('select.genericlist', $customcolor, PRICES_PREFIX . 'predefined_color[' . $id . ']', 'onchange=""', 'value', 'text'); ?>
									<br />
									<input type="text" name="<?php echo PRICES_PREFIX; ?>custom_color[<?php echo $id; ?>]" value="<?php echo $price->custom_color; ?>" />
								</td>					
							</tr>
						<?php } ?>
						<tr id="price-empty" <?php if ($pcount > 1) { ?>style="display: none;"<?php } ?>><td colspan="16" class="emptyList"><?php echo JText::_('Empty prices list'); ?></td></tr>
					</tbody>
				</table>
				<div class="clr"></div>
			</div>
		<?php } else { ?>
			<p class="emptyParentList"><?php echo JText::_('Add reservation types and apply.'); ?></p>
		<?php } ?>
    </fieldset>
</div>

<script>
window.addEvent('domready', function(){ //make sure dom elements are loaded first
    $$('select[name^=price-expiration_setting]').each(function(item){EditSubject.setPaymentExpirationType(item);});
});
</script>