<?php

/**
 * Daily calendar template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

$config = AFactory::getConfig();

$this->days = &BookingHelper::getDailyCalendar($this->subject, ($this->setting = new BookingCalendarSetting()), $this->isAdmin);

//$userCanReserve = $this->customer->id || $config->unRegisteregCanReserve;
$userCanReserve = $this->userCanReserve;

$noAvailableReservations = JText::_('No available reservations');
/* @var $noAvailableReservations string save translation in property for optimizing */
$bookFullDay = JText::_('Book full day');
/* @var $bookFullDay string save translation in property for optimizing */

//load csss colors for prices
//-----------------------
$colors = array();
foreach($this->days->prices as $prices)
{
	foreach($prices->prices as $price)
	{
		$colors[] = $price->custom_color;
	}
}
$string = '';
foreach($colors as $i=>$color)
{
	$string .= "#bookSetting .price".$i." {	background-color: ".$color.";} ";
}
JFactory::getDocument()->addStyleDeclaration( $string );
//-------------------------

?>
<div>
<?php 
	if (($countDays = count($this->days))) {
		/* @var $countDays int count of days in request interval */ 
?>
 	<div class="dailyCalendar">
  		<?php 
  			$firstDay = &reset($this->days->calendar);
  			
  			echo $this->loadTemplate('bookitform');
  		?>
  			<div class="clr"></div>
  		<?php
  			echo $this->loadTemplate('prices');
  			
      		if ($config->quickNavigator) {
    	?>
  				<div class="clr"></div>
  				<div class="quickNavigator">
  					<?php 
  						$mainframe = JFactory::getApplication();
  						/* @var $mainframe JApplication */
  						$current = JFactory::getDate();
  						/* @var $current JDate */
  						$futured = JFactory::getDate('+ ' . $config->calendarDeepDay . ' days');
  						/* @var $futured JDate */
  						if ($this->isAdmin) // admin can browse everything
 							ADocument::addDomreadyEvent('Calendars.dateBegin = "0";' . PHP_EOL . 'Calendars.dateEnd = "0";');
  						else // customer can browse present and future only
  							ADocument::addDomreadyEvent('Calendars.dateBegin = ' . $current->toFormat('%Y%m%d') . ';' . PHP_EOL . 'Calendars.dateEnd = ' . $futured->toFormat('%Y%m%d') . ';');
  						echo AHtml::getCustomCalendar($this->setting->requestDate, 'iday', 'iday', ADATE_FORMAT_MYSQL_DATE_CAL);
  					?>
  				</div>
  		<?php 
  			} 
  			foreach ($this->days->calendar as $day) {
  				/* @var $day BookingDay */	
  					
	  			$pricesPositions = array();
	  			$bi = 0;
	  			$bc = count($day->boxes);
				foreach ($day->boxes as $bkey => $box) {
					$bi ++;
					/* @var $box BookingTimeBox */
					$pricePosition = 0;
					foreach ($box->services as $skey => $service)
						/* @var $service BookingService */
						if (($service->canReserve = !(!in_array($service->rtypeId, $this->lists['rids']) || (!$service->canReserve)))) {
							if (! isset($pricesPositions[$service->priceIndex]) || $pricesPositions[$service->priceIndex] < $pricePosition)
								$pricesPositions[$service->priceIndex] = $pricePosition;
							$pricePosition++;	
							if ($service->rtype == RESERVATION_TYPE_DAILY)
								$box->haveDailyService = true;
						}
				}
		?>
			
				<div class="boxesDay">
  					<h2><?php echo AHtml::date($firstDay->date, ADATE_FORMAT_NICE); ?></h2>
  					<table class="boxes">
  						<tr>
							<th>
								<span class="time"><?php echo JText::_('From - to'); ?></span>
								<?php 
									if ($this->subject->display_who_reserve) { 
								?>
										<span class="customer"><?php echo JText::_('Customer'); ?></span>
								<?php 
									} 
								?>
							</th>
						</tr>
		<?php
  						foreach ($day->boxes as $box) {
  							/* @var $box BookingTimeBox */
							$usedBoxes = 0;
							if ($box->rtype == RESERVATION_TYPE_DAILY && !$box->haveDailyService)
								continue;
							
							$closedClassName = $box->closed ? ' closed hasTip' : '';
							$title = $box->closed ? $this->escape($box->closingDayTitle).'::'.$this->escape($box->closignDayText) : '';
							
		?>
							<tr>	
							<td class="box<?php echo $closedClassName; ?><?php if ($box->engaged) { ?> reserved<?php if($config->colorCalendarFieldReserved){ echo '"style="background-color:'.$config->colorCalendarFieldReserved; }}else if($config->colorCalendarFieldFree){ echo '" style="background-color:'.$config->colorCalendarFieldFree; } ?>" title="<?php echo $title; ?>">
								<span class="time"><?php echo $box->rtype == RESERVATION_TYPE_DAILY ? $bookFullDay : (BookingHelper::displayTime($box->fromTime) . ' - ' . BookingHelper::displayTime($box->toTime)); ?></span>
								<?php						
									foreach ($box->services as $i => $service) {
										if ($service->canReserve && !$box->closed) {
											/* @var $service BookingService */
											$emptyPricesCount = $pricesPositions[$service->priceIndex] - $usedBoxes;
											for ($i = 0; $i < $emptyPricesCount; $i++) {
								?>
												<span class="price"></span>
								<?php
											} 
											$usedBoxes += $emptyPricesCount + 1;
								?>
											<span class="price price<?php echo $service->priceIndex; ?>" id="<?php echo $service->idShort; ?>">
								<?php
												if ($userCanReserve)
													ADocument::setBoxParams($service, $service->i, $bc, $bi);
												if ($this->subject->display_capacity && $this->subject->total_capacity>1)
													echo ($this->subject->total_capacity - $service->alreadyReserved);
								?>
											</span>
								<?php
										} else {
								?>												
											<span class="price"></span>
								<?php		
										}
									} 
									if (!$box->closed) {
										if ($this->subject->display_who_reserve && isset($box->customerName) && count($box->customerName)) {
											if(strip_tags(json_encode($box->customerName)) != json_encode($box->customerName)){
								?>
												<span class="customer" <?php if($config->colorCalendarBoxReserved){ echo 'style="background-color:'.$config->colorCalendarBoxReserved.'"'; }?>><?php echo AHtml::showUserInfo($box->customerName); ?></span>
								<?php
										 } else { 
								?>
												<span class="price hasTip customer" title="<?php echo AHtml::showUserInfo($box->customerName); ?>" <?php if($config->colorCalendarBoxReserved){ echo 'style="background-color:'.$config->colorCalendarBoxReserved.'"'; }?>> </span>
								<?php
		        							}
										}
									}
								?>
							</td>
						</tr>
					<?php 
  					}
  				}	
  			?>
  			</table>
  		</div>
  		<div class="clr"></div>
	</div>
</div>
	<div class="calendarPagination">
		<?php if (! $this->setting->onCurrentDay) { ?>
			<span class="previousPage">
				<a href="javascript:Calendars.dayNavigation(<?php echo $this->setting->previousDay; ?>,<?php echo $this->setting->previousMonth; ?>,<?php echo $this->setting->previousYear; ?>)"><?php echo JText::_('Previous day'); ?></a>
			</span>
		<?php } ?>
		<span class="currentPage">
			<a href="javascript:Calendars.dayNavigation(<?php echo $this->setting->currentDay; ?>,<?php echo $this->setting->currentMonth; ?>,<?php echo $this->setting->currentYear; ?>)"><?php echo JText::_('Current day'); ?></a>
		</span>
		<?php if(! $this->setting->lastAllowPage) { ?>
			<span class="nextPage">
				<a href="javascript:Calendars.dayNavigation(<?php echo $this->setting->nextDay; ?>,<?php echo $this->setting->nextMonth; ?>,<?php echo $this->setting->nextYear; ?>)"><?php echo JText::_('Next day'); ?></a>
			</span>
		<?php } ?>
	</div>
<?php } else { ?>
	<p><?php echo $noAvailableReservations; ?></p>
<?php } ?>