<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	controllers
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

class BookingControllerLocation extends JController
{
	
	public function add()
	{
		JRequest::setVar('view', 'location');
		JRequest::setVar('layout', 'form');
		parent::display();
	}
	
	public function edit()
	{
		JRequest::setVar('view', 'location');
		JRequest::setVar('layout', 'form');
		parent::display();
	}
	
	public function apply()
	{
		$id = $this->getModel('location')->save();
		$this->setRedirect('index.php?option=com_booking&controller=location&task=edit&id=' . $id, JText::_('Item Saved'));
	}
	
	public function save()
	{
		$this->getModel('location')->save();
		$this->setRedirect('index.php?option=com_booking&view=locations', JText::_('Item Saved'));
	}
	
	public function cancel()
	{
		$this->setRedirect('index.php?option=com_booking&view=locations');
	}
	
	public function remove()
	{
		$this->getModel('location')->delete();
		$this->setRedirect('index.php?option=com_booking&view=locations');
	}
	
	public function pick_up_publish() {
		$this->getModel('location')->pick_up_publish();
		$this->setRedirect('index.php?option=com_booking&view=locations');
	}
	
	public function pick_up_unpublish() {
		$this->getModel('location')->pick_up_unpublish();
		$this->setRedirect('index.php?option=com_booking&view=locations');
	}
	
	public function drop_off_publish() {
		$this->getModel('location')->drop_off_publish();
		$this->setRedirect('index.php?option=com_booking&view=locations');
	}
	
	public function drop_off_unpublish() {
		$this->setRedirect('index.php?option=com_booking&view=locations');
	}
}