/**
 * Extended search module.
 * 
 * @package ARTIO Booking
 * @subpackage modules
 * @copyright Copyright (C) 2012 ARTIO s.r.o.. All rights reserved.
 * @author ARTIO s.r.o., http://www.artio.net
 * @link http://www.artio.net Official website
 */

window.addEvent('domready', function() {
	// button submit search form
	$('bookingSearchSubmit').addEvent('click', function() {
		if ($('bookingSearchDateFrom').value != '' && $('bookingSearchDateTo').value != '' && $('bookingSearchDateTo').value < $('bookingSearchDateFrom').value)
			return alert(LGInvalidDateRange);
		$('bookingSearch').submit();
	});
	// button reset search form
	if ($('bookingSearchReset')) {
		$('bookingSearchReset').addEvent('click', function() {
			$('bookingSearchDateFrom_da').innerHTML = '';
			$('bookingSearchDateFrom').value = '';
			$('bookingSearchDateTo_da').innerHTML = '';
			$('bookingSearchDateTo').value = '';
			$('bookingSearchPriceFrom').value = '';
			$('bookingSearchPriceTo').value = '';
			$('bookingSearchCapacity').value = '';
			$('template_area').value = 0;
			$('bookingSearchTogler').value = 0;
			$('bookingSearch').submit();
		});
	}
	if ($('bookingSearchCapacity')) {
		$('bookingSearchCapacity').addEvent('keyup', function() {
			ACommon.toInt(this); // allow only integer as capacity
		});
		$('bookingSearchCapacity').addEvent('change', function() {
			$('bookingSearch').submit();
		});
	}
	if ($('bookingSearchPriceFrom')) {
		$('bookingSearchPriceFrom').addEvent('keyup', function() {
			ACommon.toFloat(this); // allow only float as date range from
		});
		$('bookingSearchPriceFrom').addEvent('change', function() {
			$('bookingSearch').submit();
		});
	}
	if ($('bookingSearchPriceTo')) {
		$('bookingSearchPriceTo').addEvent('keyup', function() {
			ACommon.toFloat(this); // allow only float as date range to
		});
		$('bookingSearchPriceTo').addEvent('change', function() {
			$('bookingSearch').submit();
		});
	}
	if ($('template_area')) {
		$('template_area').addEvent('change', function() {
			$('bookingSearch').submit();
		});
	}
	if ($('bookingSearchLogin')){
		$('bookingSearchLogin').addEvent('click', function() {
			window.location = $('bookingSearchLogin').getAttribute('rel');
		});
	}
});