<?php

/**
 * Subject available bookable supplement.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  tables 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class TableSupplement extends JTable
{
    /**
     * Primary key
     * 
     * @var int
     */
    var $id;
    /**
     * Ordering value
     * 
     * @var int
     */
    var $ordering;
    /**
     * Subject owner - ID
     * 
     * @var int
     */
    var $subject;
    /**
     * Supplement title
     * 
     * @var string
     */
    var $title;
    /**
     * Supplement description
     * 
     * @var string
     */
    var $description;
    /**
     * Supplement type. 1 selectable, 2 yes/no
     * 
     * @var int
     */
    var $type;
    /**
     * If selectable type, list of select options
     * 
     * @var string
     */
    var $options;
    /**
     * For list type use empty option (no select anything)
     * 
     * @var int 1/0 use/unuse
     */
    var $empty;
    /**
     * Supplement is paid or only to select object property.
     * 
     * @var int 1/0 paid/unpaid
     */
    var $paid;
    /**
     * Supplement unit price
     * 
     * @var string
     */
    var $price;
    /**
     * If multiply supplement capacity by reserved capacity. 0: always 1 unit, 1: multiply by reserved capacity, 2: manual select capacity
     * 
     * @var int
     */
    var $capacity_multiply;
    /**
     * Maximal supplement capacity (only applies on $capacity_multiply option 2)
     * 
     * @var int
     */
    var $capacity_max;
    /**
     * Multiply price for count of reservation's units (hours or days)
     * 
     * @var int
     */
    var $unit_multiply;
    
    /**
     * Constructor - init table name, primary key and database connector.
     * 
     * @param JDatabaseMySQL $db instance of database connector
     */
    function __construct(& $db)
    {
        parent::__construct('#__' . PREFIX . '_supplement', 'id', $db);
    }

    /**
     * Init empty object.
     */
    function init()
    {
        $this->id = 0;
        $this->subject = 0;
        $this->title = '';
        $this->description = '';
        $this->type = SUPPLEMENT_TYPE_UNSELECT;
        $this->options = '';
        $this->empty = SUPPLEMENT_TYPE_UNSELECT;
        $this->paid = SUPPLEMENT_NO_PRICE;
        $this->price = '';
        $this->capacity_multiply = 1;
        $this->capacity_max = 0;
        $this->unit_multiply = 0;
    }

    /**
     * Clean object data.
     */
    function clean()
    {
        $this->id = (int) $this->id;
        $this->subject = (int) $this->subject;
        $this->title = JString::trim($this->title);
        $this->description = JString::trim($this->description);
        $this->type = (int) $this->type;
        $this->options = JString::trim($this->options);
        $this->empty = (int) $this->empty;
        $this->paid = (int) $this->paid;
        $this->price = JString::trim($this->price);
        $this->capacity_multiply = (int) $this->capacity_multiply;
        $this->capacity_max = (int) $this->capacity_max;
        $this->unit_multiply = (int) $this->unit_multiply;
    }

    /**
     * Check before saving.
     */
    function check()
    {
        $this->clean();
        if (($result = parent::check())) {
            $result = false;
            $result = $this->title ? true : $result;
            $result = $this->type ? true : $result;
            $result = $this->price ? true : $result;
        }
        return $result;
    }

    /**
     * Prepare object data to display.
     * 
     * @param TableSupplement $object
     * @return void
     */
    function display(&$object)
    {
        $object->price = $object->paid == SUPPLEMENT_NO_PRICE ? '' : $object->price;
    }

    /**
     * @param TableSupplement $supplement
     */
    function prepare(&$supplement)
    {
        if ($supplement->type == SUPPLEMENT_TYPE_LIST) {
            $options = explode("\n", str_replace("\r\n", "\n", $supplement->options));
            if (is_array($options)) {
                foreach ($options as $i => $option)
                    if (! ($option = JString::trim($option)))
                        unset($options[$i]);
                    else
                        $options[$i] = array($option);
                if (count($options)) {
                    $options = array_merge($options);
                    if ($supplement->paid == SUPPLEMENT_MORE_PRICES) {
                        $prices = explode("\n", str_replace("\r\n", "\n", $supplement->price));
                        if (is_array($prices))
                            foreach ($prices as $i => $price)
                                if (($price = (float) $price) == 0.0)
                                    unset($prices[$i]);
                                else
                                    $prices[$i] = $price;
                        else
                            $prices = array((float) $supplement->price);
                    } elseif ($supplement->paid == SUPPLEMENT_ONE_PRICE)
                        $prices = array((float) $supplement->price);
                    else
                        $prices = array(null);
                    $prices = array_merge($prices);
                    foreach ($options as $i => $option)
                        $options[$i][] = isset($prices[$i]) ? $prices[$i] : end($prices);
                }
            } else
                $options = null;
            $supplement->options = $options;
        }        	
    }
}

?>