<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

?>

<form action="<?php echo JRoute::_('index.php?option=com_booking&view=locations'); ?>" method="post" name="adminForm" id="adminForm">
	<fieldset id="filter-bar">
			<label for="filter_search"><?php echo JText::_('Filter'); ?></label> 
			<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" />
			<button type="submit">
				<?php echo ISJ3 ? '' : JText::_('OK'); ?>
			</button>
			<button type="button" onclick="$('filter_search').value='';this.form.submit();">
				<?php echo ISJ3 ? '' : JText::_('Reset'); ?>
			</button>
			<select name="filter_pick_up" id="filter_pick_up" onchange="this.form.submit()">
				<option value="">- <?php echo JText::_('Pick Up'); ?> -</option>
				<option value="1"<?php if ($this->state->get('filter.pick_up') === '1') { ?> selected="selected"<?php } ?>><?php echo JText::_('JYES'); ?></option>
				<option value="0"<?php if ($this->state->get('filter.pick_up') === '0') { ?> selected="selected"<?php } ?>><?php echo JText::_('JNO'); ?></option>
			</select>
			<select name="filter_drop_off" id="filter_drop_off" onchange="this.form.submit()">
				<option value="">- <?php echo JText::_('Drop Off'); ?> -</option>
				<option value="1"<?php if ($this->state->get('filter.drop_off') === '1') { ?> selected="selected"<?php } ?>><?php echo JText::_('JYES'); ?></option>
				<option value="0"<?php if ($this->state->get('filter.drop_off') === '0') { ?> selected="selected"<?php } ?>><?php echo JText::_('JNO'); ?></option>
			</select>
	</fieldset>
	<div class="clr"></div>
	<table class="adminlist">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->items); ?>)" />
				</th>
				<th>
					<?php echo JHtml::_('grid.sort', 'Title', 'l.title', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
				<th width="1%" class="nowrap">
					<?php echo JHtml::_('grid.sort', 'Pick Up', 'l.pick_up', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
				<th width="1%" class="nowrap">
					<?php echo JHtml::_('grid.sort', 'Drop Off', 'l.drop_off', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
				<th width="1%" class="nowrap">
					<?php echo JHtml::_('grid.sort', 'ID', 'l.id', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="5">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
			<?php foreach ($this->items as $i => $item) { ?>
				<tr class="row<?php echo $i % 2; ?>">
					<td align="center">
						<?php echo JHtml::_('grid.id', $i, $item->id); ?>
					</td>
					<td>
						<?php if ($item->checked_out) { ?>
							<?php echo JHtml::_('grid.checkedout', $i, $item->editor, $item->checked_out_time, 'location.', true); ?>
						<?php } ?>
						<a href="<?php echo JRoute::_('index.php?option=com_booking&controller=location&task=edit&id='.$item->id);?>">
							<?php echo $this->escape($item->title); ?></a>
					</td>
					<td align="center">
						<?php $item->published = $item->pick_up; echo JHtml::_('grid.published', $item, $i, 'tick.png', 'publish_x.png', 'pick_up_'); ?>
					</td>
					<td align="center">
						<?php $item->published = $item->drop_off; echo JHtml::_('grid.published', $item, $i, 'tick.png', 'publish_x.png', 'drop_off_'); ?>
					</td>
					<td align="center">
						<?php echo (int) $item->id; ?>
					</td>
				</tr>
			<?php } ?>
		</tbody>
	</table>
	<div>
		<input type="hidden" name="controller" value="location" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $this->escape($this->state->get('list.ordering')); ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $this->escape($this->state->get('list.direction')); ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>