<?php

/**
 * Reservation detail template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.tooltip');

/* @var $this BookingViewReservation */

AHtml::title(JText::sprintf('Reservation Num', $this->reservation->id), 'categories');

//append invoice icon
list($avail,$invoiceLink) = BookingHelper::getInvoiceLink($this->reservation->id);
if ($avail==1 || $avail==2){
	$bar = &JToolBar::getInstance('toolbar');
	if ($avail==1)
		$link = '<a title="'.JText::_('Open invoice').'" href="javscript:void(0)" onclick="window.open(\''.$invoiceLink.'\',\'win2\', \'status=yes,toolbar=yes,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no\');">';
	elseif ($avail==2)
		$link = '<a class="hasTip" title="'.JText::_('Invoice not available').'::'.JText::_($invoiceLink).'" href="javscript:void(0)">';
	$bar->appendButton('Custom', $link.'<span style="background-image: url(\''.IMAGES .'icon-32-invoice.png\')"></span>'.JText::_('Invoice').'</a>');
}

JToolBarHelper::custom('Edit', 'edit', 'edit', 'Edit', false);
JToolBarHelper::cancel();

?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<div class="col width-50">
		<fieldset class="adminform">
    		<legend><?php echo JText::_('Customer'); ?></legend>
    		<table class="admintable">
    			<tr>
    				<td class="key"><label><?php echo JText::_('User'); ?>:</label></td>
    				<td>
    					<?php if ($this->customer->id) { ?>
    						<a href="<?php echo ARoute::detail(CONTROLLER_CUSTOMER, $this->customer->id); ?>" title="<?php echo $this->escape(JText::_('Display customer detail')); ?>">
    							<?php echo BookingHelper::formatName($this->customer); ?>
    						</a>
    					<?php 
    						} else {
    							echo JText::_('Unregistered');
    						} 
    					?>
    				</td>
    			</tr>
    			<tr>
    				<td class="key"><label><?php echo JText::_('Name'); ?>:</label></td>
    				<td><?php echo BookingHelper::formatName($this->reservation); ?></td>
    			</tr>
    			<tr>
    				<td class="key"><label><?php echo JText::_('Company'); ?>:</label></td>
    				<td><?php echo $this->reservation->company; ?></td>
    			</tr>
    			<tr>
    				<td class="key"><label><?php echo JText::_('Company ID'); ?>:</label></td>
    				<td><?php echo $this->reservation->company_id; ?></td>
    			</tr>
    			<tr>
    				<td class="key"><label><?php echo JText::_('Vat ID'); ?>:</label></td>
    				<td><?php echo $this->reservation->vat_id; ?></td>
    			</tr>    			    			
    			<?php
    				if (is_array($this->reservation->fields)) { 
    					foreach ($this->reservation->fields as $field) { 
    			?>		 
		    		 		<tr>
		    					<td class="key"><?php echo $field['title']; ?>: </td>
		    					<td><?php echo $field['value']; ?></td>
		    				</tr>
		    	<?php 
    					}
    				}
    			?>
    		</table>
    	</fieldset>
    	<fieldset class="adminform">
    		<legend><?php echo JText::_('Contact'); ?></legend>
    		<table class="admintable">
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Address'); ?>:</label></td>
    				<td><?php echo BookingHelper::formatAddress($this->reservation); ?></td>
    			</tr>	
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Email'); ?>:</label></td>
    				<td><?php echo BookingHelper::getEmailLink($this->reservation); ?></td>
    			</tr>
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Telephone'); ?>:</label></td>
    				<td><?php echo $this->reservation->telephone; ?></td>
    			</tr>
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Fax'); ?>:</label></td>
    				<td><?php echo $this->reservation->fax; ?></td>
    			</tr>
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Note'); ?>:</label></td>
    				<td><?php echo $this->reservation->note; ?></td>
    			</tr>
    		</table>
    	</fieldset>
	    	
	    <fieldset class="adminform">
	    	<legend><?php echo JText::_('Reservation Status and Payment'); ?></legend>
	    		<table class="admintable">
	    			<?php if (AHtml::date($this->reservation->created, ADATE_FORMAT_LONG)) { ?>
	    				<tr>
	    					<td class="key"><label><?php echo JText::_('Created'); ?></label></td>
	    					<td>
	    						<?php echo $this->reservation->creator ? $this->reservation->creator : JText::_('Unregistered Customer'); ?>
	    						<?php echo AHtml::date($this->reservation->created, ADATE_FORMAT_LONG); ?>
	    					</td>
	    				</tr>
	    			<?php } ?>
	    			<?php if (AHtml::date($this->reservation->modified, ADATE_FORMAT_LONG)) { ?>
	    				<tr>
	    					<td class="key"><label><?php echo JText::_('Modified'); ?></label></td>
	    					<td>
	    						<?php echo $this->reservation->modifier ? $this->reservation->modifier : JText::_('Unregistered Customer'); ?>
	    						<?php echo AHtml::date($this->reservation->modified, ADATE_FORMAT_LONG); ?>
	    					</td>
	    				</tr>
	    			<?php } ?>
	    			<tr>	
	    				<td class="key"><label><?php echo JText::_('Payment Status'); ?>:</label></td>
	    				<td>
	    					<?php echo BookingHelper::showReservationPaymentStateLabel($this->reservation->paid); ?>
						</td>
	    			</tr>
	    			<tr>	
	    				<td class="key"><label><?php echo JText::_('Reservation Status'); ?>:</label></td>
	    				<td>
							<?php echo BookingHelper::showReservationStateLabel($this->reservation->state); ?>
						</td>
	    			</tr>
	    					   			<tr>
						<td class="key"><label><?php echo JText::_('Total Price'); ?>: </label></td>
						<td><strong><?php echo BookingHelper::displayPrice($this->reservation->fullPrice); ?></strong></td>
					</tr>
					<tr>
						<td class="key"><label><?php echo JText::_('Tax'); ?>: </label></td>
						<td><strong><?php echo BookingHelper::displayPrice(BookingHelper::getFullTax($this->reservedItems)); ?></strong></td>
					</tr>
					<?php if ($this->reservation->fullDeposit) {?>
			   			<tr>
							<td class="key"><label><?php echo JText::_('Deposit'); ?>: </label></td>
							<td><strong><?php echo BookingHelper::displayPrice($this->reservation->fullDeposit); ?></strong></td>
						</tr>
					<?php } ?>
					<tr>
				    	<td class="key"><label><?php echo JText::_('Deposit must be paid before'); ?>: </label></td>
						<td><strong><?php echo $this->depositExpires; ?></strong></td>				
		    		</tr>
	    	</table>
	    </fieldset>
    </div>
    <div class="col width-50">
    <?php     	
    	$z=0;
		$countReservedItems = count($this->reservedItems);
    	if ($countReservedItems)
    		foreach ($this->reservedItems as $reservedItem){
				$id = $z++;
				$subject = $this->subjects[$reservedItem->subject];
				$capacity = $subject->display_capacity || $subject->total_capacity>1 || $reservedItem->capacity>1; //display capacity row
				$fullPrice = $reservedItem->fullPrice!=$reservedItem->price; //display full price
				$fullDeposit = $reservedItem->fullDeposit!=$reservedItem->deposit; //display full deposit
				$fullPriceSupplements = $reservedItem->fullPrice!=$reservedItem->fullPriceSupplements; //display full price with supplements
	?>
    	<fieldset class="adminform">
    		<legend><?php if ($countReservedItems>1) echo '#'.($id+1).' '?><?php echo JText::_('Reservation'); ?></legend>
    		<table class="admintable reserved_item">
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Subject'); ?>:</label></td>
    				<td colspan="5">
    					<?php if ($subject->title) { ?>
    						<a href="<?php echo ARoute::edit(CONTROLLER_SUBJECT, $subject->id); ?>" title="<?php echo $this->escape(JText::_('Display subject')); ?>">
    							<?php echo $reservedItem->subject_title; ?>
    						</a>
    					<?php 
    						} else {
    							echo $reservedItem->subject_title;	
    						} 
    					?>
    				</td>
    			</tr>
    			    			<?php if ($capacity){?>
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Capacity'); ?>:</label></td>
    				<td colspan="5"><?php echo number_format($reservedItem->capacity, 0, '', ' '); ?></td>
    			</tr>
    			<?php } ?>
    			<?php if ($reservedItem->rtype == RESERVATION_TYPE_PERIOD) { ?>
    				<tr>
    					<td class="key"><label><?php echo JText::_('Timeframe'); ?>:</label></td>
    					<td><?php echo AHtml::showRecurenceTimeframe($reservedItem); ?></td>
    				</tr>
    				<tr>
    					<td class="key"><label><?php echo JText::_('Recurrence Pattern'); ?>:</label></td>
    					<td><?php echo AHtml::showRecurencePattern($reservedItem); ?></td>
    				</tr>
    				<tr>
    					<td class="key"><label><?php echo JText::_('Range of Recurrence'); ?>:</label></td>
    					<td><?php echo AHtml::showRecurenceRange($reservedItem); ?></td>
    				</tr>
    				<tr>
    					<td class="key"><label><?php echo JText::_('Recurrence Total'); ?>:</label></td>
    					<td><?php echo $reservedItem->period_total; ?></td>
    				</tr>
    			<?php } else { ?>
    				<tr>	
    					<td class="key"><label><?php echo AHtml::intervalLabel($reservedItem); ?>:</label></td>
    					<td colspan="5"><?php echo AHtml::interval($reservedItem); ?></td>
    				</tr>
    			<?php } ?>
    			<!--
    			<tr>	
    				<td class="key"><label><?php echo JText::_('Deposit must be paid before'); ?>:</label></td>
    				<td colspan="5"><?php echo BookingHelper::formatExpiration($reservedItem->cancel_time,$reservedItem->from); ?></td>
    			</tr>
    			-->
    			<?php foreach ($reservedItem->supplements as $supplement) { ?>
					<?php /* @var $supplement TableReservationSupplement */ ?>
			
					<tr>
						<td class="key hasTip" title="<?php echo BookingHelper::displaySupplementTooltip($supplement); ?>"><label><?php echo $supplement->title; ?>: </label></td>
    					<td colspan="5"><?php echo BookingHelper::displaySupplementValue($supplement); ?></td>
    				</tr>
    			<?php }?>
    				<tr>	
		    			<td class="key"><label><?php echo ITEM_PRICE_TIP ?></label></td>
		    			<td><?php echo BookingHelper::displayPrice($reservedItem->price); ?></td>
	    				<td class="key"><label><?php if ($fullPrice){ ?><?php echo FULL_PRICE_TIP; } ?></label></td>
		    			<td><?php if ($fullPrice){ ?><?php echo BookingHelper::displayPrice($reservedItem->fullPrice); ?><?php } ?></td>
		    			<td class="key"><label><?php if ($fullPriceSupplements) {?><?php echo FULL_PRICE_SUPPLEMENTS_TIP; } ?></label></td>
			    		<td><?php if ($fullPriceSupplements) {?><?php echo BookingHelper::displayPrice($reservedItem->fullPriceSupplements); ?><?php } ?></td>
		    		</tr>
		    		<tr>
    					<td class="key"><label><?php echo BookingHelper::showTax($reservedItem->tax); ?>:</label>
    					<td><?php echo BookingHelper::displayPrice(BookingHelper::getTax($reservedItem->fullPriceSupplements, $reservedItem->tax)); ?></td>
    				</tr>
			    <?php if ($reservedItem->fullDeposit) { ?>
		    				<tr>	
		    					<td class="key"><label><?php echo ITEM_DEPOSIT_TIP ?></label></td>
		    					<td><?php echo BookingHelper::displayPrice($reservedItem->deposit); ?></td>
		    					<td class="key"><label><?php if ($fullDeposit){ ?><?php echo FULL_DEPOSIT_TIP; } ?></label></td>
		    					<td><?php if ($fullDeposit){ ?><?php echo BookingHelper::displayPrice($reservedItem->fullDeposit); ?><?php } ?></td>
		    					<td class="key"><label></label></td>
		    					<td></td>
		    				</tr>
    			<?php } ?>
    				<tr>	
	    				<td class="key"><label><?php echo JText::_('Message'); ?>:</label></td>
	    				<td><?php echo htmlspecialchars($reservedItem->message); ?></td>
	    			</tr>
    		</table>
    	</fieldset>
    	<?php } ?>
    	
   	</div>
   	<div class="clr">&nbsp;</div>
	<input type="hidden" name="option" value="<?php echo OPTION; ?>"/>
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>"/>
	<input type="hidden" name="boxchecked" value="1"/>
	<input type="hidden" name="cid[]" value="<?php echo $this->reservation->id; ?>"/>
	<input type="hidden" name="task" value=""/>
	<?php echo JHTML::_('form.token'); ?>
</form>