<?php

/**
 * Subject-supplements edit form template
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubject */

$options[] = JHTML::_('select.option', SUPPLEMENT_TYPE_UNSELECT, JText::_('Select list'));
$options[] = JHTML::_('select.option', SUPPLEMENT_TYPE_LIST, JText::_('List'));
$options[] = JHTML::_('select.option', SUPPLEMENT_TYPE_YESNO, JText::_('YesNo'));

$paids[] = JHTML::_('select.option', SUPPLEMENT_ONE_PRICE, JText::_('Supplement one price'));
$paids[] = JHTML::_('select.option', SUPPLEMENT_MORE_PRICES, JText::_('Supplement more prices'));
$paids[] = JHTML::_('select.option', SUPPLEMENT_NO_PRICE, JText::_('Supplement no price'));

?>
<div class="width-100">
	<fieldset class="adminform">
	    <legend>
	   		<span class="legend"><?php echo JText::_('Supplements'); ?></span>
	   	</legend>
	    <?php if (count($this->supplements)) { ?>
		    <div class="col">
		    	<?php
	    			$bar = &JToolBar::getInstance('toolsupplements');
	        		$bar->appendButton('ALink', 'new', 'Add', 'EditSubject.addSupplement()');
	        		$bar->appendButton('ALink', 'delete', 'Delete', 'EditSubject.removeSupplements()');
	        		echo $bar->render();
	    		?>
	    		<div class="clr"></div>
				<table class="template" id="supplements">
					<thead>
						<tr>
							<th valign="top">&nbsp;</th>
							<th valign="top"><h3><?php echo JText::_('ID'); ?></h3></th>
							<th valign="top">
								<h3><?php echo JText::_('Title'); ?><br/><?php echo JText::_('Description'); ?><span class="star"> *</span></h3>
							</th>
							<th valign="top"><h3><?php echo JText::_('Type'); ?><span class="star"> *</span></h3></th>
							<th valign="top"><h3><?php echo JText::_('Options'); ?><span class="star"> *</span></h3></th>
							<th valign="top"><h3><?php echo JText::_('Price'); ?><span class="star"> *</span></h3></th>
							<th valign="top"><h3><?php echo JText::_('Supplement capacity'); ?><span class="star"> *</span></h3></th>
						</tr>
					</thead>
					<tbody id="tsupplements">
					<?php 
						$scount = count($this->supplements);
						for ($i = 0; $i < $scount; $i++) {
							$supplement = &$this->supplements[$i];
							/* @var $supplement TableSupplement */
							TableSupplement::display($supplement);
							JFilterOutput::objectHTMLSafe($supplement);
							$id = $i ? $supplement->id : ''; 
						?>
							<tr <?php if (! $id) { echo 'id="supplement" style="display: none;"'; } ?>>
								<td class="check" valign="top">
									<input type="checkbox" class="inputCheckbox" name="scid[]" value="1"/>
								</td>
								<td class="id" valign="top">
									<?php echo $id ? $id : '<i>' . JText::_('New') . '</i>'; ?>
									<span class="up" title="<?php echo $this->escape(JText::_('Move supplement up')); ?>"></span>
									<span class="down" title="<?php echo $this->escape(JText::_('Move supplement down')); ?>"></span>
									<input type="hidden" name="<?php echo SUPPLEMENTS_PREFIX; ?>ordering[<?php echo $id; ?>]" value="<?php echo $supplement->ordering; ?>" />									
								</td>
								<td valign="top">
									<input type="text" name="<?php echo SUPPLEMENTS_PREFIX; ?>title[<?php echo $id; ?>]" value="<?php echo $supplement->title; ?>" class="title"/>
									<br/>
									<textarea name="<?php echo SUPPLEMENTS_PREFIX; ?>description[<?php echo $id; ?>]" class="description" rows="1" cols="30"><?php echo $supplement->description; ?></textarea>
								</td>
								<td valign="top">
									<?php echo JHTML::_('select.genericlist', $options, SUPPLEMENTS_PREFIX . 'type[' . $id . ']', 'onchange="EditSubject.setSupplementType(this)"', 'value', 'text', $supplement->type); ?>
									<div class="clr"></div>
									
									<input type="hidden" name="<?php echo SUPPLEMENTS_PREFIX; ?>empty[<?php echo $id; ?>]" value="<?php echo $supplement->empty; ?>" />
									<input type="checkbox" class="inputCheckbox" id="empty<?php echo $id; ?>" name="fake[]" <?php if ($supplement->empty == SUPPLEMENT_EMPTY_USE) { ?>checked="checked"<?php } if ($supplement->type != SUPPLEMENT_TYPE_LIST || ! $id) { ?>disabled="disabled"<?php } ?> onchange="ACommon.check(this);" /> 			
									<label for="empty<?php echo $id; ?>"><?php echo JText::_('Supplement empty option'); ?></label>
								</td>
								<td valign="top">
									<textarea name="<?php echo SUPPLEMENTS_PREFIX; ?>options[<?php echo $id; ?>]" class="description" rows="1" cols="20" <?php if ($supplement->type == SUPPLEMENT_TYPE_YESNO) { ?>disabled="disabled"<?php } ?>><?php echo $supplement->options; ?></textarea>
								</td>
								<td valign="top" nowrap="nowrap">
									<input type="text" class="number price" name="<?php echo SUPPLEMENTS_PREFIX; ?>price[<?php echo $id; ?>]" value="<?php echo $supplement->price; ?>"<?php if ($supplement->paid != SUPPLEMENT_ONE_PRICE) { ?> style="display: none"<?php } ?> onkeyup="ACommon.toFloat(this)" />
									<textarea name="<?php echo SUPPLEMENTS_PREFIX; ?>price[<?php echo $id; ?>]" class="price" rows="1" cols="10"<?php if ($supplement->paid != SUPPLEMENT_MORE_PRICES) { ?> style="display: none;"<?php } ?>><?php echo $supplement->price; ?></textarea>
									<div class="clr"></div>
									<?php echo JHTML::_('select.genericlist', $paids, SUPPLEMENTS_PREFIX . 'paid[' . $id . ']', 'onchange="EditSubject.setSupplementPaid(this)"', 'value', 'text', $supplement->paid); ?>
								
									<div class="clr"></div>
									<input type="hidden" name="<?php echo SUPPLEMENTS_PREFIX; ?>unit_multiply[<?php echo $id; ?>]" value="<?php echo $supplement->unit_multiply; ?>" />
									<input type="checkbox" class="inputCheckbox" id="unit_multiply<?php echo $id; ?>" name="fake[]" <?php if ($supplement->unit_multiply == SUPPLEMENT_UNIT_MULTIPLY) { ?>checked="checked"<?php } ?> onchange="ACommon.check(this);" />
									<label for="unit_multiply<?php echo $id; ?>"><?php echo JText::_('Multiply supplements price count units'); ?></label>
									
								</td>
							
								<td valign="top" nowrap="nowrap">
									<div><label style="clear:both" class="hasTip" title="<?php echo $this->escape(($title = JText::_('Supplement no capacity'))) . '::' . $this->escape(JText::_('Supplement no capacity info')); ?>">
									<input type="radio" name="<?php echo SUPPLEMENTS_PREFIX; ?>capacity_multiply[<?php echo $id; ?>]" value="0"<?php if (!$supplement->capacity_multiply) echo ' checked'?> onclick="$('max_capacity_<?php echo $id; ?>').setStyle('display','none');">
									<?php echo JText::_('Supplement no capacity'); ?>
									</label></div>
									<div><label style="clear:both" class="hasTip" title="<?php echo $this->escape(($title = JText::_('Supplement subject capacity'))) . '::' . $this->escape(JText::_('Supplement subject capacity info')); ?>">
									<input type="radio" name="<?php echo SUPPLEMENTS_PREFIX; ?>capacity_multiply[<?php echo $id; ?>]" value="1"<?php if ($supplement->capacity_multiply==1) echo ' checked'?> onclick="$('max_capacity_<?php echo $id; ?>').setStyle('display','none');">
									<?php echo JText::_('Supplement subject capacity'); ?>
									</label></div>
									<div><label style="clear:both" class="hasTip" title="<?php echo $this->escape(($title = JText::_('Supplement manual capacity withmultiply'))) . '::' . $this->escape(JText::_('Supplement manual capacity withmultiply info')); ?>">
									<input type="radio" name="<?php echo SUPPLEMENTS_PREFIX; ?>capacity_multiply[<?php echo $id; ?>]" value="2"<?php if ($supplement->capacity_multiply==2) echo ' checked'?> onclick="$('max_capacity_<?php echo $id; ?>').setStyle('display','block');">
									<?php echo JText::_('Supplement manual capacity withmultiply'); ?>
									</label>
									<div id="max_capacity_<?php echo $id; ?>" style="clear:both;display:<?php echo $supplement->capacity_multiply==2 ? 'block' : 'none'?>" class="hasTip" title="<?php echo $this->escape(($title = JText::_('Supplement max capacity'))) . '::' . $this->escape(JText::_('Supplement max capacity info')); ?>">
									<?php echo JText::_('Supplement max capacity'); ?>: 
									<input style="float:none" size="10" class="number" type="text" name="<?php echo SUPPLEMENTS_PREFIX; ?>capacity_max[<?php echo $id; ?>]" value="<?php echo (int)$supplement->capacity_max?>">
									</div>
									</div>
								</td>	
							</tr>
						<?php } ?>
							<tr id="supplement-empty" <?php if ($scount > 1) { ?>style="display: none;"<?php } ?>><td colspan="8" class="emptyList"><?php echo JText::_('Empty supplements list'); ?></td></tr>
					</tbody>
				</table>			
			</div>
		<?php } ?>
	</fieldset>
</div>