/**
 * Javascript for configuration form
 * 
 * @version $Id$
 * @package ARTIO Booking
 * @subpackage assets
 * @copyright Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author ARTIO s.r.o., http://www.artio.net
 * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link http://www.artio.net Official website
 */

var ViewConfig = {

	/**
	 * Valid form before submit. Standard in Joomla! administration.
	 * 
	 * @param pressbutton
	 *            button selected in toolbar
	 */
	submitbutton : function(pressbutton) {
		switch (pressbutton) {
		case 'apply':
			// save last select bookmark into cookies
			ACommon.saveBookmark();
			break;
		}
		submitform(pressbutton);
	},

	/**
	 * Some options have child options. This child options are selectable only
	 * if masters options are switch on. This function disable child options if
	 * masters are switch off. This function set events for masters - if masters
	 * go to switch on then child options are enabled.
	 * 
	 * @param boolean
	 *            setEvents if true then function set events for masters - run
	 *            only once during initialise
	 */
	setEvents : function(setEvents) {

		// bookmark main
		this.setDisabled('paramsdate_long', 'paramsdate_type0');
		this.setDisabled('paramsdate_normal', 'paramsdate_type0');
		this.setDisabled('paramsdate_day', 'paramsdate_type0');
		this.setDisabled('paramsdate_day_short', 'paramsdate_type0');
		this.setDisabled('paramstime', 'paramsdate_type0');

		/* bookmark objects */

		// thumbnails
		this.setDisabled('paramsdisplay_thumbs_subjects_list_width',
				'paramsdisplay_thumbs_subjects_list0');
		this.setDisabled('paramsdisplay_thumbs_subjects_list_height',
				'paramsdisplay_thumbs_subjects_list0');

		// introtext
		this.setDisabled('paramsdisplay_readmore_subjects_list_length',
				'paramsdisplay_readmore_subjects_list0');

		// pagination
		if ($('paramssubjects_pagination0').checked || $('paramssubjects_pagination1').checked) {
			$('paramssubjects_pagination_start').setProperty('disabled', false);
			$('paramssubjects_pagination_selector0').setProperty('disabled', false);
			$('paramssubjects_pagination_selector1').setProperty('disabled', false);
		}
		if ($('paramssubjects_pagination1').checked) {
			$('paramssubjects_pagination_start').setProperty('disabled', true);
			$('paramssubjects_pagination_selector0').setProperty('disabled', true);
			$('paramssubjects_pagination_selector1').setProperty('disabled', true);
		}

		// monthly calendars
		this.setDisabled('paramssubjects_calendar_skin',
				'paramssubjects_calendar0');
		this.setDisabled('paramssubjects_calendar_start',
				'paramssubjects_calendar0');
		this.setDisabled('paramssubjects_calendar_deep',
				'paramssubjects_calendar0');
		// weekly calendars
		this.setDisabled('paramssubjects_week_deep', 'paramssubjects_week0');

		/* bookmark object */

		// main image
		this.setDisabled('paramsdisplay_thumbs_subject_detail_width',
				'paramsdisplay_image_subject_detail0');
		this.setDisabled('paramsdisplay_thumbs_subject_detail_height',
				'paramsdisplay_image_subject_detail0');
		// images gallery
		this.setDisabled('paramsdisplay_gallery_thumbs_subject_detail_width',
				'paramsdisplay_gallery_subject_detail0');
		this.setDisabled('paramsdisplay_gallery_thumbs_subject_detail_height',
				'paramsdisplay_gallery_subject_detail0');
		this.setDisabled('paramsdisplay_gallery_preview_subject_detail_width',
				'paramsdisplay_gallery_subject_detail0');
		this.setDisabled('paramsdisplay_gallery_preview_subject_detail_height',
				'paramsdisplay_gallery_subject_detail0');

		/* bookmark prices */
		if ($('paramsthousand_separatornone').checked)
			$('paramsthousand_separator_char').setProperty('disabled', true);
		if ($('paramsthousand_separatorspace').checked)
			$('paramsthousand_separator_char').setProperty('disabled', true);
		if ($('paramsthousand_separatorcomma').checked)
			$('paramsthousand_separator_char').setProperty('disabled', true);
		if ($('paramsthousand_separatorpoint').checked)
			$('paramsthousand_separator_char').setProperty('disabled', true);
		if ($('paramsthousand_separatorchar').checked)
			$('paramsthousand_separator_char').setProperty('disabled', false);

		// set events for all masters
		if (setEvents) {

			Array.each($('adminForm').getElements('*[class^=masterChild]'),
					function(child, index) {
						child.getParent().getParent().addClass('masterChild');
						child.removeClass('masterChild');
					});
			
			$('paramssubjects_pagination_selector0').getParent().getParent().addClass('masterChild');

			var masters = new Array('paramsdate_type0', 'paramsdate_type1',
					'paramsquick_navigator0', 'paramsquick_navigator1',
					'paramssubjects_paginationauto', 'paramssubjects_pagination0', 'paramssubjects_pagination1',
					'paramsdisplay_thumbs_subjects_list0',
					'paramsdisplay_thumbs_subjects_list1',
					'paramsdisplay_image_subject_detail0',
					'paramsdisplay_image_subject_detail1',
					'paramsdisplay_gallery_subject_detail0',
					'paramsdisplay_gallery_subject_detail1',
					'paramsthousand_separatornone',
					'paramsthousand_separatorspace', 
					'paramsthousand_separatorcomma',
					'paramsthousand_separatorpoint',
					'paramsthousand_separatorchar',
					'paramssubjects_calendar0',
					'paramssubjects_calendar1', 'paramssubjects_week0',
					'paramssubjects_week1',
					'paramsdisplay_readmore_subjects_list0',
					'paramsdisplay_readmore_subjects_list1');
			for ( var i = 0; i < masters.length; i++)
				$(masters[i]).addEvent('click', function() {
					ViewConfig.setEvents(false);
				});
		}
	},

	/**
	 * Disable child option if master is switch off.
	 * 
	 * @param string
	 *            child ID of child option
	 * @param string
	 *            master ID of master option
	 */
	setDisabled : function(child, master) {
		$(child).setProperty('disabled', $(master).checked);
	}
}

try {
	/**
	 * Joomla! 1.6.x
	 */
	Joomla.submitbutton = function(pressbutton) {
		return ViewConfig.submitbutton(pressbutton);
	}
} catch (e) {
	/**
	 * Joomla! 1.5.x
	 */
	function submitbutton(pressbutton) {
		return ViewConfig.submitbutton(pressbutton);
	}
}