/**
 * Javascript for edit subject form
 * 
 * @version $Id$
 * @package ARTIO Booking
 * @subpackage assets
 * @copyright Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author ARTIO s.r.o., http://www.artio.net
 * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link http://www.artio.net Official website
 */

var EditSubject = {

	/**
	 * Reset subject hits counter
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	resetHits : function() {
		form = ACommon.getForm();
		if (confirm(LGAreYouSure)) {
			form.hits.value = 0;
			form.hits_disabled.value = 0;
		}
		return false;
	},

	/**
	 * Open dialog for save subject as new template
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	openSaveAsNewTemplate : function() {
		this.setSaveAsNewTemplate('open', 'saveAsNew');
	},

	/**
	 * Storno dialog for save subject as new template
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	closeSaveAsNewTemplate : function() {
		this.setSaveAsNewTemplate('close', '');
	},

	/**
	 * Set dialog for save subject as new template
	 * 
	 * @param object
	 *            edit form element
	 * @param string
	 *            way set type: 'open' .. open dialog, 'close' .. close dialog
	 * @return boolean false to disable form submit
	 */
	setSaveAsNewTemplate : function(way, value) {
		this.setTemplateTask(value);
		document.getElementById('saveAsNewTemplate').style.display = way == 'open' ? 'inline'
				: 'none';
		document.getElementById('templateName').style.display = way == 'open' ? 'none'
				: '';
		return false;
	},

	/**
	 * Return true if dialog for save subject as new template is open.
	 */
	isSetSaveAsNewTemplate : function() {
		return document.getElementById('saveAsNewTemplate').style.display == 'inline';
	},

	/**
	 * Open dialog for rename subject template
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	openRenameTemplate : function() {
		this.setRenameTemplate('open', 'rename');
	},

	/**
	 * Storno dialog for rename subject template
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	closeRenameTemplate : function() {
		this.setRenameTemplate('close', '');
	},

	/**
	 * Set dialog for save subject as new template
	 * 
	 * @param object
	 *            edit form element
	 * @param string
	 *            way set type: 'open' .. open dialog, 'close' .. close dialog
	 * @return boolean false to disable form submit
	 */
	setRenameTemplate : function(way, value) {
		this.setTemplateTask(value);
		document.getElementById('renameTemplate').style.display = way == 'open' ? 'inline'
				: 'none';
		document.getElementById('templateName').style.display = way == 'open' ? 'none'
				: '';
		return false;
	},

	/**
	 * Return true if dialog for rename subject is open.
	 */
	isSetRenameTemplate : function() {
		return document.getElementById('renameTemplate').style.display == 'inline';
	},

	/**
	 * Set text field content. Remove mask value.
	 * 
	 * @param object
	 *            edit form element
	 * @param string
	 *            mask text mask value
	 */
	setTemplateNameContent : function() {
		form = ACommon.getForm();
		if (form.new_template_name.value == TemplateNameMask) {
			form.new_template_name.value = '';
		}
	},

	/**
	 * Open dialog for change subject template
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	openChangeTemplate : function() {
		this.setChangeTemplate('open', 'changeTemplate');
	},

	/**
	 * Close dialog for change subject template
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	closeChangeTemplate : function() {
		this.setChangeTemplate('close', '');
	},

	/**
	 * Set dialog for change subject template
	 * 
	 * @param object
	 *            edit form element
	 * @param string
	 *            way set type: 'open' .. open dialog, 'close' .. close dialog
	 * @return boolean false to disable form submit
	 */
	setChangeTemplate : function(way, value) {
		this.setTemplateTask(value);
		document.getElementById('changeTemplate').style.display = way == 'open' ? 'inline'
				: 'none';
		document.getElementById('templateName').style.display = way == 'open' ? 'none'
				: '';
		return false;
	},

	/**
	 * Open dialog for delete subject template
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	openDeleteTemplate : function() {
		this.setDeleteTemplate('open', 'deleteTemplate');
	},

	/**
	 * Close dialog for delete subject template
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	closeDeleteTemplate : function() {
		this.setDeleteTemplate('close', '');
	},

	/**
	 * Set dialog for delete subject template
	 * 
	 * @param object
	 *            edit form element
	 * @param string
	 *            way set type: 'open' .. open dialog, 'close' .. close dialog
	 * @return boolean false to disable form submit
	 */
	setDeleteTemplate : function(way, value) {
		this.setTemplateTask(value);
		document.getElementById('deleteTemplate').style.display = way == 'open' ? 'inline'
				: 'none';
		document.getElementById('templateName').style.display = way == 'open' ? 'none'
				: '';
		return false;
	},

	/**
	 * Submit form for delete template.
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	deleteTemplate : function() {
		form = ACommon.getForm();
		if (confirm(LGAreYouSure)) {
			submitform('deleteTemplate');
		}
		return false;
	},

	/**
	 * Submit form for change template.
	 * 
	 * @param object
	 *            edit form element
	 * @return boolean false to disable form submit
	 */
	changeTemplate : function() {
		form = ACommon.getForm();
		if (form.template.value == '0') {
			alert(LGErrAddSubjectTemplate);
		} else if (confirm(LGAreYouSure)) {
			submitform('changeTemplate');
		}
		return false;
	},

	/**
	 * Set template task input hidden value
	 * 
	 * @param object
	 *            edit form element
	 * @param value
	 *            to set
	 */
	setTemplateTask : function(value) {
		form = ACommon.getForm();
		form.templateTask.value = value;
	},

	/**
	 * Add rezervation type row.
	 */
	addRtype : function() {
		/* copy default mask row */
		var clone = $('rtype').clone().inject('rtypes');
		/* set as visible */
		clone.style.display = '';
		/* remove element ID - no duplicity */
		clone.removeProperty('id');
		/* get all chidrens as elements array */
		var children = clone.getChildren();
		/* append and setup time pickers */
		var element = clone.getElement('select[name^=rtype-type]');
		element.className = 'notify';
		this.setReservationType(element);
		this.setEmptyRtype(false);
	},

	/**
	 * Set visibilaty of empty row of reservation types with information about
	 * creating reservation types.
	 */
	setEmptyRtype : function(display) {
		document.getElementById('rtype-empty').style.display = display ? ''
				: 'none';
	},

	/**
	 * Prepare saved reservation type displaying.
	 */
	prepareReservationTypes : function(allEnable) {
		if ($('rtypes')) {
			var elements = $('rtypes').getElements('select[name^=rtype-type]');
			for ( var i = 1; i < elements.length; i++) {
				this.setReservationType(elements[i], allEnable);
			}
		}
	},

	/**
	 * Remove rezervation types rows.
	 */
	removeRtypes : function() {
		var deletedAll = ACommon.removeRows('rtypes', 'rcid');
		if (deletedAll) {
			this.setEmptyRtype(true);
		}
	},

	setReservationType : function(element, allEnable) {
		var cell = $(element).getParent();
		var row = cell.getParent();

		var title = $(row).getElement('input[name^=rtype-title]');
		var description = $(row)
				.getElement('textarea[name^=rtype-description]');
		var timeUnit = $(row).getElement('input[name^=rtype-time_unit]');
		var gapTime = $(row).getElement('input[name^=rtype-gap_time]');
		
		var min = $(row).getElement('input[name^=rtype-min]');
		var max = $(row).getElement('input[name^=rtype-max]');
		var fix = $(row).getElement('input[name^=rtype-fix]');
		var fixFrom = $(row).getElement('select[name^=rtype-fix_from]');
		var fixPast = $(row).getElement('input[name^=rtype-book_fix_past][type=checkbox]');
		
		var rtypeValue = allEnable ? '1' : element.value;

		var textDisabled = true;
		var timeDisabled = true;
		var limitDisabled = true;
		var className = 'notify';
		var fixFromDisabled = null;

		switch (rtypeValue) {
		case '1':
			/* hourly */
			textDisabled = false;
			timeDisabled = false;
			className = '';
			limitDisabled = false;
			fixFromDisabled = !allEnable;
			break;
		case '2':
			/* daily */
			textDisabled = false;
			className = '';
			limitDisabled = false;
			fixFromDisabled = false;
			break;
		}

		element.className = className;

		title.disabled = description.disabled = textDisabled;
		min.disabled = max.disabled = fix.disabled = fixFrom.disabled = limitDisabled;
		fixFrom.disabled = fixPast.disabled = fixFromDisabled;
		timeUnit.disabled = gapTime.disabled = timeDisabled;
		
		if (textDisabled)
			title.value = description.value = '';
		
		if (limitDisabled)
			min.value = max.value = fix.value = '';

		if (timeDisabled) 
			timeUnit.value = gapTime.value = '';
		
		if (fixFromDisabled) {
			fixFrom.value = 'any';
			fixPast.checked = false;
		}
	},

	/**
	 * Add price row.
	 */
	addPrice : function() {
		/* copy default mask row */
		var clone = $('price').clone().inject('tprices');
		/* set as visible */
		clone.style.display = '';
		/* remove element ID - no duplicity */
		clone.removeProperty('id');
		/* get all chidrens as elements array */
		var children = clone.getChildren();
		/* append and setup calendars */
		ACommon.createCalendar(children[11], 'priceDateUp#', 'price-date_up[]');
		ACommon.createCalendar(children[12], 'priceDateDown#',
				'price-date_down[]');
		/* append and setup time pickers */
		ACommon.createTimePicker(children[13], 'price-time_up[]', true);
		ACommon.createTimePicker(children[14], 'price-time_down[]', true);
		/* prepare new row inputs */
		var element = clone.getElement('select[name^=price-rezervation_type]');
		element.className = 'notify';
		this.setPriceReservationType(element);
		this.setEmptyPrice(false);
	},

	/**
	 * Set visibilaty of empty row of prices with information about creating
	 * prices.
	 */
	setEmptyPrice : function(display) {
		document.getElementById('price-empty').style.display = display ? ''
				: 'none';
	},

	/**
	 * Prepare saved prices displaying.
	 */
	preparePrices : function(allEnable) {
		if (document.getElementById('tprices')) {
			var elements = $('tprices').getElements(
					'select[name^=price-rezervation_type]');
			for ( var i = 1; i < elements.length; i++) {
				this.setPriceReservationType(elements[i], allEnable);
			}
		}
	},

	/**
	 * Remove prices rows.
	 */
	removePrices : function() {
		var deletedAll = ACommon.removeRows('tprices', 'pcid');
		if (deletedAll) {
			this.setEmptyPrice(true);
		}
	},

	setPriceReservationType : function(element, allEnable) {
		var row = $(element).getParent().getParent();

		var value = row.getElement('input[name^=price-value]');
		var deposit = row.getElement('input[name^=price-deposit]');

		var rtype = document.getElementById('rtype-type' + element.value);

		var dateUp = row.getElement('input[name^=price-date_up]');
		var dateDown = row.getElement('input[name^=price-date_down]');

		var timeUp = row.getElement('input[name^=price-time_up]');
		var timeDown = row.getElement('input[name^=price-time_down]');
		
		var timePickerMidnight = row.getElements('input[class=timePickerMidnight]');
		var timePickerDiv = row.getElements('div[class=picker]');

		var days = row.getElements('input[name^=fake]');

		var rtypeValue = rtype ? rtype.value : false;

		if (allEnable) {
			rtypeValue = '1';
		}

		var className = 'notify';

		var priceDisabled = true;
		var dateDisabled = true;
		var timeDisabled = true;

		switch (rtypeValue) {
		case '1':
			/* hourly */
			priceDisabled = false;
			dateDisabled = false;
			timeDisabled = false;
			className = '';
			break;
		case '2':
			/* daily */
			priceDisabled = false;
			dateDisabled = false;
			className = '';
			break;
		}

		element.className = className;

		value.disabled = priceDisabled;
		deposit.disabled = priceDisabled;

		if (priceDisabled) {
			value.value = '';
			deposit.value = '';
		}

		dateUp.disabled = dateDisabled;
		dateDown.disabled = dateDisabled;

		if (dateDisabled) {
			dateUp.value = '';
			dateDown.value = '';
		}

		timeUp.disabled = timeDisabled;
		timeDown.disabled = timeDisabled;

		if (timeDisabled) {
			timeUp.value = '';
			timeDown.value = '';
			timePickerMidnight.each(function(e) {
				e.disabled = true;
				e.checked = false;
			});
			timePickerDiv.each(function(e) {
				e.setStyle('display','');
			});
		} else 
			timePickerMidnight.each(function(e) {
				e.disabled = false;
			});

		for ( var i = 0; i < days.length; i++) {
			if (!allEnable) {
				days[i].disabled = dateDisabled;
				if (dateDisabled) {
					days[i].checked = !dateDisabled;
				}
				ACommon.check(days[i]);
			}
		}
	},
	setPaymentExpirationType : function(element) {
		var row = $(element).getParent();
		var value = row.getElement('input[name^=price-cancel_time]');
		var value2 = row.getElement('select[name^=price-expiration_format]');

		if($(element).getSelected().get("value") < 2)
		{
			value.disabled = true;
			value2.disabled = true;
		}
		else
		{
			value.disabled = false;
			value2.disabled = false;
		}
	},
	checkPriceRowDays : function(element) {
		var row = $(element).getParent().getParent();
		var fakes = row.getElements('input[name^=fake]');
		var check = this.fakesCheck(element);
		for ( var i = 0; i < fakes.length; i++) {
			ACommon.setCheck(fakes[i], check);
		}
		this.setCheck(element);
	},
	checkPriceColDays : function(element, day) {
		var fakes = this.getFakes();
		var check = this.fakesCheck(element);
		for ( var i = (6 + day); i < fakes.length; i += 7) {
			ACommon.setCheck(fakes[i], check);
		}
		this.setCheck(element);
	},
	checkPriceAllDays : function(element) {
		var fakes = this.getFakes();
		var check = this.fakesCheck(element);
		for ( var i = 7; i < fakes.length; i++) {
			ACommon.setCheck(fakes[i], check);
		}
		this.setCheck(element);
	},
	getFakes : function() {
		return $('tprices').getElements('input[name^=fake]');
	},
	fakesCheck : function(element) {
		return element.className == 'checkall';
	},
	setCheck : function(element) {
		element.className = ((element.className == 'checkall') ? 'uncheckall'
				: 'checkall');
	},
	setRLimit : function() {
		if (!$('rlimit_set').checked)
			$('rlimit_count').value = $('rlimit_days').value = '';
		$('rlimit_box').style.display = $('rlimit_set').checked ? 'block'
				: 'none';
	},

	/**
	 * Add supplement row.
	 */
	addSupplement : function() {
		/* copy default mask row */
		var clone = $('supplement').clone().inject('tsupplements');
		/* set as visible */
		clone.style.display = '';
		/* remove element ID - no duplicity */
		clone.removeProperty('id');
		/* get all chidrens as elements array */
		var children = clone.getChildren();
		/* prepare new row inptus */
		var element = clone.getElement('select[name^=supplements-type]');
		element.className = 'notify';
		var ttl = $('tsupplements').getElements('input[name^=supplements-title]');
		var max = 0;
		for (var j = 0; j < ttl.length; j++) { 
			var match = ttl[j].name.match(/(\d+)/); // search fo array index in field name 
			if (match != null) { var int = match[0].toInt(); if (int > max) max = int; } // save index if is the highest
		}
		var next = max + 1; // new index
		var match = clone.innerHTML.match(/(supplements\-\w+)\[\]/g); // all supplement form fields names
		for (var j = 0; j < match.length; j++) clone.getElement('*[name^=' + match[j] + ']').name = match[j].replace(/\[\]/, '['+next+']'); // update index
		this.setEmptySupplement(false);
		this.setSupplementType(element);
		this.prepareSupplementsOrdering(); // completely reset
		var empty = $('supplement-empty'); $('tsupplements').removeChild(empty); empty.inject('tsupplements'); // move empty row at the end (cut and inject again)
	},

	/**
	 * Set visibilaty of empty row of supplements with information about
	 * creating supplements.
	 */
	setEmptySupplement : function(display) {
		$('supplement-empty').style.display = display ? ''
				: 'none';
	},

	/**
	 * Remove supplements rows.
	 */
	removeSupplements : function() {
		if (ACommon.removeRows('tsupplements', 'scid'))
			this.setEmptySupplement(true);
		this.prepareSupplementsOrdering(); // completely reset
	},

	setSupplementType : function(element, allEnable) {
		var row = $(element).getParent().getParent();
		var title = row.getElement('input[name^=supplements-title]');
		var description = row
				.getElement('textarea[name^=supplements-description]');
		var empty = row.getElement('input[name^=fake]');
		var options = row.getElement('textarea[name^=supplements-options]');
		var paid = row.getElement('select[name^=supplements-paid]');
		if (element.value == '0')
			paid.value = '0';
		supplementType = allEnable == true ? '1' : element.value;
		this.setSupplementPaid(paid, allEnable);
		switch (supplementType) {
		case '1':
			/* list */
			title.disabled = description.disabled = options.disabled = empty.disabled = paid.disabled = false;
			element.className = '';
			break;
		case '2':
			/* yes/no */
			title.disabled = description.disabled = empty.checked = paid.disabled = false;
			options.disabled = empty.disabled = true;
			options.value = element.className = '';
			break;
		default:
			/* no select */
			title.disabled = description.disabled = options.disabled = paid.disabled = empty.disabled = true;
			empty.checked = false;
			title.value = description.value = options.value = '';
			element.className = 'notify';
			break;
		}
	},

	/**
	 * Sel supplement price input box.
	 * 
	 * @param element
	 * @param submit
	 */
	setSupplementPaid : function(element, submit) {
		var col = $(element).getParent();
		var price1 = col.getElement('textarea[name^=supplements-price]');
		var price2 = col.getElement('input[name^=supplements-price]');
		switch (element.value) {
		case '0':
			// free
			price1.style.display = price2.style.display = 'none';
			price1.value = price2.value = '';
			if (submit == true)
				col.removeChild(price1);
			break;
		case '1':
			// one price
			price2.style.display = 'block';
			price1.value = '';
			price1.style.display = 'none';
			if (submit == true)
				col.removeChild(price1);
			break;
		case '2':
			// more prices
			price1.style.display = 'block';
			price2.value = '';
			price2.style.display = 'none';
			if (submit == true)
				col.removeChild(price2);
			break;
		}
	},

	/**
	 * Prepare saved supplements displaying.
	 */
	prepareSupplements : function(allEnable) {
		var elements = $('tsupplements').getElements(
				'select[name^=supplements-type]');
		for ( var i = 0; i < elements.length; i++) {
			this.setSupplementType(elements[i], allEnable);
		}
	},

	/**
	 * Valid form before submit. Standard in Joomla! administration.
	 * 
	 * @param pressbutton
	 *            button selected in toolbar
	 */

	submitbutton : function(pressbutton) {
		switch (pressbutton) {
		case 'cancel':
		case 'copy':
			submitform(pressbutton);
			return;
		case 'apply':
			ACommon.saveBookmark();
			break;
		}
		if (!ACommon.validDateTimeInterval('publishUp', 'publishDown', LGErrPublishIntervalInvalid)) {
			return false;
		}
		if (!ACommon.validMultiParam('input', 'rtype-title',
				LGErrAddReservationTypesTitles, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('select', 'rtype-type',
				LGErrSelectsDefaultTypesReservationTypes, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('input', 'rtype-time_unit',
				LGErrAddTimeUnit, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('input', 'price-value',
				LGErrAddPricesValues, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('select', 'price-rezervation_type',
				LGErrSelectPricesReservationTypes, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('input', 'price-date_up',
				LGErrAddPricesDates, true)
				|| !ACommon.validMultiParam('input', 'price-date_down',
						LGErrAddPricesDates, true)) {
			return false;
		}
		if (!ACommon.validDateTimeInterval('price-date_up', 'price-date_down', LGErrPriceDateIntervalInvalid, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('input', 'price-time_up',
				LGErrAddPricesTimes, true)
				|| !ACommon.validMultiParam('input', 'price-time_down',
						LGErrAddPricesTimes, true)) {
			return false;
		}
		if (!ACommon.validDateTimeInterval('price-time_up', 'price-time_down', LGErrPriceTimeIntervalInvalid, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('input', 'supplements-title',
				LGErrAddSupplementsTitles, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('select', 'supplements-type',
				LGErrSelectSupplementsTypes, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('textarea', 'supplements-options',
				LGErrSelectSupplementsOptions, true)) {
			return false;
		}
		if (!ACommon.validMultiParam('textarea|input', 'supplements-price',
				LGErrAddSupplementsPrice, true)) {
			return false;
		}
		var form = ACommon.getForm();
		var cid = document.getElementById('cid').value;
		if (trim(form.title.value) == '') {
			alert(LGErrAddSubjectTitle);
		} else if (trim(form.total_capacity.value) == ''
				|| !AValidator.isInt(form.total_capacity.value)) {
			alert(LGErrTotalCapacityNoNumeric);
		} else if ((this.isSetSaveAsNewTemplate() && (trim(form.new_template_name.value) == '' || trim(form.new_template_name.value) == TemplateNameMask))
				|| ((this.isSetRenameTemplate() && trim(form.template_rename.value) == ''))) {
			alert(LGErrAddSubjectTemplate);
		} else if (!this.isSetSaveAsNewTemplate() && form.template.value == '0') {
			alert(LGErrAddSubjectTemplate);
		} else if (cid != '0' && cid == form.parent.value) {
			alert(LGErrSelfAsParent);
		} else if ($('rlimit_set').checked
				&& ($('rlimit_count').value == '' || $('rlimit_days').value == '')) {
			alert(LGErrAddRLimit);
		} else if ($('use_fix_shedule').checked && (trim(form.shedule_from.value) == '' || trim(form.shedule_to.value) == '')) { 
			alert(LGErrAddFixedScheduleFromTo);
		} else if ($('night_booking').checked && (trim(form.night_booking_from.value) == '' || trim(form.night_booking_to.value) == '')) { 
			alert(LGErrAddNightsBookingCheckInCheckOut);
		} else {
			this.preparePrices(true);
			this.prepareReservationTypes(true);
			this.prepareSupplements(true);
			submitform(pressbutton);
		}
	},
	
	/**
	 * Prepare supplements ordering at object edit page.
	 */
	prepareSupplementsOrdering : function(){
		if (!$('tsupplements'))
			return;
		var up = $('tsupplements').getElements('span[class^=up]'); // arrows to move supplements up
		var down = $('tsupplements').getElements('span[class^=down]'); // arrows to move supplements down
		var ordering = 1;
		for (var i = 0; i < up.length; i++) { // for each set onclick event
			if (i > 1) { // only for second row (first is hidden)
				up[i].style.display = '';
				up[i].removeEvents(); // reset
				up[i].addEvent('click', function() {
					var tr = this.getParent().getParent(); // table row contains arrow
					var previous = tr.getPrevious(); // previous row
					var rows = $('tsupplements').getElements('tr'); // all rows in table
					for (var i = 0; i < rows.length; i++) $('tsupplements').removeChild(rows[i]); // remove all rows
					for (var i = 0; i < rows.length; i++) { // append rows again in new ordering
						if (previous == rows[i]) {
							tr.inject('tsupplements'); previous.inject('tsupplements'); // swap current and previous row
							i ++; // next step is satisfied
						} else rows[i].inject('tsupplements'); // others append in old ordering
					}
					EditSubject.prepareSupplementsOrdering(); // completely reset
				});
			} else up[i].style.display = 'none'; // second hasn't move up tool
			up[i].getParent().getElement('input[type^=hidden]').value = ordering++;
		}
		for (var i = 0; i < down.length; i++) { // for each set onclick event
			if (i < down.length - 1) { // only for non last rows
				down[i].style.display = ''; // visible
				down[i].removeEvents(); // reset
				down[i].addEvent('click', function() {
					var tr = this.getParent().getParent(); // table row contains arrow 
					var next = tr.getNext(); // next row
					var rows = $('tsupplements').getElements('tr'); // all rows in table
					for (var i = 0; i < rows.length; i++) $('tsupplements').removeChild(rows[i]); // remove all rows
					for (var i = 0; i < rows.length; i++) { // append rows again in new ordering
						if (tr == rows[i]) { 
							next.inject('tsupplements'); tr.inject('tsupplements'); // swap current and next row
							i ++; // next step is satisfied
						} else rows[i].inject('tsupplements'); // others append in old ordering
					}
					EditSubject.prepareSupplementsOrdering(); // completely reset
				});
			} else down[i].style.display = 'none'; // last hasn't move down tool
		}
	},
	
	prepareGoogleMaps : function() {
		$('google_maps').addEvent('change', function() { EditSubject.prepareGoogleMaps(); } );
		switch ($('google_maps').value){
			default:
			case 'off':
				$('google_maps_address').disabled = true;
				$('google_maps_display').disabled = true;
				$('google_maps_width').disabled = true;
				$('google_maps_heigth').disabled = true;
				$('google_maps_zoom').disabled = true;
				$('google_maps_code').disabled = true;
				break;
			case 'address':
				$('google_maps_address').disabled = false;
				$('google_maps_display').disabled = false;
				$('google_maps_width').disabled = false;
				$('google_maps_heigth').disabled = false;
				$('google_maps_zoom').disabled = false;
				$('google_maps_code').disabled = true;
				break;
			case 'code':
				$('google_maps_address').disabled = true;
				$('google_maps_display').disabled = false;
				$('google_maps_width').disabled = true;
				$('google_maps_heigth').disabled = true;
				$('google_maps_zoom').disabled = true;
				$('google_maps_code').disabled = false;
				break;
		}
	}
};

function submitbutton(pressbutton) {
	return EditSubject.submitbutton(pressbutton);
}

// startup events
window.addEvent('domready', function() {
	EditSubject.preparePrices();
	EditSubject.prepareReservationTypes();
	EditSubject.prepareSupplementsOrdering();
});