<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

ob_clean();

$this->days = &BookingHelper::getDailyCalendar($this->subject, ($this->setting = new BookingCalendarSetting()), false);

$day = reset($this->days->calendar);
/* @var $day BookingDay */
	$option = 20; // number 20 should be configurable by user
	$columns = ($option%2) == 0 ? $option : $option--; // option has to be even number because of design - new row has to start with odd number

	$j = 1;
	foreach ($day->boxes as $i => $box) {
		if (($j % 20) == 1) {
			if ($j != 1) {
				echo '</tr></table>';
			}
			echo '<table><tr class="sectiontableentry1">';
		}
		/* @var $box BookingTimeBox */
		$service = reset($box->services);
		/* @var $service BookingService */
		if ($service->canReserve && !$box->closed) {
			echo '<td><a href="javascript:QuickBook.book(\''.$service->id.'\', \''.$service->idShort.'\');" id="'.$service->idShort.'">'.BookingHelper::displayTime($box->fromTime).'</a></td>';	
		} elseif ($box->closed) {
			echo '<td class="hasTip" title="'.$this->escape($box->closingDayTitle).'::'.$this->escape($box->closignDayText).'"><span>'.BookingHelper::displayTime($box->fromTime).'</span></td>';
		} else {
			echo '<td><span>'.BookingHelper::displayTime($box->fromTime).'</span></td>'; 
		}
		$j++;
	}
	echo '</tr></table>';
?>
<?php die(); ?>