<?php

/**
 * Reservation edit form template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewReservation */

JHTML::_('behavior.tooltip');

$titleSave = $this->escape(JText::_('Save reservation'));
$titleContinue = $this->escape(JText::_('Save continue'));
$titleErase = $this->escape(JText::_('Reset reservation'));
$titleStorno = $this->escape(JText::_('Back'));

$config = &AFactory::getConfig();
$document = &JFactory::getDocument();
/* @var $document JDocument */
$user = JFactory::getUser();

if (JFactory::getApplication()->getUserState('com_booking.object.last'))
	$backUrl = JFactory::getApplication()->getUserState('com_booking.object.last');
elseif (count($this->reservedItems)){ //if no relevant refereer (like from iframe add)
	$newItemSubject = $this->subjects[end($this->reservedItems)->subject];
	$backUrl = JRoute::_(ARoute::view(VIEW_SUBJECT, $newItemSubject->id, $newItemSubject->alias));
}
else
	$backUrl = JRoute::_(ARoute::view(VIEW_SUBJECTS));
	
$canContinue = ($user->guest && $config->allowReservations) || $user->id;

?>

<h1><?php echo JText::_('Reservation'); ?></h1>
<?php 
	if (empty($this->reservedItems)) { 
?>
    	<p><?php echo JText::_('You have no items to reserve.'); ?></p>
<?php 
    	return;
	}
?>
<form action="index.php" method="post" name="adminForm" id="adminForm" class="reservation">	
    <?php if ($canContinue) { ?>
	    <div class="bookingToolbar">
			<a class="aIconToolSave tool save" title="<?php echo $titleSave; ?>" href="javascript:submitbutton('save')" ><?php echo $titleSave; ?></a>
			<?php if($config->moreReservations){?><a class="aIconToolApply tool save" title="<?php echo $titleContinue; ?>" href="javascript:submitbutton('store')" ><?php echo $titleContinue; ?></a><?php }?>
			<a class="aIconToolRestore tool cancel" title="<?php echo $titleStorno; ?>" href="<?php echo $backUrl; ?>"><?php echo $titleStorno; ?></a>
			<a class="aIconToolCancel tool cancel" title="<?php echo $titleErase; ?>" href="javascript:submitbutton('erase')" ><?php echo $titleErase; ?></a>
			<div class="clr"></div>
		</div>
	<?php } ?>
	<?php if (!$canContinue) { ?>
		<div class="customer">
			<fieldset class="radio">
	    		<legend><?php echo JText::_('Customer'); ?></legend>
	    		<p>
	    			<input type="radio" name="customer" id="bookign_customer_login" autocomplete="off" />
	    			<label for="bookign_customer_login"><?php echo JText::_('Returning Customers: Please Log In'); ?></label>
	    		</p>
	    		<?php if ($config->enableRegistration) { ?>
	    			<p>
	    				<input type="radio" name="customer" id="booking_customer_register" autocomplete="off" />
	    				<label for="booking_customer_register"><?php echo JText::_('New? Please Register'); ?></label>
	    			</p>
	    		<?php } ?>
	    		<table id="booking_customer_loginform" style="display: none">
	    			<tr>
	    				<td>
	    					<label for="booking_customer_username"><?php echo JText::_('Username'); ?></label>
	    				</td>
	    				<td>
	    					<input type="text" name="booking_customer_username" id="booking_customer_username" value="" />
	    				</td>
	    			</tr>
	    			<tr>
	    				<td>
	    					<label for="booking_customer_password"><?php echo JText::_('Password'); ?></label>
	    				</td>
	    				<td>
	    					<input type="password" name="booking_customer_password" id="booking_customer_password" value="" />
	    				</td>
	    			</tr>
	    			<tr>
	    				<td colspan="2">
							<button id="booking_login_submit"><?php echo JText::_('Login'); ?></button>	    
							<script type="text/javascript">
								// <![CDATA[
								window.addEvent('domready', function() {
									$('bookign_customer_login').addEvent('click', function() {
										$('booking_customer_loginform').setStyle('display', '');
									});
									$('booking_login_submit').addEvent('click', function() { 
										if ($('booking_customer_username').value.trim() == '' || $('booking_customer_password').value.trim() == '')
											alert("<?php echo JText::_('Add username and password', true); ?>");
										else
											new Request({
									    		url: '<?php echo JURI::root(); ?>index.php?option=com_booking&controller=user&task=login',
									    		method: 'post',
									    		data: {
													'username': $('booking_customer_username').value,
													'password': $('booking_customer_password').value
									    		},
									    		onSuccess: function(html) {
									        		html == 'OK' ? location.reload() : alert("<?php echo JText::_('E_LOGIN_AUTHENTICATE', true); ?>");
									    		}
									    	}).send();
										return false;
									});
									<?php if ($config->enableRegistration) { ?>
										$('booking_customer_register').addEvent('click', function() { 
											window.location.href = "<?php echo JRoute::_('index.php?option=com_booking&controller=customer&task=edit&return=reservation', false); ?>";
										});
									<?php } ?>
									<?php if (!$config->enableRegistration) { ?>
										$('bookign_customer_login').fireEvent('click').checked = true;	
									<?php } ?>
								});
								// ]]>
							</script>				
	    				</td>
	    			</tr>
	    		</table>
	    	</fieldset>
	    </div>
	<?php } ?>
	<?php if ($canContinue && ($config->rsTitleBefore || $config->rsFirstname || $config->rsMiddlename || $config->rsSurname || $config->rsTitleAfter || $config->rsCompany || $config->rsExtra)) { ?>
		<div class="customer">
			<fieldset>
	    		<legend><?php echo JText::_('Customer'); ?></legend>
	    		<table>
	    			<?php 
	    				if ($config->rsTitleBefore) { 
	    			?>
			    			<tr>
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsTitleBefore', 'title_before', 'Title before'); ?></td>
			    				<td><input class="text_area" type="text" name="title_before" id="title_before" size="60" maxlength="255" value="<?php echo $this->reservation->title_before; ?>" /></td>
			    			</tr>
	    			<?php
	    				}
	    				if ($config->rsFirstname) { 
	    			?>
			    			<tr>
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsFirstname', 'firstname', 'First name'); ?></td>
			    				<td><input class="text_area" type="text" name="firstname" id="firstname" size="60" maxlength="255" value="<?php echo $this->reservation->firstname; ?>" /></td>
			    			</tr>
	    			<?php
	    				}
	    				if ($config->rsMiddlename) { 
	    			?>
			    			<tr>
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsMiddlename', 'middlename', 'Middle name'); ?></td>
			    				<td><input class="text_area" type="text" name="middlename" id="middlename" size="60" maxlength="255" value="<?php echo $this->reservation->middlename; ?>" /></td>
			    			</tr>
	    			<?php
	    				}
	    				if ($config->rsSurname) { 
	    			?>
			    			<tr>
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsSurname', 'surname', 'Surname'); ?></td>
			    				<td><input class="text_area" type="text" name="surname" id="surname" size="60" maxlength="255" value="<?php echo $this->reservation->surname; ?>" /></td>
			    			</tr>
	    			<?php
	    				}
	    				if ($config->rsTitleAfter) { 
	    			?>
			    			<tr>
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsTitleAfter', 'title_after', 'Title after'); ?></td>
			    				<td><input class="text_area" type="text" name="title_after" id="title_after" size="60" maxlength="255" value="<?php echo $this->reservation->title_after; ?>" /></td>
			    			</tr>
	    			<?php
	    				}
	    				if ($config->rsCompany) { 
	    			?>
			    			<tr>
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsCompany', 'company', 'Company'); ?></td>
			    				<td><input class="text_area" type="text" name="company" id="company" size="60" maxlength="255" value="<?php echo $this->reservation->company; ?>" /></td>
			    			</tr>
	    			<?php 
	    				}
	    				if ($config->rsCompanyId) {
	    			?>
    						<tr>
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsCompanyId', 'company_id', 'Company ID'); ?></td>
			    				<td><input class="text_area" type="text" name="company_id" id="company_id" size="20" maxlength="255" value="<?php echo $this->reservation->company_id; ?>" /></td>
			    			</tr>
	    			<?php 
	    				}
	    				if ($config->rsVatId) {
   					?>
			    			<tr>
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsVatId', 'vat_id', 'Vat ID'); ?></td>
			    				<td><input class="text_area" type="text" name="vat_id" id="vat_id" size="20" maxlength="255" value="<?php echo $this->reservation->vat_id; ?>" /></td>
			    			</tr>
	    			<?php 
	    				}	    					    				
	    				if(is_array($config->rsExtra))
	    				{
		    				foreach ($config->rsExtra as $field) {
		    			?>
		    					<tr>
				    				<td class="key"><?php echo AHtml::displayLabel($document, $field['required'] == 2, $field['name'], $field['name'], $field['title']); ?></td>
				    				<td><input class="text_area" type="text" name="<?php echo $field['name']; ?>" id="<?php echo $field['name']; ?>" size="60" maxlength="255" value="<?php echo AUtils::getArrayValue($this->reservation->fields, $field['name'] . '.value'); ?>" /></td>
				    			</tr>
			    	<?php }
			    		}?>
	    		</table>
	    	</fieldset>
	    	<div class="clr">&nbsp;</div>
	    </div>
    <?php 
		}
		$z=0;
		$countReservedItems = count($this->reservedItems);
    	if ($canContinue && $countReservedItems)
    		foreach ($this->reservedItems as $reservedItem){
				$id = $z++;
				$subject = $this->subjects[$reservedItem->subject];
				$capacity = $subject->display_capacity || $subject->total_capacity>1 || $reservedItem->capacity>1; //display capacity row
				$fullPrice = $reservedItem->fullPrice!=$reservedItem->price; //display full price
				$fullDeposit = $reservedItem->fullDeposit!=$reservedItem->deposit; //display full deposit
				$fullPriceSupplements = $reservedItem->fullPrice!=$reservedItem->fullPriceSupplements; //display full price with supplements
				$rows = 4 + count($reservedItem->supplements) + ($reservedItem->fullDeposit ? 1 : 0); //no of rows
		
	?>
    <div class="reservation">
    	<fieldset>
    		<legend><?php if ($countReservedItems>1) echo '#'.($id+1).' '?><?php echo JText::_('Reservation'); ?></legend>
    		<table class="reserved_item">
    			<tr>
    				<td class="key"><?php echo JText::_('Subject'); ?>: </td>
    				<td colspan="5">
    					<a href="<?php echo JRoute::_(ARoute::view(VIEW_SUBJECT, $subject->id, $subject->alias)); ?>" title="<?php echo $this->escape(JText::sprintf('Display subject %s', $subject->title)); ?>">
    						<?php echo $subject->title . ' / ' . $reservedItem->box->rtypeTitle; ?>
    					</a>
    				</td>
    				<?php if (isset($reservedItem->key)) { ?>
    				<td rowspan="<?php echo $rows ?>" valign="top" width="18">
    					<a href="<?php echo JRoute::_(ARoute::customUrl(array('key' => $reservedItem->key)).ARoute::controller(CONTROLLER_RESERVATION).ARoute::task('remove_item')); ?>">
    						<img src="<?php echo IMAGES?>icon-16-cancel.png" title="<?php echo JText::_('Remove item')?>" alt="<?php echo JText::_('Remove item')?>" border="0">
    					</a>
    				</td>
    				<?php } ?>
    			</tr>
    			
    			<?php 
    				if (is_object($reservedItem->box)) {
    					
    					$capacity=false;
    					if ($subject->display_capacity || $subject->total_capacity>1) {
    						$capacity=true;
    						$max = $subject->total_capacity-$reservedItem->box->maxReserved;
    			?>
	    				<tr>	
							<td class="key"><label for="capacity[<?php echo $id?>]" class="compulsory"><?php echo JText::_('Capacity'); ?>: </label></td>
			    			<td colspan="5">
			    				<?php if ($max>1) { ?>
				    				<?php if ($max<=100) { ?>
				    				<select class="capacity" name="capacity[<?php echo $id?>]" id="capacity[<?php echo $id?>]" onchange="submitbutton('store')">
				    					<?php for ($i = 1; $i <= $max; $i++) { ?>
				    						<option value="<?php echo $i; ?>" <?php if ($i == $reservedItem->capacity) { ?>selected="selected"<?php } ?>><?php echo $i; ?></option>
				    					<?php } ?>
				    				</select>
				    				<?php } else { ?>
				    					<input class="capacity" name="capacity[<?php echo $id?>]" id="capacity[<?php echo $id?>]" value="<?php echo $reservedItem->capacity; ?>">
				    					<input class="capacity" type="button" value="<?php echo JText::_('Refresh')?>" onclick="submitbutton('store')">
				    				<?php } ?>
			    				<?php  } else { ?>
			    				1
			    				<?php  } ?>
			    				<strong class="hasTip" title="<?php echo JText::_('Total capacity')?>::<?php echo JText::_('Total capacity info')?>"><?php echo JText::_('Total capacity'); ?>: </strong>
			    				<span><?php echo $subject->total_capacity; ?></span>
			    				<?php if ($subject->minimum_capacity) { ?>
			    				<strong class="hasTip" title="<?php echo JText::_('Minimum capacity')?>::<?php echo JText::_('Minimum capacity info')?>"><?php echo JText::_('Minimal capacity'); ?>: </strong>
			    				<span><?php echo $subject->minimum_capacity; ?></span>
			    				<?php } ?>
			    				<?php if ($reservedItem->box->maxReserved || $subject->minimum_capacity) { ?>
			    				<strong class="hasTip" title="<?php echo JText::_('Booked in interval')?>::<?php echo JText::_('Booked in interval info')?>"><?php echo JText::_('Booked in interval'); ?>: </strong>
			    				<span><?php 
			    				echo $reservedItem->box->minReserved;
			    				if ($reservedItem->box->maxReserved!=$reservedItem->box->minReserved)
			    					echo ' - '.$reservedItem->box->maxReserved;
			    				?></span>	
			    				<?php } ?>
			    			</td>
			    		</tr>
		    	<?php 
    				}
    			?>
    			
    					<?php if ($reservedItem->ctype == CTYPE_PERIOD) { ?>
    						<tr>
    							<td class="key"><?php echo JText::_('Timeframe'); ?></td>
    							<td><?php echo AHtml::showRecurenceTimeframe($reservedItem); ?></td>
    						</tr>
    						<tr>
    							<td class="key"><?php echo JText::_('Recurrence Pattern'); ?></td>
    							<td><?php echo AHtml::showRecurencePattern($reservedItem); ?></td>
    						</tr>
    						<tr>
    							<td class="key"><?php echo JText::_('Range of Recurrence'); ?></td>
    							<td><?php echo AHtml::showRecurenceRange($reservedItem); ?></td>
    						</tr>
    						<tr>
    							<td class="key"><?php echo JText::_('Recurrence Total'); ?></td>
    							<td><?php echo $reservedItem->period_total; ?></td>
    						</tr>
    					<?php } else { ?>
		    				<tr>	
		    					<td class="key"><?php echo AHtml::intervalLabel($reservedItem); ?>: </td>
		    					<td><?php echo AHtml::interval($reservedItem); ?></td>
		    				</tr>
		    			<?php } ?>
		    			
				    	<?php foreach ($reservedItem->supplements as $supplement) { ?>
		    			<?php /* @var $supplement TableSupplement */ ?>
						
		    					<tr>
		    						<td class="key hasTip" title="<?php echo BookingHelper::displaySupplementTooltip($supplement); ?>"><?php echo $supplement->title; ?>: </td>
			    					<td>
			    					<?php echo BookingHelper::displaySupplementValue($supplement); ?>
			    					
		    						<?php if ($supplement->capacity_multiply==2) {?>
		    							<?php echo JText::_('Capacity') ?>: 
		    							<?php if ($supplement->capacity_max && $supplement->capacity_max<=100) { ?>
					    				<select class="capacity" name="supplements[<?php echo $id?>][<?php echo $supplement->id; ?>][1]" onchange="submitbutton('store')">
					    					<?php for ($i = 1; $i <= $supplement->capacity_max; $i++) { ?>
					    						<option value="<?php echo $i; ?>" <?php if ($i == $supplement->capacity) { ?>selected="selected"<?php } ?>><?php echo $i; ?></option>
					    					<?php } ?>
					    				</select>
					    				<?php } else { ?>
					    					<input size="5" class="capacity" name="supplements[<?php echo $id?>][<?php echo $supplement->id; ?>][1]" value="<?php echo $supplement->capacity; ?>">
											<input class="capacity" type="button" value="<?php echo JText::_('Refresh')?>" onclick="submitbutton('store')">
					    				<?php } ?>
										<?php if ($supplement->capacity_max){ ?>
											(<?php echo JText::_('Maximal')?>: <?php echo $supplement->capacity_max ?>)
										<?php } ?>
		    						<?php } else { ?>
		    							<input type="hidden" name="supplements[<?php echo $id?>][<?php echo $supplement->id; ?>][1]" value="<?php echo $this->escape($supplement->capacity); ?>" />
		    						<?php } ?>
			    					<input type="hidden" name="supplements[<?php echo $id?>][<?php echo $supplement->id; ?>][0]" value="<?php echo $this->escape($supplement->value); ?>" />
			    					</td>
		    					</tr>
						<?php } ?>   
				
		    			<tr>	
		    				<td class="key"><?php echo ITEM_PRICE_TIP ?></td>
		    				<td>
			    				<?php 
			    					echo '<strong class="value">' . BookingHelper::displayPrice($reservedItem->price) . '</strong>';
		    						if ($fullPrice){ 
		    							echo '<strong class="title">' . FULL_PRICE_TIP . '</strong>';
			    						echo '<strong class="value">' . BookingHelper::displayPrice($reservedItem->fullPrice) . '</strong>';
		    						}
			   						if ($fullPriceSupplements) {
			   							echo '<strong class="title">' . FULL_PRICE_SUPPLEMENTS_TIP . '</strong>';
			    						echo '<strong class="value">' . BookingHelper::displayPrice($reservedItem->fullPriceSupplements) . '</strong>';
			    					}
			    				?>
			    			</td>
			    		</tr>	
			    		<?php if ($reservedItem->fullDeposit) { ?>
		    				<tr>	
		    					<td class="key"><?php echo ITEM_DEPOSIT_TIP; ?></td>
		    					<td>
		    						<?php
		    							echo '<strong class="value">' . BookingHelper::displayPrice($reservedItem->deposit) . '</strong>';
		    							if ($fullDeposit) {
		    								echo '<strong class="title">' . FULL_DEPOSIT_TIP . '</strong>';
		    								echo '<strong class="value">' . BookingHelper::displayPrice($reservedItem->fullDeposit) . '</strong>';
		    							}
		    							echo '<strong class="title">' . BookingHelper::showTax($reservedItem->tax) . ':</strong>';
		   								echo '<strong class="value">' . BookingHelper::displayPrice(BookingHelper::getTax($reservedItem->fullPriceSupplements, $reservedItem->tax)) . '</strong>';
		   						 	?>
		   						</td>
		   					</tr>
    					<?php } else { ?>
    						<tr>
		    					<td class="key"><?php echo BookingHelper::showTax($reservedItem->tax); ?>:</td>
		    					<td>
									<?php echo BookingHelper::displayPrice(BookingHelper::getTax($reservedItem->fullPriceSupplements, $reservedItem->tax)); ?>
								</td>    						
    						</tr>
		    		<?php	
    						} 
    						?>
    						<?php if (($countReservedItems == 1) && ($reservedItem->cancel_time !== null)) {?>
				    		<tr>
						    	<td class="key"><?php echo JText::_('Deposit must be paid before'); ?>: </td>
								<td><strong><?php echo BookingHelper::formatExpiration($reservedItem->cancel_time,$reservedItem->from); ?></strong></td>				
				    		</tr>
    						<?php
    						}
    						?>
    						<tr>	
			    				<td class="key"><?php echo '<label for="message[' . $id . ']">' . JText::_('Message') . ': </label>'; ?></td>
			    				<td><input class="text_area" type="text" name="message[<?php echo $id;?>]" id="message" size="60" maxlength="255" value="" /></td>
			    			</tr>
    			<?php 
    					}
    				?> 
 
    			</table>
    			
    			<?php foreach ($reservedItem->boxIds as $bid) { ?>
				<input type="hidden" name="boxIds[<?php echo $id?>][]" value="<?php echo $bid; ?>" />
				<?php } ?>

				<input type="hidden" name="ctype[<?php echo $id?>]" value="<?php echo $reservedItem->ctype; ?>" />
				<input type="hidden" name="subject[<?php echo $id?>]" value="<?php echo $reservedItem->subject; ?>" />
				<?php if ($reservedItem->ctype == CTYPE_PERIOD) { ?>
					<input type="hidden" name="period_rtype_id[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_rtype_id); ?>" />
					<input type="hidden" name="period_price_id[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_price_id); ?>" />
					<input type="hidden" name="period_time_up[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_time_up); ?>" />
    				<input type="hidden" name="period_time_down[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_time_down); ?>" />
    				<input type="hidden" name="period_type[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_type); ?>" />
    				<input type="hidden" name="period_recurrence[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_recurrence); ?>" />
    				<input type="hidden" name="period_monday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_monday); ?>" />
    				<input type="hidden" name="period_tuesday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_tuesday); ?>" />
    				<input type="hidden" name="period_wednesday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_wednesday); ?>" />
    				<input type="hidden" name="period_thursday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_thursday); ?>" />
    				<input type="hidden" name="period_friday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_friday); ?>" />
    				<input type="hidden" name="period_saturday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_saturday); ?>" />
    				<input type="hidden" name="period_sunday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_sunday); ?>" />
    				<input type="hidden" name="period_month[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_month); ?>" />
					<input type="hidden" name="period_week[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_week); ?>" />
					<input type="hidden" name="period_day[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_day); ?>" />    				
    				<input type="hidden" name="period_date_up[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_date_up); ?>" />
    				<input type="hidden" name="period_end[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_end); ?>" />
    				<input type="hidden" name="period_occurrences[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_occurrences); ?>" />
    				<input type="hidden" name="period_date_down[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_date_down); ?>" />
				<?php } ?>
    		</fieldset>
    		<div class="clr">&nbsp;</div>
    	</div>
<?php  } ?>

<?php if ($countReservedItems>1 && $canContinue) { ?>    	
    <div class="reservation">
    	<fieldset>
    		<legend><?php echo JText::_('Payment'); ?></legend>
    		<table>
    			<tr>
    				<td class="key"><?php echo JText::_('Total Price'); ?>: </td>
    				<td><strong><?php echo BookingHelper::displayPrice($this->reservation->fullPrice); ?></strong></td>
    			</tr>
    			<tr>
		    		<td class="key"><?php echo JText::_('Tax'); ?>: </td>
					<td><strong><?php echo BookingHelper::displayPrice(BookingHelper::getFullTax($this->reservedItems)); ?></strong></td>				
    			</tr>
    			<?php if ($this->reservation->fullDeposit) {?>
    			<tr>
    				<td class="key"><?php echo JText::_('Deposit'); ?>: </td>
    				<td><strong><?php echo BookingHelper::displayPrice($this->reservation->fullDeposit); ?></strong></td>
    			</tr>
    			<?php } ?>
    			<tr>
			    	<td class="key"><?php echo JText::_('Deposit must be paid before'); ?>: </td>
					<td><strong><?php echo $this->depositExpires; ?></strong></td>				
	    		</tr>
    		</table>
    	</fieldset>
   	</div>
<?php } ?>

<?php
    	if ($canContinue && // test if one them is turn on
    		($config->rsNote // note
    		|| 
    		($config->useCaptcha && ! $this->customer->id) // captcha and customer is unregistered 
    		|| 
    		(isset($this->payments) && count($this->payments)) // at least one payment method
    	)) {	
    ?>
	   	<div>
	   		<fieldset class="radio">
	   		<legend><?php echo JText::_('Payment Method'); ?></legend>
	    		<table>
	    			<?php 
	    					    			?>
	    		</table>
	    	</fieldset>
	    </div>
    <?php 
    	}
    ?>

<?php	if ($canContinue && ($config->rsStreet || $config->rsCity || $config->rsZip || $config->rsCountry || $config->rsEmail || $config->rsTelephone || $config->rsFax)) { ?>
	    <div class="contact">
	    	<fieldset>
	    		<legend><?php echo JText::_('Reservation Contact'); ?></legend>
	    		<table>
	    			<?php
	    				if ($config->rsStreet) { 
	    			?>
			    			<tr>	
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsStreet', 'street', 'Street'); ?></td>
			    				<td><input class="text_area" type="text" name="street" id="street" size="60" maxlength="255" value="<?php echo $this->reservation->street; ?>" /></td>
			    			</tr>
	    			<?php
	    				}
	    				if ($config->rsCity) { 
	    			?>
			    			<tr>	
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsCity', 'city', 'City'); ?></td>
			    				<td><input class="text_area" type="text" name="city" id="city" size="60" maxlength="255" value="<?php echo $this->reservation->city; ?>" /></td>
			    			</tr>
	    			<?php
	    				} 
	    				if ($config->rsZip) { 
	    			?>
			    			<tr>	
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsZip', 'zip', 'Zip'); ?></td>
			    				<td><input class="text_area" type="text" name="zip" id="zip" size="60" maxlength="255" value="<?php echo $this->reservation->zip; ?>" /></td>
			    			</tr>
	    			<?php
	    				} 
	    				if ($config->rsCountry) { 
	    			?>
			    			<tr>	
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsCountry', 'country', 'Country'); ?></td>
			    				<td><input class="text_area" type="text" name="country" id="country" size="60" maxlength="255" value="<?php echo $this->reservation->country; ?>" /></td>
			    			</tr>
	    			<?php
	    				} 
	    				if ($config->rsEmail) { 
	    			?>
			    			<tr>	
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsEmail', 'email', 'Email'); ?></td>
			    				<td><input class="text_area" type="text" name="email" id="email" size="60" maxlength="255" value="<?php echo $this->reservation->email; ?>" /></td>
			    			</tr>
	    			<?php
	    				} 
	    				if ($config->rsTelephone) { 
	    			?>
			    			<tr>	
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsTelephone', 'telephone', 'Telephone'); ?></td>
			    				<td><input class="text_area" type="text" name="telephone" id="telephone" size="60" maxlength="255" value="<?php echo $this->reservation->telephone; ?>" /></td>
			    			</tr>
	    			<?php
	    				} 
	    				if ($config->rsFax) { 
	    			?>
			    			<tr>	
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsFax', 'fax', 'Fax'); ?></td>
			    				<td><input class="text_area" type="text" name="fax" id="fax" size="60" maxlength="255" value="<?php echo $this->reservation->fax; ?>" /></td>
			    			</tr>
	    			<?php 
	    				} 				
	    				if ($config->rsNote) {
	    			?>
			    			<tr>	
			    				<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsNote', 'note', 'Note'); ?></td>
			    				<td>
			    					<textarea name="note" id="note" cols="50" rows="10"><?php echo $this->reservation->note; ?></textarea>
			    				</td>
			    			</tr>
	    			<?php 
	    				}
	    				if ($config->useCaptcha && ! $this->customer->id) { 
	    			?>
			    			<tr>	
			    				<td class="key"><label for="fax" class="compulsory"><?php echo JText::_('Captcha'); ?>: </label></td>
			    				<td>
			    					<?php echo BookingHelper::captcha(); ?>
								</td>
			    			</tr>
	    			<?php 
	    				}
	    			?>
				</table>
	    	</fieldset>
	    	<div class="clr">&nbsp;</div>
	   	</div>
   	<?php 
    	} 
    	// last box with note, captcha, payment method and terms
    	if ($canContinue && // test if one them is turn on
			($config->terms_of_contract_accept || $config->terms_of_privacy_accept) // one of terms
    	) {	
    ?>
	   	<div>
	   		<fieldset>
	    		<table>
	    			<?php 
	    			if ($config->terms_of_contract_accept || $config->terms_of_privacy_accept) {
	    				JHTML::_('behavior.modal');
	    			?>
	    					<tr>
	    						<td></td>
	    						<td>
	    							
	    							<?php if ($config->terms_of_contract_accept) { ?>
	    								<label>
	    								<input type="checkbox" name="accept_terms_of_contract" id="accept_terms_of_contract" value="1">
	    								<?php echo JText::_('I accept')?> <a class="modal" href="#terms_of_contract"><?php echo $config->terms_of_contract->title; ?></a>.
	    								</label>
	    								
	    								<div style="display:none"><div id="terms_of_contract">
	    								<h1><?php echo $config->terms_of_contract->title; ?></h1>
	    								<?php echo $config->terms_of_contract->text; ?>
	    								</div></div>
	    							<?php } ?>
	    							<?php if ($config->terms_of_privacy_accept) { ?>
	    								<label>
	    								<input type="checkbox" name="accept_terms_of_privacy" id="accept_terms_of_privacy" value="1">
	    								<?php echo JText::_('I accept')?> <a class="modal" href="#terms_of_privacy"><?php echo $config->terms_of_privacy->title; ?></a>.
	    								</label>
	    								
	    								<div style="display:none"><div id="terms_of_privacy">
	    								<h1><?php echo $config->terms_of_privacy->title; ?></h1>
	    								<?php echo $config->terms_of_privacy->text; ?>
	    								</div></div>
	    							<?php } ?>
	    						</td>
	    					</tr>
	    					
	    			<?php 
	    			}
	    			?>
	    		</table>
	    	</fieldset>
	    </div>
    <?php 
    	}
    ?>
    <?php if ($canContinue) { ?>
	   	<div class="bookingToolbar">
			<a class="aIconToolSave tool save" title="<?php echo $titleSave; ?>" href="javascript:submitbutton('save')" ><?php echo $titleSave; ?></a>
			<?php if($config->moreReservations){?><a class="aIconToolApply tool save" title="<?php echo $titleContinue; ?>" href="javascript:submitbutton('store')" ><?php echo $titleContinue; ?></a><?php }?>
			<a class="aIconToolRestore tool cancel" title="<?php echo $titleStorno; ?>" href="<?php echo $backUrl; ?>"><?php echo $titleStorno; ?></a>
			<a class="aIconToolCancel tool cancel" title="<?php echo $titleErase; ?>" href="javascript:submitbutton('erase')" ><?php echo $titleErase; ?></a>
			<div class="clr"></div>
		</div>
	<?php } ?>
	<input type="hidden" name="option" value="<?php echo OPTION; ?>" />
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>" />
	<input type="hidden" name="id" value="<?php echo $this->id; ?>" />
	<input type="hidden" name="task" value="save" />
	<input type="hidden" name="view" value="reservation" />
	<input type="hidden" name="layout" value="form" />
	<input type="hidden" name="month" value="<?php echo JRequest::getString('month'); ?>" />
	<input type="hidden" name="year" value="<?php echo JRequest::getString('year'); ?>" />
	<input type="hidden" name="Itemid" value="<?php echo JRequest::getInt('Itemid'); ?>" />
	<?php 
		echo JHTML::_('form.token'); 
	?>
</form> 