<?php 

/**
 * Book it dialog template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

JHTML::_('behavior.modal');

defined('_JEXEC') or die('Restricted access');

$config = AFactory::getConfig();

if ($this->userCanReserve) {
	
	ADocument::addDomreadyEvent('Calendars.init(' . ($config->multipleReservations ? 'true' : 'false') . ');');
	
	$languages['LGSelectCheckIn'] = $start = JText::sprintf('Click in %s to select start date of your booking.', ($type = $this->calendar == 'monthly' ? JText::_('calendar') : JText::_('schedule')));
	$languages['LGSelectCheckOut'] = $end = JText::sprintf('Click in %s to select end date of your booking.', $type);
	$languages['LGSelectCheckNext'] = $next = JText::sprintf('If you want select another interval click in %s to start date of your booking.', $type); 
	ADocument::addLGScriptDeclaration($languages);
	
	?>
	
	<!-- Book it section -->
	
		<div class="bookInterval">
			<a id="calendar"></a>
			<?php if (!$config->multipleReservations) { ?>
				<?php if (IS_ADMIN) { ?>
					<h2><?php echo JText::_('Create new Reservation'); ?></h2>
				<?php } else { ?>
					<h2><?php echo JText::sprintf('Book this %s now.', $this->template->name); ?></h2>
				<?php } ?>
				<div class="buttons">
	        	<div class="checkInfo checkInfoMessage" id="checkInfo"><?php echo $start; ?></div>
	  			<div class="checkTools">
	  				<a class="checkButton checkButtonActive" id="selectCheckInDay" href="javascript:Calendars.setOperation(<?php echo CHECK_OP_IN; ?>)">
	  					<?php echo JText::_('Select check in'); ?></a>
	  				<a class="checkButton checkButtonUnactive" id="selectCheckOutDay" href="javascript:Calendars.setOperation(<?php echo CHECK_OP_OUT; ?>)">
	  					<?php echo JText::_('Select check out'); ?></a>
	  				<a class="checkButton resetButton" id="reset" href="javascript:Calendars.reset()">
	  					<?php echo JText::_('Reset'); ?></a>
	  				<div class="cleaner"></div>
	  			</div>
				</div>
				<?php 
					if ($config->locations && !empty($this->backurl)) {
						echo AHtml::locations($config->locations == 2, $this->backurl); 
					}
				?>
				<div class="fromTo">
	  			<div class="cal">
	  				<label for="iFrom"><?php echo JText::_('Check in'); ?>: </label>
	  				<input type="text" name="iFrom" id="iFrom" value="" disabled="disabled" size="16" />
	  			</div>
	  			<div class="cal">
	  				<label for="fTo"><?php echo JText::_('Check out'); ?>: </label>
	  				<input type="text" name="iTo" id="fTo" value="" disabled="disabled" size="16" />
	  			</div>
				</div>
				<div class="cleaner"></div>
			<?php } ?>
			<div class="bookit">
				<div class="checkInfo checkInfoMessage" id="checkInfo"></div>
				<h2 id="total"></h2>
				<a class="checkButton bookitButton" id="bookIt" href="javascript:Calendars.bookIt()">
					<?php echo JText::_('Book it'); ?></a>
			</div>
		</div>

<?php 
}
?>