<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewJoomDOC */

JToolBarHelper::title(JText::_('JOOMDOC_CHANGELOG'), 'changelog');

$changelog = JFile::read(JPATH_COMPONENT_ADMINISTRATOR . DS . 'changelog.txt');
$changelog = str_replace("\r\n", "\n", $changelog);
$boundary = '*****';
$versions = array();
if (preg_match_all('/--\s(\d\.\d\.\d)[^\[]*\[(\d{2}\.\d{2}\.\d{4})\]/', $changelog, $versions, PREG_SET_ORDER))
    foreach ($versions as $version)
        $changelog = str_replace($version, $boundary, $changelog);
$comments = explode($boundary, $changelog);
unset($comments[0]);
$comments = array_merge($comments);
$format = JText::_('DATE_FORMAT_LC4');
foreach ($versions as $i => $version) {
    $date =& JFactory::getDate($version[2]);
    /* @var $date JDate */
    echo '<h3>' . $version[1] . ' ' . (J16 ? $date->format($format, true) : $date->toFormat($format, true)) . '</h3>';
    $rows = array();
    if (preg_match_all("/(\w{3})\s-\s([^\n]*)\n/s", $comments[$i], $rows, PREG_SET_ORDER)) {
        echo '<table>';
        foreach ($rows as $row)
            echo '<tr><th>' . $row[1] . '</th><td>' . $row[2] . '</td></tr>';
        echo '</table>';
    }
}
?>