<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

class JoomDOCSearchConfig {
    var $parent = null;
    var $area_title = null;
    var $area_text = null;
    var $area_meta = null;
    var $area_full = null;
    var $type = null;
    var $ordering = null;
    var $layout = null;
    var $moduleclass_sfx = null;

    /**
     * Get static filled instance.
     *
     * @param JParameter $params
     * @return JoomDOCSearchConfig
     */
    function getInstance ($params) {
        static $instance;
        if (empty($instance)) {
            $instance = new JoomDOCSearchConfig();
            $instance->init($params);
        }
        return $instance;
    }

    /**
     * Load setting.
     *
     * @param JParameter $params
     */
    function init ($params) {
        $this->parent = JString::trim($params->getValue('parent', ''));
        $this->area_title = (int) $params->getValue('area_title', 1);
        $this->area_text = (int) $params->getValue('area_text', 1);
        $this->area_meta = (int) $params->getValue('area_meta', 0);
        $this->area_full = (int) $params->getValue('area_full', 0);
        $this->type = (int) $params->getValue('type', 0);
        $this->ordering = JString::trim($params->getValue('ordering', 'newest'));
        $this->layout = JString::trim($params->getValue('layout', 'default'));
        $this->moduleclass_sfx = JString::trim($params->getValue('moduleclass_sfx', ''));
    }
}
?>