<?php
/**
 * Contacts SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

define('_COM_SEF_PRIORITY_CONTACT_CONTACT_ITEMID', 15);
define('_COM_SEF_PRIORITY_CONTACT_CONTACT', 20);
define('_COM_SEF_PRIORITY_CONTACT_CATEGORY_ITEMID', 25);
define('_COM_SEF_PRIORITY_CONTACT_CATEGORY', 30);

class SefExt_com_contact extends SefExt
{

    function getContactName($id)
    {
        $sefConfig = & SEFConfig::getConfig();
        $title=array();
        
        $field = 'name';
        if (SEFTools::UseAlias($this->params, 'contact_alias')) {
            $field = 'alias';
        }
        $query="SELECT `$field` AS `name`, `catid`, `metakey`, `metadesc`, `metadata`, `language`,`misc` FROM `#__contact_details` WHERE `id` = $id";
        $this->_db->setQuery($query);
        $row = $this->_db->loadObject();
        
        $name = (($this->params->get('contactid', '0') != '0') ? $id . '-' : '') . $row->name;
        // use contact description as page meta tags if available
        if (($contact->misc = JString::trim($row->misc))) {
            $this->metadesc = $row->misc;
        }
        
        if ($this->params->get('show_category', '2') != '0') {
        	$title=array_merge($title,$this->getCategoryInfo($row->catid));
        }
        $title[]=$row->name;
        $this->getMetaData($row);
        
        return $title;
    }

    function beforeCreate(&$uri)
    {
        // Remove the part after ':' from variables
        if (! is_null($uri->getVar('id')))
            SEFTools::fixVariable($uri, 'id');
        if (! is_null($uri->getVar('catid')))
            SEFTools::fixVariable($uri, 'catid');
        
        $view = $uri->getVar('view');
        $id = (int) $uri->getVar('id');
        $catid = (int) $uri->getVar('catid');
        
        switch ($view) {
            case 'category':
            case 'categories':
                // Remove view and catid if they point to empty category/categories
                if (! $id) {
                    $uri->delVar('view');
                    $uri->delVar('id');
                }
            case 'contact':
                if ($id && $catid)
                    $uri->delVar('catid');
        }
        
        return;
    }

    function create(&$uri)
    {
        $this->metadesc = null;
        
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        
        $this->params = SEFTools::getExtParams('com_contact');
        
        $title[] = JoomSEF::_getMenuTitleLang(@$option, $this->lang, @$Itemid);
        
        if (isset($view)) {
            switch ($view) {
            	case 'categories':
            	case 'featured':
            		break;
            	case 'category':
                    $title = array_merge($title, $this->getCategoryInfo($id));
            		break;
                case 'contact':
                    $title = array_merge($title, $this->getContactName($id));
                    break;
            }
        }
        
        if (! empty($format) && ($format == 'feed')) {
            if (! empty($type))
                $title[] = $type;
        }
        
        $newUri = $uri;
        
        if (count($title) > 0) {
            // Generate meta tags
            $this->metatags = $this->getMetaTags();
            $priority = $this->getPriority($uri);
            if(isset($this->lang)) {
            	$lang=$this->lang;
            }
            
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang, null, null, $this->metatags, $priority);
        }
        
        return $newUri;
    }

    function getPriority(&$uri)
    {
        $itemid = $uri->getVar('Itemid');
        $view = $uri->getVar('view');
        
        switch ($view) {
            case 'contact':
                if (is_null($itemid)) {
                    return _COM_SEF_PRIORITY_CONTACT_CONTACT;
                } else {
                    return _COM_SEF_PRIORITY_CONTACT_CONTACT_ITEMID;
                }
                break;
            
            default:
                if (is_null($itemid)) {
                    return _COM_SEF_PRIORITY_CONTACT_CATEGORY;
                } else {
                    return _COM_SEF_PRIORITY_CONTACT_CATEGORY_ITEMID;
                }
                break;
        }
    }
    
    function getURLPatterns($item) {
    	$db=JFactory::getDBO();
    	$urls=array();
    	if($item->getTableName()=='#__categories') {
    		// Category view
    		$urls[]='index\.php\?option=com_contact(&format=feed)?&id='.$item->id.'(&lang=[a-z]+)?(&limitstart=[0-9]+)?(&type=(atom|rss))?&view=category';
    		
    		$query=$db->getQuery(true);
    		$query->select('id')->from('#__contact_details')->where('catid='.$item->id);
    		$db->setQuery($query);
    		$ids=$db->loadResultArray();
    		foreach($ids as $id) {
				$urls[]='index\.php\?option=com_contact&id='.$id.'&';
    		}
    		
    		$tree=$item->getTree($item->id);
    		foreach($tree as $catitem) {
    			$urls[]='index\.php\?option=com_contact(&format=feed)?&id='.$catitem->id.'(&lang=[a-z]+)?(&limitstart=[0-9]+)?(&type=(atom|rss))?&view=category';
    			
    			$query=$db->getQuery(true);
	    		$query->select('id')->from('#__contact_details')->where('catid='.$catitem->id);
	    		$db->setQuery($query);
	    		$ids=$db->loadResultArray();
	    		foreach($ids as $id) {
    				$urls[]='index\.php\?option=com_contact&id='.$id.'&';
	    		}
    		}
    	} else {
    		$urls[]='index\.php\?option=com_contact&id='.$item->id.'&';
    	}
    	return $urls;
    }
}
?>