<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.10
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2021 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

interface ISefSitemapXmlGenerator
{
    /**
     * Opens sitemap XML file(s) for writing
     */
    public function open();

    /**
     * Adds given URL to sitemap currently being generated
     *
     * @param SefSitemapUrl $url
     */
    public function addUrl($url);

    /**
     * Closes sitemap currently being generated
     */
    public function close();

    /**
     * Returns URLs to generated sitemaps
     *
     * @return string[]
     */
    public function getSitemapsUrls();
}
