<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.10
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2021 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class SefSitemapIndexXmlWriter
{
    /** @var string */
    protected $filePath;

    /** @var resource */
    protected $fileHandle;

    /**
     * @param string $filePath
     */
    public function __construct($filePath)
    {
        $this->filePath = $filePath;
        $this->openFile();
        $this->writeHeader();
    }

    protected function openFile()
    {
        $this->fileHandle = @fopen($this->filePath, 'w');
        if (!$this->fileHandle)
            throw new RuntimeException(JText::_('COM_SEF_ERROR_CREATE_XML'));
    }

    protected function writeHeader()
    {
        $header = '<?xml version="1.0" encoding="UTF-8"?>
<sitemapindex xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/siteindex.xsd" xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
';
        if (@fwrite($this->fileHandle, $header) === false)
            throw new RuntimeException(JText::_('COM_SEF_ERROR_SAVE_XML'));
    }

    protected function writeFooter()
    {
        if (@fwrite($this->fileHandle, '</sitemapindex>') === false)
            throw new RuntimeException(JText::_('COM_SEF_ERROR_SAVE_XML'));
    }

    /**
     * @param string $url
     */
    public function addSitemap($url)
    {
        $text = "    <sitemap>\n";
        $text.= "        <loc>{$url}</loc>\n";
        $text.= "        <lastmod>".gmdate('Y-m-d\\TH:i:sP')."</lastmod>\n";
        $text.= "    </sitemap>\n";

        if (@fwrite($this->fileHandle, $text) === false)
            throw new RuntimeException(JText::_('COM_SEF_ERROR_SAVE_XML'));
    }

    public function close()
    {
        if ($this->fileHandle) {
            $this->writeFooter();

            @fclose($this->fileHandle);
            $this->fileHandle = null;
        }
    }
}
