<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.10
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2021 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class SefSitemapUrl
{
    /** @var object */
    protected $url;

    /**
     * @param object $url
     */
    public function __construct($url)
    {
        $this->url = $url;
    }

    /**
     * @return string|null
     */
    public function getLang()
    {
        if (empty($this->url->origurl))
            return null;

        $matches = array();
        if (preg_match('/[?&]lang=([^&]+)/', $this->url->origurl, $matches)) {
            return $matches[1];
        }

        return null;
    }

    public function getSefUrl()
    {
        return empty($this->url->sefurl) ? '' : $this->url->sefurl;
    }

    public function getSitemapDate()
    {
        if (empty($this->url->sm_date) || $this->url->sm_date == '0000-00-00')
            return date('Y-m-d');
        return $this->url->sm_date;
    }

    public function getSitemapFrequency()
    {
        if (empty($this->url->sm_frequency)) {
            $sefConfig = SEFConfig::getConfig();
            return $sefConfig->sitemap_frequency;
        }

        return $this->url->sm_frequency;
    }

    public function getSitemapPriority()
    {
        if (empty($this->url->sm_priority)) {
            $sefConfig = SEFConfig::getConfig();
            return $sefConfig->sitemap_priority;
        }

        return $this->url->sm_priority;
    }
}
