<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.8
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2020 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

defined('_JEXEC') or die('Restricted access');

// XML definition file
$this->_addFileOp('/administrator/components/com_sef/sef.xml', 'upgrade', '/sef.xml');
$this->_addFileOp('/administrator/components/com_sef/classes/seftools.php', 'upgrade', '/admin/classes/seftools.php');
$this->_addFileOp('/administrator/components/com_sef/views/info/tmpl/changelog.inc.html', 'upgrade', '/admin/views/info/tmpl/changelog.inc.html');
$this->_addFileOp('/administrator/components/com_sef/views/info/tmpl/readme.inc.html', 'upgrade', '/admin/views/info/tmpl/readme.inc.html');

// Admin files
$this->_addFileOp('/administrator/components/com_sef/controller.php', 'upgrade', '/admin/controller.php');
$this->_addFileOp('/administrator/components/com_sef/classes/config.php', 'upgrade', '/admin/classes/config.php');
$this->_addFileOp('/administrator/components/com_sef/controllers/sefurls.php', 'upgrade', '/admin/controllers/sefurls.php');
$this->_addFileOp('/administrator/components/com_sef/models/config.php', 'upgrade', '/admin/models/config.php');
$this->_addFileOp('/administrator/components/com_sef/models/sef.php', 'upgrade', '/admin/models/sef.php');
$this->_addFileOp('/administrator/components/com_sef/models/sefurls.php', 'upgrade', '/admin/models/sefurls.php');
$this->_addFileOp('/administrator/components/com_sef/views/config/tmpl/default.php', 'upgrade', '/admin/views/config/tmpl/default.php');
$this->_addFileOp('/administrator/components/com_sef/views/sef/view.html.php', 'upgrade', '/admin/views/sef/view.html.php');
$this->_addFileOp('/administrator/components/com_sef/views/sef/tmpl/default.php', 'upgrade', '/admin/views/sef/tmpl/default.php');
$this->_addFileOp('/administrator/components/com_sef/views/sefurls/view.html.php', 'upgrade', '/admin/views/sefurls/view.html.php');
$this->_addFileOp('/administrator/components/com_sef/views/sefurls/tmpl/update.php', 'upgrade', '/admin/views/sefurls/tmpl/update.php');
$this->_addFileOp('/administrator/components/com_sef/views/sefurls/tmpl/updatemeta.php', 'upgrade', '/admin/views/sefurls/tmpl/updatemeta.php');

$this->_addFileOp('/administrator/components/com_sef/views/sefurls/tmpl/urlsupdated.php', 'delete');

// Language files
// We need to check every directory for existence and copy only the languages in use
if( JFolder::exists(JPATH_ROOT.'/administrator/language/en-GB') ) {
    $this->_addFileOp('/administrator/language/en-GB/en-GB.com_sef.ini', 'upgrade', '/admin/language/en-GB/en-GB.com_sef.ini');
}

// Frontend files
$this->_addFileOp('/components/com_sef/joomsef.php', 'upgrade', '/site/joomsef.php');
$this->_addFileOp('/components/com_sef/sef.ext.php', 'upgrade', '/site/sef.ext.php');
$this->_addFileOp('/components/com_sef/sef.php', 'upgrade', '/site/sef.php');
$this->_addFileOp('/components/com_sef/sef.router.php', 'upgrade', '/site/sef.router.php');

// Extensions
$this->_addFileOp('/components/com_sef/sef_ext/com_content.php', 'upgrade', '/site/sef_ext/com_content.php');
$this->_addFileOp('/components/com_sef/sef_ext/com_content.xml', 'upgrade', '/site/sef_ext/com_content.xml');

// Plugin
$this->_addFileOp('/plugins/system/joomsef/joomsef.php', 'upgrade', '/admin/plugin/joomsef.php');
$this->_addFileOp('/plugins/system/joomsef/joomsef.xml', 'upgrade', '/admin/plugin/joomsef.xml');

// Table structure
$this->_addSQL("ALTER TABLE `#__sefurls` ADD COLUMN `flag` TINYINT(1) NOT NULL DEFAULT '0'");
