<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.9
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2020 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

defined('JPATH_BASE') or die;

require_once(JPATH_ADMINISTRATOR.'/components/com_categories/models/fields/categoryedit.php');

/**
 * Extends standard CategoryEdit field to simply allow not selecting any category
 */
class JFormFieldSefCategoryEdit extends JFormFieldCategoryEdit
{
    /**
     * Returns original input HTML prepended with hidden input with the same name and empty value
     *
     * @return string
     */
    protected function getInput()
    {
        $inputHtml = parent::getInput();

        $hiddenName = $this->name;
        if (substr($hiddenName, -2) == '[]') {
            $hiddenName = substr($hiddenName, 0, -2);
        }
        $html = '<input type="hidden" name="'.$hiddenName.'" value="" />'."\n".$inputHtml;

        return $html;
    }
}
