<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

if (!class_exists('vmPSPlugin')) {
    require(JPATH_VM_PLUGINS.'/vmpsplugin.php');
}

/**
 * Provides a new field for VM registration form to verify phone number
 * using a SMS verification code
 */
class plgVmuserfieldSmscheck extends vmPSPlugin
{
    private $_displayed = false;
    
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
    }
    
    /**
     * Called when a form with shopper fields is displayed.
     * Set field HTML code into: $return['fields'][$field->name]['formcode']
     * 
     * @param string $prefix Field prefix
     * @param object $field Field object
     * @param string $userId User ID
     * @param array $return Array with all the fields
     */
    public function plgVmOnUserfieldDisplay($prefix, $field, $userId, &$return)
    {
        // Check if user is logged in - don't trust the $userId value,
        // it is 0 on checkout form if user is logged in but not registered in VM
        $user = JFactory::getUser();
        if ($user->id) {
            // Already registered, this is account maintenance
            $return['fields'][$field->name]['formcode'] = JText::_('PLG_VMUSERFIELD_SMSCHECK_ONLY_REGISTRATION');
            return;
        }
        
        if (!$this->_displayed) {
            $this->_displayed = true;
            
            // Add our JS file to document
            $doc = JFactory::getDocument();
            $doc->addScript('plugins/vmuserfield/smscheck/assets/js/smscheck.js');
            
            // Add our CSS file to document
            $doc->addStyleSheet('plugins/vmuserfield/smscheck/assets/css/smscheck.css');
            
            // Set some required variables to JS
            $js = 'var VmuserfieldSmscheck = VmuserfieldSmscheck || {};'."\n";
            $js.= 'VmuserfieldSmscheck.rootUrl = '.json_encode(JURI::root()).';'."\n";
            $js.= 'VmuserfieldSmscheck.noPhoneText = '.json_encode(JText::_('PLG_VMUSERFIELD_SMSCHECK_PHONE_MISSING')).';'."\n";
            $js.= 'VmuserfieldSmscheck.resendText = '.json_encode(JText::_('PLG_VMUSERFIELD_SMSCHECK_RESEND')).';'."\n";
            $js.= 'VmuserfieldSmscheck.codeSentText = '.json_encode(JText::_('PLG_VMUSERFIELD_SMSCHECK_CODE_SENT')).';'."\n";
            $doc->addScriptDeclaration($js);
        }
        
        // Parse field params
        $params = array();
        if (!empty($field->params)) {
            $params = json_decode($field->params, true);
        }
        
        $this->fieldName = $field->name;
        $this->phoneField = (isset($params['phonefield']) ? $params['phonefield'] : 'phone_1');
        
        $return['fields'][$field->name]['formcode'] = $this->renderByLayout();
    }

    /**
     * Called everytime some VM task is being executed
     * 
     * @param string $controller Controller name used
     */
    public function plgVmOnMainController($controller)
    {
        // Check if this is AJAX call to send a verification code
        if (JRequest::getVar('task', null, 'post') != 'smsCheckSend')
            return;
        
        // Get phone number
        $phone = JRequest::getVar('phone', null, 'post');
        if (empty($phone)) {
            $this->sendError(JText::_('PLG_VMUSERFIELD_SMSCHECK_PHONE_MISSING'));
        }
        
        // Load required files
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/config.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/helper.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/lib/httphelper.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/lib/smsservice.php');
        
        // Validate phone number
        $phone = VmsmsHelper::checkPhone($phone);
        if (!$phone) {
            $this->sendError(JText::_('PLG_VMUSERFIELD_SMSCHECK_PHONE_NOT_VALID'));
        }
        
        $config = VmsmsConfig::getInstance();

        // Check credentials
        if (empty($config->username) || empty($config->apiKey)) {
            $this->sendError(JText::_('PLG_VMUSERFIELD_SMSCHECK_CREDENTIALS'));
        }
        
        // Generate code
        $code = '';
        for ($i = 0; $i < 6; $i++) {
            $code .= mt_rand(0, 9);
        }
        
        $text = str_replace('%s', $code, JText::_('PLG_VMUSERFIELD_SMSCHECK_MESSAGE'));
        
        // Try to send the SMS
        $sms = AVmsmsSmsService::getInstance();
        if (!$sms->sendMessage($config->username, $config->apiKey, $phone, $text, $config->allowUnicode, 'vmsms2_smscheck')) {
            $this->sendError($sms->getError());
        }
        
        // Success, store the code in session
        $field = JRequest::getVar('field', 'verify', 'post');
        $session = JFactory::getSession();
        $session->set('vmuserfield.smscheck.'.$field, $code);
        
        $this->sendSuccess();
    }

    private function sendError($msg)
    {
        $obj = new stdClass();
        $obj->success = false;
        $obj->err = $msg;
        
        echo json_encode($obj);
        
        $app = JFactory::getApplication();
        $app->close();
    }
    
    private function sendSuccess()
    {
        $obj = new stdClass();
        $obj->success = true;
        
        echo json_encode($obj);
        
        $app = JFactory::getApplication();
        $app->close();
    }
    
    /**
     * Called when shopper field is being edited in backend
     * 
     * @param string $type Field type
     * @param string $plgName Plugin element name
     * @param string $pluginId Plugin ID
     * @param TableUserfields $data Field object
     */
    public function plgVmDeclarePluginParamsUserfield($type, $plgName, $pluginId, &$data)
    {
        // Unserialize params
        if (!empty($data->params)) {
            $params = json_decode($data->params, true);
            if (is_array($params)) {
                foreach ($params as $key => $val) {
                    $data->$key = $val;
                }
            }
        }
    }

    /**
     * Called to check input values before user account info is saved
     * 
     * @param bool $valid Set to FALSE to interrupt save
     * @param string $userId User ID
     * @param array $data Data from form
     * @param JUser $user User object
     */
    public function plgVmOnBeforeUserfieldDataSave(&$valid, $userId, &$data, $user)
    {
        // Don't check for existing users
        if ($userId) {
            return;
        }
        
        // Load the fields and check their values
        $db = JFactory::getDbo();
        $query = "SELECT `title`, `name` FROM `#__virtuemart_userfields` WHERE `type` = 'pluginsmscheck' AND `published` = 1 AND `account` = 1";
        $db->setQuery($query);
        $fields = $db->loadObjectList();
        
        if (is_array($fields) && count($fields) > 0) {
            $session = JFactory::getSession();
            foreach ($fields as $field) {
                $name = $field->name;
                $value = isset($data[$name]) ? $data[$name] : null;
                
                if (!$value) {
                    JError::raiseWarning(0, str_replace('%s', $field->title, JText::_('PLG_VMUSERFIELD_SMSCHECK_ENTER_CODE')));
                    $valid = false;
                    return;
                }
                
                $storedValue = $session->get('vmuserfield.smscheck.'.$name);
                if ($value != $storedValue) {
                    JError::raiseWarning(0, str_replace('%s', $field->title, JText::_('PLG_VMUSERFIELD_SMSCHECK_CODE_MISMATCH')));
                    $valid = false;
                    return;
                }
            }
        }
    }

    /**
     * Called after fields values are checked when saving user account info
     * 
     * @param string $fieldType Field type
     * @param string $fieldName Field name
     * @param array $data Form data
     * @param mixed $return Field value from form
     * @param mixed $params Field params
     */
    public function plgVmPrepareUserfieldDataSave($fieldType, $fieldName, &$data, &$return, $params)
    { }

    /**
     * Called when shopper field is being saved in backend
     * 
     * @param string $plgName Plugin element name
     * @param array $data Form data
     * @param TableUserfields $fieldTable Field table object
     */
    public function plgVmOnBeforeUserfieldSave($plgName, &$data, &$fieldTable)
    {
        // Serialize params, so they are stored in VM table
        $data['params'] = json_encode($data['params']);
    }

    /**
     * Called after the shopper field is saved in backend
     * 
     * @param string $type Always 'userfield'
     * @param array $data Form data
     */
    public function plgVmOnStoreInstallPluginTable($type, $data)
    { }
}
