<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

$config = VmsmsConfig::getInstance();
$localCountry = '';
if (isset($config->localCountry['country_code']) && isset($config->localCountry['dial_code'])) {
    $localCountry = $config->localCountry['country_code'].','.$config->localCountry['dial_code'];
}
?>
<div id='f1-dialog' class="dialog" style="display:none">
    <div class="dialog-inner">
        <table class="adminform">
            <tr>
                <td>
                    <input type="radio" name="f1-type" id="f1-dialog-type-2" onclick="f1.dialog.setType(true)" checked="checked" value="2" />
                    <label for="f1-dialog-type-2">Range</label>
                    <input type="radio" name="f1-type" id="f1-dialog-type-1" onclick="f1.dialog.setType(false)" value="1" />
                    <label for="f1-dialog-type-1">Pattern</label>
                </td>
            </tr>
            <tr>
                <td>
                    <div id="f1-dialog-digits-1">
                        <select class="digits" onchange="f1.dialog.selectDigit(this)"></select>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <div id="f1-dialog-digits-2">
                        <select class="digits" onchange="f1.dialog.selectDigit(this)"></select>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <button type="button" onclick="f1.saveDialog()">Ok</button>
                    <button type="button" onclick="f1.closeDialog()">Close</button>
                </td>
            </tr>
        </table>
    </div>
</div>

<form action="index.php" method="post" name="adminForm" id="adminForm">
    <fieldset class="adminform">
        <legend><?php echo JText::_('COM_VMSMS_CONFIG_BASIC'); ?></legend>

        <table class="adminform table table-striped">
            <tr>
                <td class="key"><?php echo $this->label('username', 'COM_VMSMS_CONFIG_USERNAME'); ?></td>
                <td><?php echo $this->lists['username']; ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo $this->label('apiKey', 'COM_VMSMS_CONFIG_API_KEY'); ?></td>
                <td><?php echo $this->lists['apiKey']; ?></td>
            </tr>
        </table>

        <table class="adminform table table-striped">
            <tr>
                <td class="key"><?php echo $this->label('primary_phone', 'COM_VMSMS_CONFIG_PRIMARY_PHONE'); ?></td>
                <td><?php echo $this->lists['primary_phone']; ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo $this->label('secondary_phone', 'COM_VMSMS_CONFIG_SECONDARY_PHONE'); ?></td>
                <td><?php echo $this->lists['secondary_phone']; ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo $this->label('allowUnicode', 'COM_VMSMS_CONFIG_ALLOW_UNICODE'); ?></td>
                <td><?php echo $this->lists['allowUnicode']; ?></td>
            </tr>
        </table>
    </fieldset>

    <fieldset class="adminform">
        <legend><?php echo JText::_('COM_VMSMS_CONFIG_PHONE_NUMBERS_FILTER'); ?></legend>

        <table class="adminform table table-striped">
            <tr>
                <td class="key"><?php echo $this->label('f1-local-country', 'COM_VMSMS_LOCAL_COUNTRY'); ?></td>
                <td><select class="country-codes" name="local-country" id="f1-local-country"></select></td>
            </tr>
            <tr>
                <td class="key"><?php echo $this->label('f1-number-prefix', 'COM_VMSMS_COUNTRY_PREFIX_LIMIT'); ?></td>
                <td><select class="max-number-for-prefix" name="prefix-number" id="f1-number-prefix"></select></td>
            </tr>
        </table>

        <table class="adminform table table-striped">
            <tr>
                <td class="key"><?php echo $this->label('f1-include-country', 'COM_VMSMS_INCLUDE_NUMBERS'); ?></td>
                <td>
                    <div>
                        <select class="country-codes" id="f1-include-country" onchange="f1.include.changeCountry()"></select>
                        <div class="clr"></div>
                    </div>
                    <div>
                        <table>
                            <tbody id="f1-include">
                                <tr id="f1-include-template" style="display:none">
                                    <td><span class="prefix"></span></td>
                                    <td><span class="value">*</span><a class="editFilter hasTip" onclick="f1.openDialog(f1.include, this, this);" href="javascript:void(0);" title="<?php echo JText::_('COM_VMSMS_FILTER_EDIT'); ?>::"></a></td>
                                    <td><a class="removeFilter hasTip" onclick="f1.include.removeFilter(this);" href="javascript:void(0);" title="<?php echo JText::_('COM_VMSMS_FILTER_REMOVE'); ?>::"></a></td>
                                </tr>
                            </tbody>
                        </table>
                        <a class="addFilter hasTip" onclick="f1.openDialog(f1.include, this);" href="javascript:void(0);" title="<?php echo JText::_('COM_VMSMS_FILTER_ADD'); ?>::"></a>
                        <input type="hidden" id="f1-include-field" name="include-filters" value="<?php echo $this->lists['includeNumbers']; ?>" />
                    </div>
                </td>
            </tr>
            <tr>
                <td class="key"><?php echo $this->label('f1-exclude-country', 'COM_VMSMS_EXCLUDE_NUMBERS'); ?></td>
                <td>
                    <div>
                        <select class="country-codes" id="f1-exclude-country" onchange="f1.exclude.changeCountry()"></select>
                        <div class="clr"></div>
                    </div>
                    <div>
                        <table>
                            <tbody id="f1-exclude">
                                <tr id="f1-exclude-template" style="display:none">
                                    <td><span class="prefix"></span></td>
                                    <td><span class="value">*</span><a class="editFilter hasTip" onclick="f1.openDialog(f1.exclude, this, this);" href="javascript:void(0);" title="<?php echo JText::_('COM_VMSMS_FILTER_EDIT'); ?>::"></a></td>
                                    <td><a class="removeFilter hasTip" onclick="f1.exclude.removeFilter(this);" href="javascript:void(0);" title="<?php echo JText::_('COM_VMSMS_FILTER_REMOVE'); ?>::"></a></td>
                                </tr>
                            <tbody>
                        </table>
                        <a class="addFilter hasTip" onclick="f1.openDialog(f1.exclude, this);" href="javascript:void(0);" title="<?php echo JText::_('COM_VMSMS_FILTER_ADD'); ?>::"></a>
                        <input type="hidden" id="f1-exclude-field" name="exclude-filters" value="<?php echo $this->lists['excludeNumbers']; ?>" />
                    </div>
                </td>
            </tr>
        </table>
        <script type="text/javascript">
            var f1 = new NumberFilters('f1');
            f1.selectOption(document.getElementById('f1-local-country'), '<?php echo $localCountry; ?>');
            f1.selectOption(document.getElementById('f1-include-country'), '<?php echo $localCountry; ?>');
            f1.selectOption(document.getElementById('f1-exclude-country'), '<?php echo $localCountry; ?>');
            f1.selectOption(document.getElementById('f1-number-prefix'), '<?php echo $config->localCountryMinDigits; ?>');
            f1.include.changeCountry();
            f1.exclude.changeCountry();
        </script>
    </fieldset>

    <fieldset class="adminform">
        <legend><?php echo JText::_('COM_VMSMS_CONFIG_MESSAGES'); ?></legend>

        <div class="config_info">
            <?php echo JText::_('COM_VMSMS_CONFIG_SMS_INFO'); ?>
        </div>

        <?php
        // Display messages configuration for each language separately
        $languages = JLanguageHelper::getLanguages();

        // Load VirtueMart's language file for order status translations
        $lang = JFactory::getLanguage();
        $lang->load('com_virtuemart_orders', JPATH_SITE.'/components/com_virtuemart');

        foreach ($this->vmStates as $state) {
            ?>
            <div class="status_config">
                <fieldset class="adminform">
                    <legend><?php echo JText::_($state->name); ?></legend>

                    <table class="adminform table table-striped">
                        <tr>
                            <td class="key"><?php echo $this->label('', 'COM_VMSMS_SEND_TO_USER'); ?></td>
                            <td><?php echo $this->lists['sendUser'][$state->id]; ?></td>
                        </tr>
                        <tr>
                            <td class="key"><?php echo $this->label('', 'COM_VMSMS_SEND_TO_CUSTOMER'); ?></td>
                            <td><?php echo $this->lists['sendCustomer'][$state->id]; ?></td>
                        </tr>
                        <tr>
                            <td class="key"><?php echo $this->label('', 'COM_VMSMS_SMS_USER_TEXT'); ?></td>
                            <td>
                                <?php echo $this->lists['userText'][$state->id]; ?>
                                <br class="clr"/>
                                <span class="sms_counter" id="sms_counter_userText_<?php echo $state->id; ?>">0 / 0</span>
                            </td>
                        </tr>
                        <tr>
                            <td class="key"><?php echo $this->label('', 'COM_VMSMS_SMS_CUSTOMER_TEXT'); ?></td>
                            <td>
                                <div>
                                <?php
                                echo JHtml::_('tabs.start', 'vmsms-config-tabs-'.$state->id, array('useCookie' => true));
                                foreach ($languages as $language) {
                                    $lang = $language->lang_code;
                                    $imgPath = JUri::root(true).'/media/mod_languages/images/'.$language->image.'.gif';
                                    $img = '<img src="'.$imgPath.'" />';
                                    echo JHtml::_('tabs.panel', $img, 'msgs-'.$lang);
                                    ?>
                                    <table class="inner">
                                        <tr>
                                            <td>
                                                <?php echo $this->lists['customerText'][$state->id][$lang]; ?>
                                                <br class="clr"/>
                                                <span class="sms_counter" id="sms_counter_customerText_<?php echo $state->id.'_'.$lang; ?>">0 / 0</span>
                                            </td>
                                        </tr>
                                    </table>
                                    <?php
                                }
                                echo JHtml::_('tabs.end');
                                ?>
                                </div>
                            </td>
                        </tr>
                    </table>
                </fieldset>
            </div>
            <?php
        }
        echo '<div class="clr"></div>';
        ?>
        <script type="text/javascript">
            VMSMS.initSmsCounters();
        </script>
    </fieldset>

    <input type="hidden" name="option" value="com_vmsms" />
    <input type="hidden" name="controller" value="config" />
    <input type="hidden" name="task" value="" />
</form>
