<?php

/**
 * @version     $Id$
 * @package     ARTIO Booking
 * @subpackage  models
 * @copyright   Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author      ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

class BookingModelPeriodMonthly extends BookingModelPeriod
{
    protected function _calculate()
    {
        $this->day->modify($this->getWeek() . ' ' . $this->getDay() . ' of this month');
        if ($this->day->toUnix() < $this->beginDay->toUnix()) {
            $this->day->modify($this->getWeek() . ' ' . $this->getDay() . ' of next month');
        }
        while (!$this->isEnd()) {
            $this->add();
            $this->day->modify('+ 4 weeks');
        }
    }
}