<?php
/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

//owner of object
$db = JFactory::getDbo();
$db->setQuery("ALTER TABLE `#__booking_subject` ADD `user_id` int(11) NOT NULL DEFAULT '0' ");
$db->query();

//change length of column for text
/*
 $db->setQuery("ALTER TABLE `j25_booking_config` MODIFY COLUMN `value` mediumtext ");
$db->query();
*/

//custom owner config
$newtable = "CREATE TABLE IF NOT EXISTS `#__booking_user_config` (
`user_id` int(11) NOT NULL,
`payments` text NOT NULL DEFAULT '',
`config` text NOT NULL DEFAULT '',
`calendar` text NOT NULL DEFAULT '',
PRIMARY KEY (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
$db->setQuery($newtable);
$db->query();

//custom color for price in front-end calendar
$db->setQuery("ALTER TABLE `#__booking_price` ADD `custom_color` VARCHAR(20) DEFAULT NULL ");
$db->query();

// new fields for periodic reservation
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_time_up time NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_time_down time NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_type tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_recurrence int(11) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_monday tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_tuesday tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_wednesday tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_thursday	tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_friday tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_saturday	tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_sunday tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_month tinyint(2) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_week tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_day tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_date_up date NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_end tinyint(1) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_occurrences int(11) NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_date_down date NOT NULL');
$db->query();
$db->setQuery('ALTER TABLE #__booking_reservation_items ADD period_total int(11) NOT NULL');
$db->query();

// follow up
$db->setQuery('ALTER TABLE `#__booking_reservation` ADD `follow_up_sent` TINYINT(1) NOT NULL');
$db->query();

// message for calendar
$db->setQuery('ALTER TABLE `#__booking_reservation_items` ADD `message` varchar(255) NOT NULL');
$db->query();

//convert old parameters to the new
$query = 'SELECT `xml`, `id` FROM `#__booking_template`';
$db->setQuery($query);
$data = $db->loadObjectList();

foreach($data as $template)
{
	$xml = false;
	if($template->xml)
	{
		try{
			$xml = new SimpleXMLElement($template->xml);
		} catch(Exception $e){continue;}
	}

	if (is_object($xml) && isset($xml->params)) {
		$newxml = new SimpleXMLElement('<?xml version="1.0" encoding="utf-8"?><form name="'.(string)$xml['name'].'" id="'.(string)$xml['id'].'"><fields name="params"><fieldset></fieldset></fields></form>');
		foreach($xml->params->param as $param)
		{
			$child = $newxml->fields->fieldset->addChild('field');
			foreach($param->attributes() as $key=>$attribute)
			{
				$child->addAttribute($key,(string)$attribute);
			}
			foreach ($param->option as $option) {
				$options = $child->addChild('option');
				$options->addAttribute('value',(string)$option['value']);
			}
		}
		$db->setQuery("UPDATE `#__booking_template` SET `xml` = '".$newxml->asXml()."' WHERE `id` = ".$template->id);
		$db->query();
	}
}

?>