<?php 

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

$this->_addSQL("UPDATE `#__assets` SET `parent_id` = 1 WHERE `name` = 'com_booking'");

// new structure of volume discount
$this->_addSQL('ALTER TABLE #__booking_price ADD volume_discount TEXT NOT NULL');
// update full price list
$db = JFactory::getDbo();
$count = $db->setQuery('SELECT COUNT(*) FROM #__booking_price')->loadResult();
// process in batch mode
for ($i = 0; $i < $count; $i += 100) { // convert existing unit discount into volume discount
	// next batch
	$prices = $db->setQuery('SELECT id, unit_count, unit_discount FROM #__booking_price', $i, 100)->loadObjectList();
	foreach ($prices as $price) {
		// old unit discount format
		$unitCount = explode("\n", str_replace(array("\r\n", "\n\r"), "\n", $price->unit_count));
		$unitDiscount = explode("\n", str_replace(array("\r\n", "\n\r"), "\n", $price->unit_discount));
		// check real list length
		$length = min(array(count($unitCount), count($unitDiscount)));
		$voldises = array();
		// process unit discount
		for ($j = 0; $j < $length; $j ++)
			$voldises[] = array('count' => JArrayHelper::getValue($unitCount, $j), 'value' => JArrayHelper::getValue($unitDiscount, $j), 'type' => 0, 'per' => 0);
		// convert into database format
		$voldises = new JRegistry($voldises);
		$voldises = $db->quote($voldises->toString());
		// save old unit discount into new volume discount
		$this->_addSQL('UPDATE #__booking_price SET volume_discount = ' . $voldises . ' WHERE id = ' . $price->id);
	}
}
// drop old unit discount
$this->_addSQL('ALTER TABLE #__booking_price DROP unit_count, DROP unit_discount');

// process single unit discount as well
$count = $db->setQuery('SELECT COUNT(*) FROM #__booking_subject')->loadResult();
// process in batch mode
for ($i = 0; $i < $count; $i += 100) {
	// next batch
	$subjects = $db->setQuery('SELECT id, params FROM #__booking_subject', $i, 100)->loadObjectList();
	foreach ($subjects as $subject) {
		$params = new JRegistry($subject->params);
		// old single unit discount format
		$singleDiscountUnit = explode("\n", str_replace(array("\r\n", "\n\r"), "\n", $params->get('single_discount_unit')));
		$singleDiscount = explode("\n", str_replace(array("\r\n", "\n\r"), "\n", $params->get('single_discount')));
		// check real list length
		$length = min(array(count($singleDiscountUnit), count($singleDiscount)));
		$voldises = array();
		// process single unit discount list
		for ($j = 0; $j < $length; $j ++)
			$voldises[] = array('count' => JArrayHelper::getValue($singleDiscountUnit, $j), 'value' => JArrayHelper::getValue($singleDiscount, $j), 'type' => 0, 'per' => 0);
		// convert into database format
		$voldises = new JRegistry($voldises);
		$params->set('volume_discount', $voldises->toString());
		$params = $db->quote($params->toString());
		// save old single unit discount into new volume discount
		$this->_addSQL('UPDATE #__booking_subject SET params = ' . $params . ' WHERE id = ' . $subject->id);
	}
}