<?php 

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this ARTIOFusionChartsViewARTIOFusionChart */

?>

<fieldset class="adminform">
	<legend><?php echo JText::_('JDETAILS'); ?></legend>
	<table class="admintable">
		<tr>
			<td class="key"><?php echo JText::_('JGLOBAL_TITLE'); ?></td>
			<td>
				<input type="text" id="title" name="title" value="<?php echo $this->chart->title; ?>" style="width: 100%"/>
			</td>
			<?php if ($this->chart->created_by) { ?>
				<td class="key"><?php echo JText::_('JGLOBAL_CREATED'); ?></td>
				<td>
                	<?php 
                		if ($this->chart->created_by)
                			echo JText::sprintf('%s by %s', date(JText::_('j.n.Y H:i'), strtotime($this->chart->created) + TZOFFSET), '<a href="' . JRoute::_(ARTIOFusionChartsHelperRoute::getUserRoute($this->chart->created_by->id)) . '" title="">' . $this->chart->created_by->name .'</a>'); 
                	?>
				</td>
			<?php } else { ?>
				<td>&nbsp;</td><td>&nbsp;</td>
			<?php } ?>
		</tr>
		<tr>
			<td class="key"><?php echo JText::_('JCATEGORY') . '&nbsp;-&nbsp;' . JText::_('Type'); ?></td>
			<td>
                <?php echo $this->lists['categories'] . implode("\n", $this->lists_charts); ?>
				<button onclick="ARTIOFusionCharts.changeType();return false;"><?php echo $this->escape(JText::_('JSUBMIT')); ?></button>
			</td>
			<?php if ($this->chart->modified_by) { ?>
				<td class="key"><?php echo JText::_('JGLOBAL_MODIFIED'); ?></td>
				<td>
					<?php 
						if (is_object($this->chart->modified_by))
							echo JText::sprintf('%s by %s', date(JText::_('j.n.Y H:i'), strtotime($this->chart->modified) + TZOFFSET), '<a href="' . JRoute::_(ARTIOFusionChartsHelperRoute::getUserRoute($this->chart->modified_by->id)) . '" title="">' . $this->chart->modified_by->name .'</a>');
					?>
				</td>
			<?php } else { ?>
				<td>&nbsp;</td><td>&nbsp;</td>
			<?php } ?>
		</tr>
	</table>
</fieldset>
