<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

class ARTIOFusionChartsViewARTIOFusionCharts extends JView
{

    function display($tpl = null)
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $user = &JFactory::getUser();
        /* @var $user JUser */
        $db = &JFactory::getDBO();
        /* @var $db JDatabaseMySQL */
        
        $lists['order'] = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'filter_order', 'filter_order', 'id', 'cmd');
        $lists['order_Dir'] = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'filter_order_Dir', 'filter_order_Dir', 'desc', 'word');
        
        //search filter
        $lists['search'] = JString::strtolower($mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'search', 'search', '', 'string'));
        
        $lists['copy'] = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'copy', 'copy', 1, 'int');
        
        //category filter
        $category = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'filter_categories', 'filter_categories', '', 'string');
        //type filter
        $type = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'filter_types', 'filter_types', '', 'string');
        
        $items = &$this->get('Data');
        $pagination = &$this->get('Pagination');
        
        $categories = &ARTIOFusionChartsHelper::loadCategories();
        $categoriesOptions[] = JHTML::_('select.option', '0', JText::_('JOPTION_SELECT_CATEGORY'), 'base', 'name');
        $categoriesOptions = array_merge($categoriesOptions, $categories);
        
        $lists['filter_categories'] = JHTML::_('select.genericlist', $categoriesOptions, 'filter_categories', 'onchange="ChartsList.submit();"', 'base', 'name', $category);
        
        $typesOptions[] = JHTML::_('select.option', 0, '- ' . JText::_('JGLOBAL_FILTER_TYPE_LABEL') . ' -', 'id', 'name');
        
        foreach ($categories as $item) {
            if ($category && $category != $item->base)
                continue;
            foreach ($item->charts as $chart)
                $typesOptions[] = JHTML::_('select.option', $chart->base, $chart->name, 'id', 'name');
        }
        
        $lists['filter_types'] = JHTML::_('select.genericlist', $typesOptions, 'filter_types', 'onchange="this.form.submit()"' . (! $category ? ' disabled="disabled"' : ''), 'id', 'name', $type);
        
        $categoryNames = &ARTIOFusionChartsHelper::getCategoryNamesArray($categories);
        $typesNames = &ARTIOFusionChartsHelper::getTypesNamesArray($categories);
        
        ARTIOFusionChartsHelperRoute::setSubmenu(ARTIOFUSIONCHARTS_PAGE_CHARTS);
        
        $this->assignRef('items', $items);
        $this->assignRef('pagination', $pagination);
        $this->assignRef('lists', $lists);
        $this->assignRef('categoryNames', $categoryNames);
        $this->assignRef('typesNames', $typesNames);
        $this->assignRef('user', $user);
        $this->assignRef('nullDate', $db->getNullDate());
        
        parent::display($tpl);
    }
}

?>