<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');
jimport('joomla.html.pagination');

class ARTIOFusionChartsViewDatabases extends JView
{

    function display($tpl = null)
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        
        $filter = new stdClass();
        
        $filter->limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        $filter->limitstart = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . '.db_limitstart', 'limitstart', 0, 'int');
        $filter->limitstart = ($filter->limit != 0 ? (floor($filter->limitstart / $filter->limit) * $filter->limit) : 0);
        
        $filter->order = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'db_filter_order', 'filter_order', 'id', 'cmd');
        $filter->orderDir = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'db_filter_order_Dir', 'filter_order_Dir', 'desc', 'word');
        
        $filter->search = $mainframe->getUserStateFromRequest(ARTIOFUSIONCHARTS_OPTION . 'db_search', 'search', '', 'string');
        $filter->search = JString::strtolower(JString::trim($filter->search));
        
        $model = &$this->getModel();
        /* @var $model ARTIOFusionChartsModelDatabases */
        
        $items = &$model->getData($filter);
        
        $pagination = new JPagination($model->getTotal($filter), $filter->limitstart, $filter->limit);
        
        ARTIOFusionChartsHelperRoute::setSubmenu(ARTIOFUSIONCHARTS_PAGE_DATABASES);
        
        $this->assignRef('items', $items);
        $this->assignRef('pagination', $pagination);
        $this->assignRef('lists', $lists);
        $this->assignRef('filter', $filter);
        
        parent::display($tpl);
    }
}

?>