<?php
/**
 * JoomDOC - Joomla! Document Manager
 * @version $Id: controller.php 1 2009-09-01 13:31:26Z j.trumpes $
 * @package JoomDOC
 * @copyright (C) 2009 Artio s.r.o.
 * @license see COPYRIGHT.php
 * @link http://www.artio.net Official website
 * JoomDOC is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 **/
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.controller');
require_once (JPATH_COMPONENT_HELPERS . DS . 'documents.php');
class DocmanController extends JController
{
    function __construct ($config = array())
    {
        parent::__construct($config);
        $this->registerTask('license_result', 'license_result');
    }
    function display ()
    {
        $gid = DocmanHelper::getGid();
        switch ($this->getTask()) {
            case 'cat_view':
                JRequest::setVar('view', 'docman');
                break;
            case 'doc_download':
            case 'doc_view':
                JRequest::setVar('view', 'download');
                break;
            case 'search_form':
            case 'search_result':
                JRequest::setVar('view', 'search');
                break;
            case 'doc_details':
                JRequest::setVar('view', 'document');
                break;
            case 'doc_edit':
                $view = $this->getView('document', 'html');
                $view->_displayForm();
                return;
            case 'doc_save':
            case 'save':
                DocumentsHelper::saveDocument($gid);
                break;
            case 'doc_cancel':
            case 'cancel':
                DocumentsHelper::cancelDocument($gid);
                break;
            case 'doc_move':
                $view = $this->getView('document', 'html');
                $view->_displayMove();
                return;
            case 'doc_move_process':
                DocumentsHelper::moveDocumentProcess($gid);
                break;
            case 'doc_checkin':
                DocumentsHelper::checkinDocument($gid);
                break;
            case 'doc_checkout':
                DocumentsHelper::checkoutDocument($gid);
                break;
            case 'doc_reset':
                DocumentsHelper::resetDocument($gid);
                break;
            case 'doc_delete':
                DocumentsHelper::deleteDocument($gid);
                break;
            case 'upload':
                $view = $this->getView('document', 'html');
                $view->_displayUpload(0);
                return;
            case 'doc_update':
                $view = $this->getView('document', 'html');
                $view->_displayUpload(1);
                return;
            case 'doc_approve':
                DocumentsHelper::approveDocument(array($gid));
                break;
            case 'doc_unpublish':
                DocumentsHelper::publishDocument(array($gid), 0);
                break;
            case 'doc_publish':
                DocumentsHelper::publishDocument(array($gid));
                break;
        }
        parent::display(true);
    }
    function license_result ()
    {
        require_once (JPATH_COMPONENT . DS . 'helpers' . DS . 'downloads.php');
        DownloadsHelper::licenseDocumentProcess(DocmanHelper::getGid());
    }
}
?>