<?php
/**
 * Kunena Forum SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

class sefext_com_kunena extends sef_joomsef
{
    function setUrlVar($url, $name, $value) {
        // Try to find the variable
        $pos = strpos($url, '?'.$name.'=');
        if( $pos === false ) {
            $pos = strpos($url, '&'.$name.'=');
        }
        
        if( $pos !== false ) {
            // Variable is already present, let's replace it
            $from = '';
            
            // Find the next presence of '&'
            $pos2 = strpos($url, '&', $pos+1);
            if( $pos2 !== false ) {
                // Found it
                $from = substr($url, $pos, $pos2 - $pos);
            } else {
                $from = substr($url, $pos);
            }
            
            // Replace the variable
            $url = str_replace($from, $from[0].$name.'='.$value, $url);
        } else {
            // Variable is not present, let's add it
            if( strpos($url, '?') !== false ) {
                $url .= '&'.$name.'='.$value;
            } else {
                $url .= '?'.$name.'='.$value;
            }
        }
        
        return $url;
    }
    
    function beforeCreate($string, &$vars)
    {
        global $fbConfig, $database, $mainframe;
        
        if (!isset($fbConfig->messages_per_page)) {
            // Load configuration
            $file = $GLOBALS['mosConfig_absolute_path'].'/components/com_kunena/lib/kunena.config.class.php';
            if (!file_exists($file)) {
                return;
            }
            
            require_once($file);
            
            // Create configuration object
            $fbConfig = new CKunenaConfig();
            $fbConfig->load();
        }
                
        $params = SEFTools::getExtParams('com_kunena');
        
        extract($vars);
        
        if (isset($func) && ($func == 'showcat') && isset($id)) {
            $string = SEFTools::RemoveVariable($string, 'id');
        }
        elseif( isset($id) && $params->get('smarturls', true) ) {
            // Find the root msg
            $oldid = $id;
            
            $query = "SELECT `id` FROM `#__fb_messages` WHERE (`parent` = '0') AND (`thread` = (SELECT `thread` FROM `#__fb_messages` WHERE `id` = '$id'))";
            $database->setQuery($query);
            $id = $database->loadResult();
            
            $string = $this->setUrlVar($string, 'id', $id);
            
            if ($oldid != $id) {
                // Get the message number
                $query = "SELECT COUNT(`id`) FROM `#__fb_messages` WHERE (`id` < '$oldid') AND (`thread` = (SELECT `thread` FROM `#__fb_messages` WHERE `id` = '$oldid')) ORDER BY `id`";
                $database->setQuery($query);
                $num = $database->loadResult();
                
                // Compute the limitstart
                $l = $fbConfig->messages_per_page;
                if( $num >= $l ) {
                    $ls = intval($num / $l) * $l;
                    $string = $this->setUrlVar($string, 'limitstart', $ls);
                }
            }
        }
        
        if( !isset($limitstart) && isset($limit) ) {
            $string = SEFTools::RemoveVariable($string, 'limit');
        }
        
        if( isset($limitstart) ) {
            $string = $this->setUrlVar($string, 'limit', $fbConfig->messages_per_page);
        }
        
        // Category listing
        if (isset($func) && ($func == 'showcat') && isset($catid) && ($catid == '0')) {
            $string = SEFTools::RemoveVariable($string, 'catid');
            $string = $this->setUrlVar($string, 'func', 'listcat');
        }
        
        // Go variable
        if (isset($Go)) {
            $string = SEFTools::RemoveVariable($string, 'Go');
        }
        
        return $string;
    }

    function create($string, &$vars)
    {
        global $database, $sefConfig;
        
        extract($vars);

        // JF translate extension.
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';

        // load params
        $this->params = SEFTools::getExtParams('com_kunena');
        $nonSefVars = array();
        $ignoreVars = array();

        $catRewrite = true;
        $msgRewrite = true;
        $usrRewrite = true;

        if ($msgRewrite || $catRewrite) {
            if ($catRewrite && !empty($catid)) {
                $query = "
        		SELECT `name`$jfTranslate
        		FROM `#__fb_categories`
        		WHERE `id` = $catid
        		";
                $database->setQuery($query);
                $catTitle = $database->loadResult();
            }
            if (isset($id)) $msgID = $id;
            elseif (isset($msg_id)) $msgID = $msg_id;
            elseif (isset($replyto)) $msgID = $replyto;
            else $msgID = null;
            if ($msgRewrite && !empty($msgID)) {
                $query = "
        		SELECT `subject`$jfTranslate
        		FROM `#__fb_messages`
        		WHERE `id` = $msgID
        		";
                $database->setQuery($query);
                $msgTitle = $database->loadResult();
            }
        }
        if ($usrRewrite && isset($userid)) {
            $query = "
        	SELECT `username`
        	FROM `#__users`
        	WHERE `id` = $userid
        	";
            $database->setQuery($query);
            $usrTitle = $database->loadResult();
        }

        // Set non-sef vars according to settings
        $doOptimize = in_array(@$do, array('reply', 'quote', 'delete', 'edit', 'move', 'sticky', 'lock'))
        || (isset($func) && $func == 'report');
        if ($this->params->get('idExclude', true) && $doOptimize) {
            if (isset($id)) $nonSefVars['id'] = $id;
            if (isset($replyto)) $nonSefVars['replyto'] = $replyto;
            if (isset($msg_id)) $nonSefVars['msg_id'] = $msg_id;
        }
        if ($this->params->get('optimize', true) && $doOptimize) {
            if (isset($fb_thread)) $nonSefVars['fb_thread'] = $fb_thread;
            if (isset($name)) $nonSefVars['name'] = $name;
        }
        // this needs to follow previous that use do
        if ($this->params->get('doExclude', true)) {
            if (isset($do)) $nonSefVars['do'] = $do;
            unset($do);
        }

        // if task is not set, use do
        if (empty($task) && isset($func) && $func == 'post' && isset($do)) {
            $task = $do;
            unset($func); unset($do);
        }

        if (empty($task) && isset($func)) {
            $task = $func;
            unset($func);
        }

        // First subdir
        if (!empty($option)) {
            $title[] = getMenuTitle($option, @$task, @$Itemid);
        }

        // Category
        if (isset($catTitle) && !empty($catTitle)) {
            $title[] = $catTitle;
        }

        // Topic
        if (isset($msgTitle) && !empty($msgTitle) && isset($task) && ($task != 'showcat')) {
            //$title[] = (!isset($do) && !isset($func)) ? $msgTitle.$sefConfig->suffix : $msgTitle;
            $title[] = $msgTitle;
        }

        // Selection
        if (@$task == 'latest' && $sel) {
            $task .= '-'.$sel;
        }

        // View
        if (isset($view)) {
            $title[] = (!isset($do) && !isset($func)) ? $view.$sefConfig->suffix : $view;
        }

        // User
        if (isset($usrTitle) && !empty($usrTitle)) {
            if ($func == 'fbprofile') {
                $title[] = 'users';
                $func = null;
            }
            if( @$task == 'showprf' ) {
                $task = null;
            }
            $title[] = !isset($do) ? $usrTitle.$sefConfig->suffix : $usrTitle;
        }

        if (isset($page) && $page > 1) {
            $title[] = $page;
        }

        // Func and do
        if (isset($do) || isset($func)) {
            if (isset($func)) $oper[] = $func;
            if (isset($do))   $oper[] = $do;
            $title[] = join('-', $oper).$sefConfig->suffix;
        }

        if( in_array(@$task, array('showcat', 'view')) ) {
            unset($task);
        }

        if (count($title) > 0) {
            $string = sef_joomsef::sefGetLocation($string, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars, $ignoreVars);
        }

        return $string;
    }
   
}
?>