<?php
/**
 * JEvents SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_events extends SefExt
{
    var $params;

    // Returns category name
    function GetCategoryName($id)
    {
        $database =& JFactory::getDBO();
        $sefConfig =& SEFConfig::getConfig();

        $jfTranslate = ($sefConfig->translateNames ? ', `id`' : '');
        $query = "SELECT `name`$jfTranslate FROM `#__categories` WHERE `id` = '$id' LIMIT 1";
        $database->setQuery($query);
        $obj = $database->loadObject();

        return (isset($obj->name) ? $obj->name : '');
    }

    // Returns event name
    function GetEventName($id)
    {
        $database =& JFactory::getDBO();
        $sefConfig =& SEFConfig::getConfig();

        $jfTranslate = ($sefConfig->translateNames ? ', `id`' : '');
        $query = "SELECT `title`$jfTranslate FROM `#__events` WHERE `id` = '$id' LIMIT 1";
        $database->setQuery($query);
        $obj = $database->loadObject();

        return (isset($obj->title) ? $obj->title : '');
    }

    function AddToDate($value, &$date) {
        // Appends or prepends the value according to params
        if( ($this->params->get('dateFormat', '1') == '1') ) {
            // Append value (yyyy-mm-dd)
            array_push($date, $value);
        } else {
            // Prepend value (dd-mm-yyyy)
            array_unshift($date, $value);
        }
    }

    // Alters the URL before SEF
    function beforeCreate(&$uri) {
        if( !is_null($uri->getVar('catids')) ) {
            if( $uri->getVar('catids') == '' ) {
                $uri->delVar('catids');
            }
            
            // Let's remove catids variable if it's set for multiple categories
            // (there is either one, or all of them - all of them is the same
            //  as if catids isn't present, causing duplicities)
            else if( strpos($uri->getVar('catids'), '|') !== false ) {
                $uri->delVar('catids');
            }
            
            // Also if task is view_cat, rename catids to catid (don't know why
            // they're creating it with catids, when that URL doesn't work anyway)
            else if( !is_null($uri->getVar('task')) && ($uri->getVar('task') == 'view_cat') ) {
                $uri->setVar('catid', $uri->getVar('catids'));
                $uri->delVar('catids');
            }
        }
    }

    function create(&$uri) {
        // Load the texts to use in URL
        $texts = SEFTools::getExtTexts('com_events');
        $this->params = SEFTools::getExtParams('com_events');

        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

        // Thanks to our beforeCreate function, catids always contains only one ID
        if( isset($catids) ) {
            $title[] = $this->GetCategoryName($catids);
        } else if( isset($catid) ) {
            $title[] = $this->GetCategoryName($catid);
        }

        // Date handling
        // -------------------------
        $datum = array();
        
        // Add year
        if( isset($year) ) {
            $this->AddToDate($year, $datum);
        }

        // Add month
        if( isset($month) ) {
            $this->AddToDate($month, $datum);
        }

        // Add day
        if( isset($day) ) {
            $this->AddToDate($day, $datum);
        }

        // Create date
        if( count($datum) > 0 ) {
            $title[] = join('-', $datum);
        }
        // -------------------------

        // Add event name
        if( isset($agid) ) {
            $title[] = $this->GetEventName($agid);
        }

        // Add task
        if( isset($task) ) {
            if( in_array($task, array_keys($texts)) ) {
                $title[] = $texts[$task];
                unset($task);
            } else if( in_array($task, array('view_day', 'view_detail')) ) {
                unset($task);
            }
        }

        // Save the URL in database
        $newUri = $uri;
        if (count($title) > 0) {
            $nonSefVars = array();
            if( isset($limitstart) )    $nonSefVars['limitstart'] = $limitstart;
            if( isset($limit) )         $nonSefVars['limit'] = $limit;
            if( isset($keyword) )       $nonSefVars['keyword'] = $keyword;
            if( isset($push) )          $nonSefVars['push'] = $push;
            if( isset($pop) )           $nonSefVars['pop'] = $pop;

            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        }

        return $newUri;
    }
}