<?php
/**
 * .JoomSuite Content SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_resource extends SefExt
{
    function GetCategoryTitle($id) {
        $db =& JFactory::getDBO();
        
        $db->setQuery("SELECT id, name FROM #__js_res_category WHERE id = $id");
        $c = $db->loadObject();
        
        return $c->name;
    }
    
    function GetTagTitle($id) {
        $db =& JFactory::getDBO();
        
        $db->setQuery("SELECT id, tag FROM #__js_res_tags WHERE id = $id");
        $c = $db->loadObject();
        
        return $c->tag;
    }
    
    function GetArticleTitle($id) {
        $db =& JFactory::getDBO();
        
        $db->setQuery("SELECT id, title FROM #__js_res_record WHERE id = $id");
        $c = $db->loadObject();
        
        return $c->title;
    }
    
    function beforeCreate(&$uri) {
        if( !is_null($uri->getVar('category_id', null)) ) {
            if( intval($uri->getVar('category_id', null)) == 0 ) {
                $uri->delVar('category_id');
            }
        }
        
        if( $uri->getVar('view') == 'article' ) {
            $uri->delVar('view');
            $uri->setVar('controller', 'article');
        }
    }
    
    function create(&$uri) {
        // Load the texts to use in URL
        $texts = SEFTools::getExtTexts('com_resource');
        
        // Use this to get variables from the original Joomla! URL, such as $task, $page, $id, $catID, ...
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

        if( isset($category_id) ) {
            $title[] = $this->GetCategoryTitle(intval($category_id));
        }
        
        if( ($uri->getVar('controller') == 'article') && ($uri->getVar('layout') == 'form') ) {
            if( isset($article) ) {
                $title[] = $this->GetArticleTitle(intval($article));
                $title[] = $texts['edit_article'];
            } else {
                $title[] = $texts['new_article'];
            }
        } else {
            
            if( isset($article) ) {
                $title[] = $this->GetArticleTitle(intval($article));
            }
            
            if( $uri->getVar('view_what') == 'tag' ) {
                $title[] = $texts['tag'];
                $title[] = $this->GetTagTitle(intval($tag));
            }
            else if( $uri->getVar('view_what') == 'created' ) {
                if( isset($section_id) ) {
                    $title[] = $this->GetCategoryTitle(intval($section_id));
                }
                $title[] = $texts['created'];
            }
            else if( $uri->getVar('view') == 'tags' ) {
                $title[] = $texts['tag_cloud'];
            }
            
            if( isset($filter_alpha) ) {
                if( strtolower($filter_alpha) == 'all' ) {
                    $title[] = $texts['all'];
                } else {
                    $title[] = $filter_alpha;
                }
            }
            
            if( isset($filter_reset) && ($filter_reset == 1) ) {
                $title[] = $texts['filter_reset'];
            }
        }
        
        if( $uri->getVar('format') == 'feed' ) {
            $title[] = $type;
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $nonSefVars = array();
            if( isset($vars['limit']) )         $nonSefVars['limit'] = $vars['limit'];
            if( isset($vars['limitstart']) )    $nonSefVars['limitstart'] = $vars['limitstart'];
            if( isset($vars['date']) )          $nonSefVars['date'] = $vars['date'];
            
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        }
        
        return $newUri;
    }
}
?>
