<?php
/**
 * Lyften Bloggie SEF extension for Joomla!
 *
 * @author      $Author: Daniel Stainback $
 * @copyright   Lyften, http://www.Lyften.com
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_lyftenbloggie extends SefExt
{
    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        if (!is_null($uri->getVar('limit')))
            $this->nonSefVars['limit'] = $uri->getVar('limit');
        if (!is_null($uri->getVar('limitstart')))
            $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
        if (!is_null($uri->getVar('return')))
            $this->nonSefVars['return'] = $uri->getVar('return');
        
        // Find the token variable and remove it
        $vars = $uri->getQuery(true);
        $keys = array_keys($vars);
        foreach ($keys as $key) {
            if (strlen($key) == 32 && preg_match('/^[0-9a-f]+$/i', $key)) {
                $this->ignoreVars[$key] = $uri->getVar($key);
            }
        }
    }
    
    function beforeCreate(&$uri)
    {
        // Remove the id if edit mode
        if ($uri->getVar('view') == 'author' && $uri->getVar('mode') == 'edit') {
            $uri->delVar('id');
        }
        
        // Remove category if not needed
        if ($uri->getVar('view') == 'entry' && !is_null($uri->getVar('id'))) {
            $uri->delVar('category');
        }
        
        // Remove date if not needed
        $this->params = SEFTools::GetExtParams('com_lyftenbloggie');
        if ($this->params->get('date_inc', '1') == '0') {
            $uri->delVar('year');
            $uri->delVar('month');
            $uri->delVar('day');
        }
        
        // Remove the part after ':' from variables
        if (!is_null($uri->getVar('id')))    SEFTools::fixVariable($uri, 'id');
    }
    
    function GetEntry($id)
    {
        $database   =& JFactory::getDBO();
        $query = 'SELECT e.id, e.title, c.title AS cattitle'
                . ' FROM #__bloggies_entries AS e'
                . ' LEFT JOIN #__bloggies_categories AS c ON c.id = e.catid'
                . ' WHERE e.id = ' . ( int ) $id;
        $database->setQuery ( $query );
        $row = $database->loadObject();
        
        if (is_null($row)) {
            return null;
        }
        
        return $row;
    }
    
    function GetAuthorName($id)
    {
        $id = intval($id);
        $user = JFactory::getUser($id);
        
        if (is_null($user)) {
            return null;
        }
        
        return $user->name;
    }
    
    function create(&$uri) {
		$sefConfig 	=& SEFConfig::getConfig();
		$database 	=& JFactory::getDBO();
        $this->params 	= SEFTools::GetExtParams('com_lyftenbloggie');
        $vars 		= $uri->getQuery(true);
        extract($vars);

		$LBloggieName = JoomSEF::_getMenuTitle($option, @$this_task);
		
        // Set title.
        $title = array();

        switch (@$view) {
			case 'entry' :
			case 'author':
				if ( !is_null($uri->getVar('id')) ) {
				    $row = $this->GetEntry($id);					
					
				    if (is_null($row)) {
				        // Not found
				        return $uri;
				    }
				    
					$title [] = $LBloggieName;
					$title [] = ($row->cattitle) ? $row->cattitle : JText::_('Uncategorized');
					if ($this->params->get('date_inc', '1') == '1') {
					    if (isset($year)) {
					        $title[] = $year;
					    }
                        if (isset($month)) {
                            $title[] = $month;
                        }
                        if (isset($day)) {
                            $title[] = $day;
                        }
					}
					$title [] = $row->title;
					
					if ($uri->getVar('layout') == 'form') {
						$title [] = JText::_('Edit');
					}
					elseif ($uri->getVar('task') == 'remove') {
					    $title[] = JText::_('Delete');
					}
				} else {
					if (!is_null($uri->getVar('task')) && ($uri->getVar('task') == 'add')){
						$title [] = $LBloggieName;
						$title [] = JText::_('add');
					} else {
						$title [] = $LBloggieName;
					}
				}
				
				if ($view == 'author') {
                    switch ($uri->getVar('layout')) {
                        case 'pending':
                            $title[] = JText::_('Pending Entries');
                            break;
                        case 'profile':
                            $title[] = JText::_('My Profile');
                            break;
                        case 'form':
                            $title[] = JText::_('New Entry');
                            break;
                        case 'edit':
                            $title[] = JText::_('Edit');
                            break;
                        default:
                            $title[] = JText::_('My Entries');
                            break;
                    }
				}
			break;
			
			case 'comments' :
				if ( !is_null($uri->getVar('id')) ) {
                    $row = $this->GetEntry($id);                    
                    
                    if (is_null($row)) {
                        // Not found
                        return $uri;
                    }
                    
                    $title [] = $LBloggieName;
                    $title [] = ($row->cattitle) ? $row->cattitle : JText::_('Uncategorized');
                    $title [] = $row->title;
                    
				    $title [] = JText::_('Comments');
				} else {
					$title [] = $LBloggieName;
				}
				break;
			
			case 'lyftenbloggie' :
				$title [] = $LBloggieName;
				break;
			
			default :
				if ($uri->getVar('task') == 'trackback') {
						$title [] = $LBloggieName;
						$title [] = JText::_('trackback');
						$title [] = $id;
				}
				elseif ($uri->getVar('task') == 'feed') {
					$title [] = $LBloggieName;
					$title[] = $task;
					$title[] = ($type)?$type:'rss';
				}
				elseif ($uri->getVar('task') == 'publish') {
                    $title [] = $LBloggieName;
                    
				    if (isset($id)) {
                        $row = $this->GetEntry($id);                    
                        
                        if (is_null($row)) {
                            // Not found
                            return $uri;
                        }
                        
                        $title [] = ($row->cattitle) ? $row->cattitle : JText::_('Uncategorized');
                        $title [] = $row->title;
				    }
				    
				    if (isset($publish)) {
				        $publish = intval($publish);
                        if ($publish == 1) {
                            $title[] = JText::_('Publish');
                        }
                        elseif ($publish < 1) {
                            $title[] = JText::_('Unpublish');
                        }
				    }
				}
				
				if ( !is_null($uri->getVar('category')) ) {
					$title [] = $LBloggieName;
					$title [] = JText::_('Category');
					$title [] = $category;
				}

				if ( !is_null($uri->getVar('author')) ) {
					$title [] = $LBloggieName;
					$title [] = JText::_('Author');
					$name = $this->GetAuthorName($author);
					if (is_null($name)) {
					    $title [] = $author;
					}
					else {
					   $title [] = $name;
					} 
				}
				
				if ( !is_null($uri->getVar('tag')) ) {
					$title [] = $LBloggieName;
					$title [] = JText::_('Tag');
					$title [] = $tag.'/'.$entry->created_by;
				}
				
				if ( !is_null($uri->getVar('archive')) ) {
					$title [] = $LBloggieName;
					$title [] = str_replace('+', '/', $archive);
					$title [] = $LBloggieName;
				}
				
				if ( !is_null($uri->getVar('show')) ) {
					$query = 'SELECT e.id, e.title, c.title AS cattitle'
							. ' FROM #__bloggies_permalinks AS p'
							. ' LEFT JOIN #__bloggies_entries AS e ON e.id = p.entryid'
							. ' LEFT JOIN #__bloggies_categories AS c ON c.id = e.catid'
							. ' WHERE p.permalink = ' . $database->Quote( $database->getEscaped($show) )
							;
					$database->setQuery ( $query );
					$row = $database->loadObjectList();

					if ($database->getErrorNum()) die( $database->stderr());
					elseif (@count($row) > 0 && !empty($row[0]->title)) {
						$title [] = $LBloggieName;
						$title [] = ($row[0]->cattitle)?$row[0]->cattitle:JText::_('uncategorized');
						$title [] = $row[0]->title;
					}
				}
				
				if(empty($title)) $title [] = $LBloggieName;	
				break;
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $this->_createNonSefVars($uri);
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang, $this->nonSefVars, $this->ignoreVars);
        }

        return $newUri;
    }
}
?>
