<?php

/**
 * Booking SEF extension for Joomla!
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @license     GNU/GPLv3 http://www.gnu.org/copyleft/gpl.html
 */

// 
defined ( '_JEXEC' ) or die ( 'Restricted access.' );

require_once(JPath::clean(JPATH_ROOT.'/components/com_booking/router.php'));

class SefExt_com_booking extends SefExt {
	
	function __construct() {
		$this->replaces = BookingReplaces();
		parent::__construct();		
	}
	
	/**
	 * (non-PHPdoc)
	 * @see SefExt::beforeCreate()
	 */
	function beforeCreate(&$uri) {
		if ($uri->getVar('id'))
			$uri->setVar('id', (int) $uri->getVar('id'));		
	}
	
	/**
	 * (non-PHPdoc)
	 * @see SefExt::create()
	 */
	function create(&$uri) {
		
		$vars = $uri->getQuery(true);
		$title = array();
		
		$option = JArrayHelper::getValue($vars, 'option');
		$lang = JArrayHelper::getValue($vars, 'lang');
		$Itemid = JArrayHelper::getValue($vars, 'Itemid');
		
		unset($vars['option']);
		if (isset($vars['lang']))
			unset($vars['lang']);
		if (isset($vars['Itemid']))
			unset($vars['Itemid']);
		
		$view = JArrayHelper::getValue($vars, 'view');
		$id = JArrayHelper::getValue($vars, 'id');
		
		if (($view == 'subjects' || $view == 'subject') && $id) {
			$db = JFactory::getDbo();
			do {
				$query = $db->getQuery(true);
				if ($this->params->get('show_parent_item', 0) == 1) // show last parent item only
					$query->select('p.title'); // select last parent item title
				$query->select('s.title'); // title of current item
				if ($this->params->get('show_parent_item', 0) == 2) // show all parents
					$query->select('s.parent'); // select last parent item id for next loop
				$query->from('#__booking_subject AS s');
				if ($this->params->get('show_parent_item', 0) == 1) // show last parent item only
					$query->leftJoin('#__booking_subject AS p ON s.parent = p.id'); // join for last parent item title
				$query->where('s.id = ' . (int) $id);
				$row = $db->setQuery($query)->loadRow();
				if ($this->params->get('show_parent_item', 0) == 2) { // show all parents
					array_unshift($title, $row[0]); // store current item title
					$id = $row[1]; // switch to parent item for next loop
				} else { // no parent or last parent only
					$title = $row; // store current item title and last parent item title
					$id = null; // no next loop
				}
			} while($id);
			unset($vars['id']);
			unset($vars['view']);
			
		} elseif($view && isset($this->replaces[$view])) {
			$title[] = $this->replaces[$view];
			unset($vars['view']);
		}
		
		if (empty($title))
			$title[] = JoomSEF::_getMenuTitle($option, $lang, $Itemid);
		
		return JoomSEF::_sefGetLocation($uri, $title, null, null, null, null, $vars);
	}
}