<?php
/**
 * JoomDOC SEF extension for Joomla!
 *
 * @author      ARTIO s.r.o.
 * @copyright   Copyright 2011, ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @license     http://www.artio.net/joomsef/licence-ext
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_joomdoc extends SefExt
{
    var $params;
	var $origmetadesc='';
	var $origmetakey='';
	//var $path=''; //variable to store original non SEF path. because there are duplicates. Rather fix in JoomDOC.
	
	function getDocumentTitle($path,$dirs=2)
	{
		//TODO: path clean "+" and so on
		$database =& JFactory::getDBO();
		$prefix = '';
		
		//get path segments
		$paths = explode('/',$path);
		if (count($paths)==1) //not exploded by slash, try to use backlash
			$paths = explode('\\',$path);

		//$origPath = $paths;
			
		//try to replace each path segment by document title (if created)
		foreach ($paths as $key => &$segment)
		{
			//search by full alias 
			$database->setQuery('SELECT id, title FROM #__joomdoc WHERE full_alias LIKE \''.addslashes($prefix.$segment).'\' ORDER BY version DESC LIMIT 1');
			$row = $database->loadAssoc();
				
			if (!empty($row)){
				$segment = $row['title'];}
			else {
				//else search by path
				$database->setQuery('SELECT id, title, full_alias FROM #__joomdoc WHERE path LIKE \''.addslashes($prefix.$segment).'\' ORDER BY version DESC LIMIT 1');
				$row = $database->loadAssoc();

				if (!empty($row)){
					$segment = $row['title'];
					/*
					$full_alias = explode('/',$row['full_alias']);
					$origPath[$key] = $full_alias[count($full_alias)-1]; //update original non SEF URL path by full_alias (to prevent duplicates)
					*/
				}
			}
			$prefix.=$segment.'\\'; //append prefix, because next loop will be deeper
		}
		
		//$this->path = implode('/',$origPath);
		
		if ($dirs==2)
			return $paths;
		else
			return array_slice($paths,-($dirs+1),($dirs+1)); //return specified deph of directories
	}

    function create(&$uri) {
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        JPlugin::loadLanguage('com_joomdoc');
        
        if (isset($path) AND empty($path))
        	unset($path);
        
        $this->params = SEFTools::getExtParams('com_joomdoc');
		
        //append menu title
		$title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
		
		if (isset($view) AND $view=='documents'){
        	if (isset($path)){ //if no path specified, /document/ must be appended or joomla create url with duplicate roots(? TODO)
        		$title = array_merge($title, $this->getDocumentTitle($path,$this->params->get('directory', '2')));
				unset($view);}
		}
		
    	if (isset($task) AND $task=='document.download'){
        	if (isset($path))
        		$title = array_merge($title, $this->getDocumentTitle($path,$this->params->get('directory', '2')));
        			
        	if (JText::_('JOOMDOC_DOWNLOAD')!='JOOMDOC_DOWNLOAD')
        		$title[] = JText::_('JOOMDOC_DOWNLOAD');
        	else
        		$title[]='download';
        			
			unset($task);
		}
		
		/*
		if (!empty($this->path)){ //update also original non SEF path, because there can be changes (path replaced by full_alias to prevent duplicate URLs)
			$uri->setVar('path',$this->path);
			echo $this->path;}
		*/
			
        if (isset($view)){
        	$title[] = $view;
        	unset($view);}
        	
        if (isset($task)){
        	$title[] = $task;
        	unset($task);}    
        
        
		$nonSefVars = array();
        if (isset($limit))       $nonSefVars['limit'] = $limit;
        if (isset($limitstart))  $nonSefVars['limitstart'] = $limitstart;
		
        $newUri = $uri;
        if (count($title) > 0)
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        return $newUri;
    }
}
?>