<?php
/**
 * Phoca Guestbook SEF extension for ARTIO JoomSEF
 * 
 * @package   JoomSEF
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_phocaguestbook extends SefExt
{
	private function _getGuestBookTitle($id)
	{
		$field = 'title';
        if( SEFTools::UseAlias($this->params, 'guestbook_alias') ) {
            $field = 'alias';
        }
		$title=array();
		$db=JFactory::getDBO();
		
		$query="SELECT id, ".$field." AS title, language \n";
		$query.="FROM #__phocaguestbook_books \n";
		$query.="WHERE id=".$id;
		$db->setQuery($query);
		$book_o=$db->loadObject();
		
		$title[]=($this->params->get('book_id')?($book_o->id."-"):"").$book_o->title;
		
		$this->lang=$book_o->language;
		
		return $title;
	}
	
	private function _getItemTitle($id) {
		$db=JFactory::getDBO();
		$title=array();
		
		$query="SELECT id, title, language \n";
		$query.="FROM #__phocaguestbook_items \n";
		$query.="WHERE id=".$id;
		$db->setQuery($query);
		$item_o=$db->loadObject();
		
		$title[]=($this->params->get('item_id')?($item_o->id."-"):"").$item_o->title;
		
		$this->lang=$item_o->language;
		
		return $title;
	}
	
	function _processPagination(&$uri) {
		if(!isset($this->nonSefVars)) {
			$this->nonSefVars=array();
		}
		$sefConfig =& SEFConfig::getConfig();
        
        $menu_params = null;
        if (!is_null($uri->getVar('Itemid'))) {
            $menuitem = JoomSEF::_getMenuItemInfo(null, null, $uri->getVar('Itemid'));
            if (is_object($menuitem) && isset($menuitem->params) && is_object($menuitem->params)) {
                $menu_params = $menuitem->params;
            }
        }
        if (is_null($menu_params)) {
            $menu_params = new JRegistry();
        }
        
		$vars = $uri->getQuery(true);
        extract($vars);
        
        $title = array();
        switch($view) {
        	case 'phocaguestbook':
        	case 'guestbook':
        		if($menu_params->get('show_pagination_limit')==1) {
	        			if(isset($limitstart)) {
	        				$nonSefVars["limitstart"]=$limitstart;
	        			}
	        		} else {
	        			$limit=JComponentHelper::getParams('com_phocaguestbook')->get("default_pagination","20");
	        			if($limit>0 && isset($limitstart)) {
		        			$page = intval($limitstart / $limit)  + 1;
		        			if($page!=1) {
								$pagetext = strval($page);
						        if (($cnfPageText = $sefConfig->getPageText())) {
						            $title[] = str_replace('%s', $page, $cnfPageText);
						        }
							}
	        			}
	        		}
	        	break;
        }
        return $title;
	}
	
	function getNonSefVars(&$uri) {
    	$this->_processPagination(&$uri);
    	return array($this->nonSefVars,array());
    }
	
    function create(&$uri) {
       
        $this->params =& SEFTools::getExtParams('com_phocaguestbook');
        $title=array();
        $this->nonSefVars=array();
        $this->lang=null;
        
        $vars = $uri->getQuery(true);
        extract($vars);
        
        $title[] = JoomSEF::_getMenuTitleLang(@$option, $this->lang, @$Itemid);
        
        switch($view) {
        	case 'phocaguestbook':
        	case 'guestbook':
        		$title=array_merge($title,$this->_getGuestBookTitle($id));
        		if(isset($mid)) {
        			$title=array_merge($title,$this->_getItemTitle($mid));
        			$title[]=$task;
        		} else {
	    			$title=array_merge($title,$this->_processPagination($uri));    		
        		}
        		break;
        }


        $newUri = $uri;
        if (count($title) > 0) {
        	if(is_null($this->lang)) {
        		$lang=$this->lang;
        	}
        	$newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang,$this->nonSefVars,null,null,null,true);	
        }
        
        return $newUri;
    }
    
    function getURLPatterns($item) {
    	$urls=array();
    	if($item->getTableName()=='#__phocaguestbook_books') {
    		$urls[]="index\.php\?option=com_phocaguestbook&id=".$item->id."&view=guestbook";
    		$urls[]="index\.php\?option=com_phocaguestbook&controller=phocaguestbook&id=".$item->id."&";
    	} else if($item->getTableName()=='#__phocaguestbook_items') {
    		$urls[]="index\.php\?option=com_phocaguestbook&controller=phocaguestbook&id=".$item->catid."(&lang=[a-z]+)?(&limitstart=[0-9]+)?&mid=".$item->id."&";
    	}
    	
    	return $urls;
    }
}
?>
