<?php
/**
 * JoomSport SEF extension for Joomla!
 *
 * @author      $Author: Adam Berger$
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @license     GNU/GPLv3 http://www.gnu.org/copyleft/gpl.html
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_joomsport extends SefExt
{
	private $database = null;	
	private $sid = null;
	private $id = null;
	private $doSeason = true;
	private $useMenuTitle = null;
	private $doGroup = true;
	private $doOthers = false;
	
    function beforeCreate(&$uri) {
    	$sid = $uri->getVar('sid');
    	if(!empty($sid)){
    		$this->sid = $sid;
    	}
    	$task = $uri->getVar('task');
    	if(@$task == "view_match" || @$task == "player"){
    		$this->id = $uri->getVar('id');    		    		
    	}
    	$view = $uri->getVar('view');
    	if (@$view == 'matchday' || @$view == 'player' ){
    		$this->id = $uri->getVar('id'); 
    	}	
    }

    
    function create(&$uri) {
    	$sefConfig =& SEFConfig::getConfig();
        $this->database =& JFactory::getDBO();
        $this->params =& SEFTools::getExtParams('com_joomsport');
        $vars = $uri->getQuery(true);
		extract($vars);
		$title = array();  				
		
		if(!isset($sid)&&(!empty($this->sid))){
			$uri->setVar('sid',$this->sid);
		}
		if( $this->params->get('show_MenuItem','0') ) {
			if( !empty($Itemid) ) {     		
	     		 	$title[] = JoomSEF::_getMenuTitle(@$option, null, @$Itemid);            
			}
		}	
		if (@$view == "ltable"){
			$title[] = "table";
			if(isset($gr_id)&&(!empty($gr_id))){			
				$TourGroup = $this->getTournamentAndGroup($gr_id);
				if(count($TourGroup) > 0){
					if(isset($TourGroup['tournament'])&& !empty($TourGroup['tournament']))
						$title[] = $TourGroup['tournament'];
					if(isset($TourGroup['group'])&& !empty($TourGroup['group']))
						$title[] = $TourGroup['group'];
					$this->doGroup = false;	
				}
			}			
		}
   		else if (@$view == "matchday"){			
			$title[] = "match";	
			if(isset($this->id)&&(!empty($this->id))){
				$matchDay = $this->getMatchday($this->id);
				if(!empty($matchDay))
				$title[] = $this->id;
				$title[] = $matchDay;
				
			}
		}
		else if (@$view == "player"){
			$this->doSeason = true;
			$title[] = "player";		
			if(isset($this->id)&&(!empty($this->id))){
				$player = $this->getPlayerName($this->id);				
				if(!empty($player)){
					$title[] = $this->id;
					$title[] = $player;					
				}
			}
			 
		}	
    	else if (@$view == "blteam"){
			$title[] = "team-details";			
	    	if(isset($tid)&&(!empty($tid))){			
				$team = $this->getTeamName($tid);
				if($team){
					$title[] = $tid;	
					$title[] = $team;
				}
								
	    	}						
		}
		else if (@$view == "calendar"){			
			$title[] = "calendar";	
		}
		
		else if (@$task == "calendar"){			
			$title[] = "calendar";	
		}else if(@$task == "view_match"){
			$title[] = "match-details";
			if(isset($this->id)&&(!empty($this->id))){
				$teamsMatch = $this->getTeamsMatch($this->id);
				if(!empty($teamsMatch[0])&&!empty($teamsMatch[1]))
				{
					$title[] = $this->id;
					$title[] = $teamsMatch[0]."-".$teamsMatch[1];					
				}
									
			}
		} else if (@$task == "player"){
			$this->doSeason =false;
			$title[] = "player";		
			if(isset($this->id)&&(!empty($this->id))){
				$player = $this->getPlayerName($this->id);				
				if(!empty($player)){
					$title[] = $this->id;
					$title[] = $player;					
				}
			}
			 
		}
    	else{
			$this->doOthers = true;
		}
		
		if ($this->doOthers){
	    	if(isset($tid)&&(!empty($tid))){			
					$team = $this->getTeamName($tid);
					if($team)
						$title[] = $team;
				}
	    	
			
	    	if($this->doGroup){
		    	if(isset($gr_id)&&(!empty($gr_id))){			
					$group = $this->getGroupName($gr_id);
					if($group)
						$title[] = $group;
				}
	    	}
	    	
	    	
			if($this->doSeason){
				if(isset($this->sid)&&(!empty($this->sid))){			
					$season = $this->getSeasonName($this->sid);
					if($season){
						$title[] = $season;
						
					}
				}
	    	}
		}
		
	
		$newUri = $uri;
        if (count($title) > 0) {
            // Generate meta tags
            $metatags = $this->getMetaTags();        
            $priority = null;            
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$vars['lang'], null, $this->ignoreVars, $metatags, $priority);
        }
        
		return $newUri;
    }
    
   function getMatchday($id){
   		$this->database->setQuery("SELECT m_name as matchday FROM #__bl_matchday WHERE `id` = '$id'");   
        return $this->getSimpleResult("matchday");
   } 
    
    function getTeamsMatch($id){
    	$this->database->setQuery("SELECT t1.t_name as home,t2.t_name as away FROM #__bl_teams t1 LEFT JOIN #__bl_match m ON m.`team1_id` = t1.id LEFT JOIN #__bl_teams t2 ON m.`team2_id` = t2.id WHERE m.id=".$id);    	
		 $rows = $this->database->loadObjectList();
    	if ($this->database->getErrorNum()) die( $this->database->stderr());        
		elseif (@count($rows) > 0 && !empty($rows[0]->home)) {			
          	$data[] = $rows[0]->home;
            $data[] = $rows[0]->away;
            return $data;
    	}
    }
    function getTournamentAndGroup($gr_id){
    	$this->database->setQuery("SELECT g.group_name as 'group' ,t.name as 'tournament' FROM `#__bl_groups` g LEFT JOIN #__bl_seasons s ON s.s_id = g.s_id LEFT JOIN #__bl_tournament t ON s.t_id=t_id WHERE g.id = '$gr_id' LIMIT 1");
    	$rows = $this->database->loadObjectList();
    	if ($this->database->getErrorNum()) die( $this->database->stderr());   
    	elseif (@count($rows) > 0 && !empty($rows[0]->group)) {			
          	$data['group'] = $rows[0]->group;
            $data['tournament'] = $rows[0]->tournament;
            return $data;
    	}   
    }
    
    function getPlayerName ($id){
    	$this->database->setQuery("SELECT CONCAT (`first_name`,' - ',`last_name`) as name FROM `#__bl_players` WHERE `id` = '$id'");   
        return $this->getSimpleResult("name");
    }
    
	function getTeamName($tid){    	
     $this->database->setQuery("SELECT `t_name` AS `team` FROM `#__bl_teams` WHERE `id` = '$tid'");   
        return $this->getSimpleResult("team");
    }
    
    function getSeasonName($si){    	
     $this->database->setQuery("SELECT `s_name` AS `season` FROM `#__bl_seasons` WHERE `s_id` = '$si'");   
        return $this->getSimpleResult("season");
    }
    
	function getGroupName($gr_id){    	
     $this->database->setQuery("SELECT `group_name` AS `group` FROM `#__bl_groups` WHERE `id` = '$gr_id'");
        return $this->getSimpleResult("group");
    }
    
    function getSimpleResult($object){
      $rows = $this->database->loadObjectList();
          if ($this->database->getErrorNum()) die( $this->database->stderr());
          elseif (@count($rows) > 0 && !empty($rows[0]->$object)) {
            $data = $rows[0]->$object;
            if(!empty($data))
            	return $data;
            else
            	return false;	
          }
    }
	
}