<?php
/**
 * JoomDOC - Joomla! Document Manager
 * @version $Id: mod_docman_mostdown.php 798 2009-02-12 14:42:04Z mathias $
 * @package JoomDOC
 * @copyright (C) 2003-2008 The DOCman Development Team
 *            Improved to JoomDOC by Artio s.r.o.
 * @license see COPYRIGHT.php
 * @link http://www.artio.net Official website
 * JoomDOC is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 **/
defined('_JEXEC') or die('Restricted access');

// you can define the following parameters at administration:


// limits = number of downloads to display (default = 3);
// show_icon = displays a generic icon near the name of the document, using the theme defined (default = 1) No=0; Yes=1
// show_counter = displays the number of downloads (default = 1) No=0; Yes=1


$docman = JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_joomdoc' . DS . 'docman.class.php';
$factory = JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_joomdoc' . DS . 'helpers' . DS . 'factory.php';

if (file_exists($docman) && file_exists($factory)) {
    
    require_once $docman;
    require_once $factory;
    
    $_DOCMAN = DocmanFactory::getDocman();
    $_DMUSER = DocmanFactory::getDmuser();
    
    $_DOCMAN->setType(_DM_TYPE_MODULE);
    
    require_once ($_DOCMAN->getPath('classes', 'utils'));
    require_once ($_DOCMAN->getPath('classes', 'file'));
    require_once ($_DOCMAN->getPath('classes', 'model'));
    
    // get the parameters
    $limits = abs($params->def('limits', 3));
    $show_icon = abs($params->def('show_icon', 1));
    $show_counter = abs($params->def('show_counter', 1));
    
    $menuid = $_DOCMAN->getMenuId();
    
    $html = '';
    
    $rows = DOCMAN_Docs::getDocsByUserAccess(0, 'hits', 'DESC', $limits);
    
    if (count($rows)) {
        $html .= '<ul class="dm_mod_mostdown">';
        foreach ($rows as $row) {
            $doc = new DOCMAN_Document($row->id);
            
            $url = JRoute::_('index.php?option=com_joomdoc&task=cat_view&Itemid=' . $menuid . '&gid=' . $row->catid);
            $html .= '<li><a href="' . $url . '">';
            
            if ($show_icon)
                $html .= '<img border="0" src="' . $doc->getPath('icon', 1, '16x16') . '" alt="file icon" />';
            
            $html .= $doc->getData('dmname');
            
            if ($show_counter)
                $html .= ' (' . $doc->getData('dmcounter') . ')';
            
            $html .= '</a></li>';
        }
        $html .= '</ul>';
    } else {
        $html .= '<br />' . JText::_('No Documents');
    }
    
    echo $html;
}